/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.refactoring.convertToClass;

import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.refactoring.convertToClass.JSToClassConversionConstructorFunction;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JSToClassConversionResults {
    private final MultiMap<String, UsageInfo> myDuplicateProperties = new MultiMap();
    private final List<UsageInfo> myNotConvertedStaticDeclarations = new ArrayList<UsageInfo>();
    private final List<UsageInfo> myNotConvertedUsages = new ArrayList<UsageInfo>();

    public boolean isDuplicate(@NotNull String name, @NotNull UsageInfo usageInfo) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "isDuplicate"));
        }
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "isDuplicate"));
        }
        boolean hasDuplicate = this.myDuplicateProperties.containsKey((Object)name);
        this.myDuplicateProperties.putValue((Object)name, (Object)usageInfo);
        return hasDuplicate;
    }

    public void notConvertedStatic(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "notConvertedStatic"));
        }
        this.myNotConvertedStaticDeclarations.add(usageInfo);
    }

    public void notConverted(@NotNull UsageInfo usageInfo) {
        if (usageInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageInfo", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "notConverted"));
        }
        this.myNotConvertedUsages.add(usageInfo);
    }

    public Set<String> filterDuplicates(@NotNull JSToClassConversionConstructorFunction constructorFunction) {
        if (constructorFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorFunction", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "filterDuplicates"));
        }
        return JSToClassConversionResults.filterDuplicateProperties(constructorFunction, this.myDuplicateProperties);
    }

    @NotNull
    private static Set<String> filterDuplicateProperties(@NotNull JSToClassConversionConstructorFunction constructorFunction, MultiMap<String, UsageInfo> duplicateProperties) {
        if (constructorFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorFunction", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "filterDuplicateProperties"));
        }
        Iterator iterator = duplicateProperties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry next = (Map.Entry)iterator.next();
            assert (((Collection)next.getValue()).size() != 0);
            if (((Collection)next.getValue()).size() > 1) continue;
            UsageInfo usageInfo = (UsageInfo)((Collection)next.getValue()).iterator().next();
            JSAssignmentExpression innerProperty = constructorFunction.getInnerProperty((String)next.getKey());
            if (usageInfo.getElement() != null && innerProperty != null && !usageInfo.getElement().equals(innerProperty)) continue;
            iterator.remove();
        }
        Set set = duplicateProperties.keySet();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "filterDuplicateProperties"));
        }
        return set;
    }

    public List<Pair<String, UsageInfo>> previewDuplicates(@NotNull JSToClassConversionConstructorFunction constructorFunction) {
        if (constructorFunction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constructorFunction", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "previewDuplicates"));
        }
        Set<String> set = JSToClassConversionResults.filterDuplicateProperties(constructorFunction, (MultiMap<String, UsageInfo>)new MultiMap(this.myDuplicateProperties));
        if (set.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Pair<String, UsageInfo>> result = new ArrayList<Pair<String, UsageInfo>>();
        for (String s : set) {
            result.addAll(ContainerUtil.map((Collection)this.myDuplicateProperties.get((Object)s), info -> Pair.create((Object)s, (Object)info)));
            JSAssignmentExpression innerProperty = constructorFunction.getInnerProperty(s);
            if (innerProperty == null) continue;
            result.add((Pair<String, UsageInfo>)Pair.create((Object)s, (Object)new UsageInfo((PsiElement)innerProperty.getDefinitionExpression().getExpression())));
        }
        return result;
    }

    public List<UsageInfo> getNotConvertedUsages() {
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        list.addAll(this.myNotConvertedStaticDeclarations);
        list.addAll(this.myDuplicateProperties.values());
        return list;
    }

    @NotNull
    public List<UsageInfo> getNotConvertedWithoutDuplicates() {
        ArrayList<UsageInfo> list = new ArrayList<UsageInfo>();
        list.addAll(this.myNotConvertedUsages);
        ArrayList<UsageInfo> arrayList = list;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/refactoring/convertToClass/JSToClassConversionResults", "getNotConvertedWithoutDuplicates"));
        }
        return arrayList;
    }
}

