/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.service;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;

public class JSLanguageServiceAnnotationResult {
    public static final String ERROR_CATEGORY = "error";
    private final int myColumn;
    private final int myLine;
    private final int myEndLine;
    private final int myEndColumn;
    private final String myErrorText;
    private final String myCategory;
    private final String myFileAbsoluteSystemDependPath;

    public int getColumn() {
        return this.myColumn;
    }

    public int getLine() {
        return this.myLine;
    }

    public String getErrorText() {
        return this.myErrorText;
    }

    public String getCategory() {
        return this.myCategory;
    }

    public int getErrorCode() {
        String prefix = "TS";
        if (this.myErrorText != null && this.myErrorText.startsWith(prefix)) {
            int endCode = this.myErrorText.indexOf(":");
            if (endCode == -1) {
                return -1;
            }
            String code = this.myErrorText.substring(prefix.length(), endCode);
            try {
                return Integer.valueOf(code.trim());
            }
            catch (Exception e) {
                return -1;
            }
        }
        return -1;
    }

    public String getFileAbsoluteSystemDependPath() {
        return this.myFileAbsoluteSystemDependPath;
    }

    public int getEndLine() {
        return this.myEndLine;
    }

    public int getEndColumn() {
        return this.myEndColumn;
    }

    public static ImmutableList<JSLanguageServiceAnnotationResult> buildError(String errorText) {
        return ContainerUtil.immutableList((Object[])new JSLanguageServiceAnnotationResult[]{new JSLanguageServiceAnnotationResult(errorText, null, null, 0, 0, 0, 0)});
    }

    public JSLanguageServiceAnnotationResult(String errorText, String fileAbsolutePath, String category, int line, int column, int lineEnd, int columnEnd) {
        this.myCategory = category;
        this.myColumn = column - 1;
        this.myLine = line - 1;
        this.myEndLine = lineEnd - 1;
        this.myEndColumn = columnEnd - 1;
        this.myErrorText = errorText;
        this.myFileAbsoluteSystemDependPath = fileAbsolutePath;
    }

    public String toString() {
        return "JSLanguageCompilerResult{myColumn=" + this.myColumn + ", myLine=" + this.myLine + ", myEndLine=" + this.myEndLine + ", myEndColumn=" + this.myEndColumn + ", myErrorText='" + this.myErrorText + '\'' + ", myCategory='" + this.myCategory + '\'' + ", myFileAbsoluteSystemDependPath='" + this.myFileAbsoluteSystemDependPath + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSLanguageServiceAnnotationResult result = (JSLanguageServiceAnnotationResult)o;
        if (this.myColumn != result.myColumn) {
            return false;
        }
        if (this.myLine != result.myLine) {
            return false;
        }
        if (this.myEndLine != result.myEndLine) {
            return false;
        }
        if (this.myEndColumn != result.myEndColumn) {
            return false;
        }
        if (this.myErrorText != null ? !this.myErrorText.equals(result.myErrorText) : result.myErrorText != null) {
            return false;
        }
        if (this.myCategory != null ? !this.myCategory.equals(result.myCategory) : result.myCategory != null) {
            return false;
        }
        return !(this.myFileAbsoluteSystemDependPath != null ? !this.myFileAbsoluteSystemDependPath.equals(result.myFileAbsoluteSystemDependPath) : result.myFileAbsoluteSystemDependPath != null);
    }

    public int hashCode() {
        int result = this.myColumn;
        result = 31 * result + this.myLine;
        result = 31 * result + this.myEndLine;
        result = 31 * result + this.myEndColumn;
        result = 31 * result + (this.myErrorText != null ? this.myErrorText.hashCode() : 0);
        result = 31 * result + (this.myCategory != null ? this.myCategory.hashCode() : 0);
        result = 31 * result + (this.myFileAbsoluteSystemDependPath != null ? this.myFileAbsoluteSystemDependPath.hashCode() : 0);
        return result;
    }
}

