/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.settings;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.flow.FlowJSServerService;
import com.intellij.lang.javascript.flow.FlowJSSettings;
import com.intellij.lang.javascript.flow.FlowJSSettingsManager;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.settings.JSRootConfigurationPanel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSRootConfigurable
implements SearchableConfigurable {
    public static final String ID = "Settings.JavaScript";
    private JSRootConfigurationPanel myMainPanel;
    private final JSRootConfiguration myRootConfiguration;
    private final Project myProject;

    public JSRootConfigurable(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/settings/JSRootConfigurable", "<init>"));
        }
        this.myRootConfiguration = JSRootConfiguration.getInstance(project);
        this.myProject = project;
    }

    @Nls
    public String getDisplayName() {
        return JSBundle.message((String)"settings.javascript.root.configurable.name", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        return this.getMainPanel();
    }

    public boolean isModified() {
        JSLanguageLevel storedLanguageLevel = this.myRootConfiguration.getStoredLanguageLevel();
        JSLanguageLevel panelLanguageLevel = this.myMainPanel.getLanguageLevel();
        if (storedLanguageLevel != null && storedLanguageLevel == JSLanguageLevel.FLOW) {
            FlowJSSettings storedSettings;
            FlowJSSettings viewSettings = this.myMainPanel.getFlowPanel().getFlowSettings();
            return !viewSettings.equals(storedSettings = FlowJSSettingsManager.getInstance(this.myProject).getFlowSettings()) || !panelLanguageLevel.equals((Object)storedLanguageLevel) || this.myRootConfiguration.getPreferStrict() != this.myMainPanel.isPreferStrict() || this.myRootConfiguration.isOnlyTypeBasedCompletion() != this.myMainPanel.getOnlyTypeBasedCompletion();
        }
        return storedLanguageLevel == null && !panelLanguageLevel.equals((Object)JSLanguageLevel.DEFAULT) || storedLanguageLevel != null && !panelLanguageLevel.equals((Object)storedLanguageLevel) || this.myRootConfiguration.getPreferStrict() != this.myMainPanel.isPreferStrict() || this.myRootConfiguration.isOnlyTypeBasedCompletion() != this.myMainPanel.getOnlyTypeBasedCompletion();
    }

    public void apply() throws ConfigurationException {
        JSLanguageLevel newLanguageLevel = this.myMainPanel.getLanguageLevel();
        this.myRootConfiguration.storeLanguageLevelAndUpdateCaches(newLanguageLevel);
        this.myRootConfiguration.storePreferStrict(this.myMainPanel.isPreferStrict());
        this.myRootConfiguration.storeOnlyTypeBasedCompletion(this.myMainPanel.getOnlyTypeBasedCompletion());
        if (newLanguageLevel == JSLanguageLevel.FLOW) {
            String errorMessage;
            FlowJSSettings settings = this.myMainPanel.getFlowPanel().getFlowSettings();
            if (!settings.getFlowExecutablePath().isEmpty() && settings.isTypeCheckingEnabled() && (errorMessage = FlowJSServerService.isFlowServerAvailable(settings.getFlowExecutablePath(), this.myProject)) != null) {
                throw new ConfigurationException(JSBundle.message((String)"js.flow.enable.flow.service.error.message", (Object[])new Object[]{errorMessage}));
            }
            FlowJSSettingsManager.getInstance(this.myProject).setFlowSettings(settings);
            FlowJSServerService service = FlowJSServerService.getService(this.myProject);
            if (service != null) {
                service.restartService();
            }
            DaemonCodeAnalyzer.getInstance((Project)this.myProject).restart();
        }
    }

    public void reset() {
        JSLanguageLevel storedLanguageLevel = this.myRootConfiguration.getStoredLanguageLevel();
        if (storedLanguageLevel == null) {
            storedLanguageLevel = JSLanguageLevel.DEFAULT;
        }
        this.myMainPanel.setLanguageLevel(storedLanguageLevel);
        boolean preferStrict = this.myRootConfiguration.getPreferStrict();
        this.myMainPanel.setPreferStrict(preferStrict);
        boolean simplerCompletion = this.myRootConfiguration.isOnlyTypeBasedCompletion();
        this.myMainPanel.setOnlyTypeBasedCompletion(simplerCompletion);
        FlowJSSettings settings = FlowJSSettingsManager.getInstance(this.myProject).getFlowSettings();
        this.myMainPanel.getFlowPanel().setFlowSettings(settings);
    }

    public void disposeUIResources() {
        this.myMainPanel = null;
    }

    @NotNull
    public JPanel getMainPanel() {
        if (this.myMainPanel == null) {
            this.myMainPanel = new JSRootConfigurationPanel(this.myProject);
        }
        JPanel jPanel = this.myMainPanel.getPanel();
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurable", "getMainPanel"));
        }
        return jPanel;
    }

    @NotNull
    public String getId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/settings/JSRootConfigurable", "getId"));
        }
        return ID;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return () -> {
            if (option != null && StringUtil.containsIgnoreCase((String)option, (String)"flow") && this.myMainPanel.getPanel().isShowing()) {
                this.myMainPanel.myJSLanguageVersion.showPopup();
            }
        };
    }
}

