/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.MacroCallNode;
import com.intellij.codeInsight.template.macro.CompleteMacro;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSParameterListElement;
import com.intellij.lang.javascript.psi.JSSourceElement;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AddSuperInvocationFix
implements IntentionAction {
    private final JSFunction myConstructor;
    private final JSFunction superConstructor;

    public AddSuperInvocationFix(JSFunction constructor, JSFunction superConstructor) {
        this.myConstructor = constructor;
        this.superConstructor = superConstructor;
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)"javascript.fix.create.invoke.super", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix", "isAvailable"));
        }
        return this.superConstructor.isValid() && this.myConstructor.isValid();
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        JSFunction fun;
        JSSourceElement[] body;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/AddSuperInvocationFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        Template t = TemplateManager.getInstance((Project)project).createTemplate("", "");
        t.setToReformat(true);
        t.addTextSegment("super(");
        boolean first = true;
        for (JSParameterListElement p : this.superConstructor.getParameters()) {
            if (p.isRest()) break;
            if (!first) {
                t.addTextSegment(", ");
            }
            first = false;
            MacroCallNode node = new MacroCallNode((Macro)new CompleteMacro());
            t.addVariable(p.getName(), (Expression)node, (Expression)node, true);
        }
        t.addTextSegment(")");
        String s = JSCodeStyleSettings.getSemicolon(file);
        if (s.length() > 0) {
            t.addTextSegment(s);
        }
        JSSourceElement[] jSSourceElementArray = body = (fun = this.myConstructor) != null ? fun.getBody() : JSSourceElement.EMPTY_ARRAY;
        if (body.length > 0 && body[0] instanceof JSBlockStatement) {
            PsiElement firstChild = body[0].getFirstChild();
            editor.getCaretModel().moveToOffset(firstChild.getTextRange().getEndOffset());
            TemplateManager.getInstance((Project)project).startTemplate(editor, t);
        }
    }

    public boolean startInWriteAction() {
        return false;
    }
}

