/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.Template;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.dialects.JSLanguageFeature;
import com.intellij.lang.javascript.ecmascript6.JSInsertThisFix;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.validation.fixes.BaseCreateFix;
import com.intellij.lang.javascript.validation.fixes.BaseCreateJSVariableIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class CreateJSVariableIntentionAction
extends BaseCreateJSVariableIntentionAction {
    @NonNls
    protected static final String VAR_STATEMENT_START = "var ";
    @NonNls
    private static final String CONSTANT_STATEMENT_START = "const ";
    private final boolean isField;
    private final boolean isConstant;

    public CreateJSVariableIntentionAction(String referencedName, boolean isField, boolean isConstant) {
        super(referencedName);
        this.isField = isField;
        this.isConstant = isConstant;
    }

    @NotNull
    public String getName() {
        String string = JSBundle.message((String)(this.isField ? (this.isConstant ? "javascript.create.constant.field.intention.name" : "javascript.create.property.intention.name") : (this.isConstant ? "javascript.create.constant.intention.name" : "javascript.create.variable.intention.name")), (Object[])new Object[]{this.myReferencedName});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/CreateJSVariableIntentionAction", "getName"));
        }
        return string;
    }

    @Override
    protected boolean produceDeclarationOnClassLevel(PsiElement element) {
        return this.isField;
    }

    @Override
    protected void buildTemplate(Template template, JSReferenceExpression referenceExpression, boolean staticContext, PsiFile file, PsiElement anchorParent) {
        boolean hasTypes;
        String refText;
        DialectOptionHolder holder = DialectDetector.dialectOfElement((PsiElement)file);
        boolean ecma = holder != null && holder.isECMA4;
        boolean isTypeScript = holder != null && holder.isTypeScript;
        JSClass contextClass = CreateJSVariableIntentionAction.findClass(anchorParent);
        JSExpression qualifier = CreateJSVariableIntentionAction.addAccessModifier(template, referenceExpression, file, staticContext, contextClass);
        if (qualifier == null && (!this.isField || !isTypeScript) || ecma) {
            template.addTextSegment(this.isConstant ? CONSTANT_STATEMENT_START : VAR_STATEMENT_START);
        }
        String string = refText = ecma || isTypeScript ? referenceExpression.getReferenceName() : referenceExpression.getText();
        if (refText != null) {
            template.addTextSegment(refText);
        }
        template.addEndVariable();
        boolean isEnumContext = contextClass instanceof TypeScriptEnum;
        boolean bl = hasTypes = holder != null && holder.hasFeature(JSLanguageFeature.TYPES);
        if (ecma || contextClass != null && !isEnumContext && hasTypes) {
            template.addTextSegment(":");
            this.guessTypeAndAddTemplateVariable(template, (JSExpression)referenceExpression, file, false);
            if (this.isConstant) {
                template.addTextSegment(" = ");
                this.addCompletionVar(template);
            }
        } else if (qualifier != null && contextClass == null) {
            template.addTextSegment(" = ");
            BaseCreateFix.MyExpression expression = new BaseCreateFix.MyExpression("undefined");
            template.addVariable("__type" + referenceExpression.getText(), (Expression)expression, (Expression)expression, true);
        }
        if (!isEnumContext) {
            this.addSemicolonSegment(template, file);
        } else {
            TypeScriptEnum classEnum = (TypeScriptEnum)contextClass;
            if (classEnum.getFields().length > 0) {
                template.addTextSegment(",");
            }
        }
    }

    @Override
    protected JSReferenceExpression beforeStartTemplateAction(JSReferenceExpression referenceExpression, Editor editor, PsiElement anchor, boolean isStaticContext) {
        JSReferenceExpression expression = super.beforeStartTemplateAction(referenceExpression, editor, anchor, isStaticContext);
        if (expression == null) {
            return null;
        }
        if (DialectDetector.isTypeScript((PsiElement)expression) && expression.getQualifier() == null && this.isField) {
            return (JSReferenceExpression)JSInsertThisFix.insertThisQualifier((JSExpression)expression, editor);
        }
        return expression;
    }
}

