/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FixAndIntentionAction
implements LocalQuickFix,
IntentionAction {
    private SmartPsiElementPointer myElementPointer;

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "applyFix"));
        }
        this.applyFix(project, descriptor.getPsiElement(), null, null);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "getFamilyName"));
        }
        return string;
    }

    @NotNull
    public String getText() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "getText"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "isAvailable"));
        }
        PsiElement element = this.myElementPointer.getElement();
        if (element == null) {
            return false;
        }
        return this.isAvailable(project, element, editor, file);
    }

    public boolean startInWriteAction() {
        return false;
    }

    protected abstract void applyFix(Project var1, PsiElement var2, PsiFile var3, Editor var4);

    protected boolean isAvailable(Project project, PsiElement element, Editor editor, PsiFile file) {
        return true;
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "invoke"));
        }
        assert (this.myElementPointer != null);
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        PsiElement element = this.myElementPointer.getElement();
        if (element == null) {
            return;
        }
        this.applyFix(project, element, element.getContainingFile(), editor);
    }

    @Nullable
    public SmartPsiElementPointer registerElementRefForFix(@NotNull PsiElement nameIdentifier, @Nullable SmartPsiElementPointer pointer) {
        if (nameIdentifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameIdentifier", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "registerElementRefForFix"));
        }
        if (this.myElementPointer != null) {
            return pointer;
        }
        if (pointer == null) {
            pointer = SmartPointerManager.getInstance((Project)nameIdentifier.getProject()).createSmartPsiElementPointer(nameIdentifier);
        }
        this.myElementPointer = pointer;
        return pointer;
    }

    public void sharePointer(@NotNull FixAndIntentionAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/lang/javascript/validation/fixes/FixAndIntentionAction", "sharePointer"));
        }
        this.myElementPointer = action.myElementPointer;
    }
}

