/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.validation.fixes;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.LocalQuickFixAndIntentionActionOnPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.refactoring.FormatFixer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.PropertyKey;

public class RemoveASTNodeFix
extends LocalQuickFixAndIntentionActionOnPsiElement {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.lang.javascript.validation.fixes.RemoveASTNodeFix");
    private final String myPropKey;
    private final boolean myFixNewLines;

    public RemoveASTNodeFix(@NotNull @PropertyKey(resourceBundle="com.intellij.lang.javascript.JavaScriptBundle") String propKey, @NotNull ASTNode astNode) {
        if (propKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propKey", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "<init>"));
        }
        if (astNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "astNode", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "<init>"));
        }
        this(propKey, false, astNode, astNode);
    }

    public RemoveASTNodeFix(@NotNull @PropertyKey(resourceBundle="com.intellij.lang.javascript.JavaScriptBundle") String propKey, boolean fixNewLines, @NotNull ASTNode startNode, @NotNull ASTNode endNode) {
        if (propKey == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propKey", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "<init>"));
        }
        if (startNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startNode", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "<init>"));
        }
        if (endNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endNode", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "<init>"));
        }
        super(startNode.getPsi(), endNode.getPsi());
        this.myPropKey = propKey;
        this.myFixNewLines = fixNewLines;
    }

    private static ASTNode[] collectNodes(ASTNode from, ASTNode to) {
        LOG.assertTrue(from.getTreeParent() == to.getTreeParent());
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        ASTNode node = from;
        while (true) {
            result.add(node);
            if (node == to) break;
            LOG.assertTrue((node = node.getTreeNext()) != null);
        }
        return result.toArray(new ASTNode[result.size()]);
    }

    @NotNull
    public String getText() {
        String string = JSBundle.message((String)this.myPropKey, (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "getFamilyName"));
        }
        return string;
    }

    public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "isAvailable"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "isAvailable"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "isAvailable"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "isAvailable"));
        }
        for (ASTNode astNode : RemoveASTNodeFix.collectNodes(startElement.getNode(), endElement.getNode())) {
            if (astNode.getPsi().isValid()) continue;
            return false;
        }
        return true;
    }

    public void invoke(@NotNull Project project, @NotNull PsiFile file, Editor editor, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "invoke"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "invoke"));
        }
        if (startElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "invoke"));
        }
        if (endElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "com/intellij/lang/javascript/validation/fixes/RemoveASTNodeFix", "invoke"));
        }
        if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
            return;
        }
        FormatFixer fixer = null;
        ASTNode[] myAstNodes = RemoveASTNodeFix.collectNodes(startElement.getNode(), endElement.getNode());
        if (this.myFixNewLines) {
            fixer = FormatFixer.create(file, new TextRange(myAstNodes[0].getStartOffset(), myAstNodes[myAstNodes.length - 1].getStartOffset() + myAstNodes[myAstNodes.length - 1].getTextLength()), FormatFixer.Mode.InSpecifiedRangeMakeFormatterWorkAndLeaveWsBeforeAndAfterIntact);
        }
        for (ASTNode astNode : myAstNodes) {
            if (!astNode.getPsi().isValid()) continue;
            astNode.getPsi().delete();
        }
        if (fixer != null) {
            fixer.fixFormat();
        }
    }

    public boolean startInWriteAction() {
        return true;
    }
}

