/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.languageService;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.intellij.lang.javascript.service.JSLanguageServiceCommandResultProcessor;
import com.intellij.lang.javascript.service.JSLanguageServiceImpl;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceAnswer;
import com.intellij.lang.javascript.service.protocol.JSLanguageServiceObject;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerConfigUtil;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerService;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.languageService.TypeScriptLanguageServiceUtil;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptCloseEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileLocationRequestArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileObject;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptFileWithConfigArgs;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptGetDefinitionCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptOpenEditorCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.TypeScriptSignatureHelpCommand;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptResponseCommon;
import com.intellij.lang.typescript.compiler.languageService.protocol.commands.response.TypeScriptSignatureHelpResponse;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServiceEvents {
    public static final Logger LOGGER = Logger.getInstance((String)"#com.intellij.lang.javascript.compiler.JSLanguageExternalCompilerImpl");
    @NotNull
    private final Project myProject;
    private final NotNullLazyValue<TypeScriptCompilerService> myCompilerService;

    public static TypeScriptLanguageServiceEvents getService(Project project) {
        return (TypeScriptLanguageServiceEvents)ServiceManager.getService((Project)project, TypeScriptLanguageServiceEvents.class);
    }

    public TypeScriptLanguageServiceEvents(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "<init>"));
        }
        this.myCompilerService = new NotNullLazyValue<TypeScriptCompilerService>(){

            @NotNull
            protected TypeScriptCompilerService compute() {
                TypeScriptCompilerService typeScriptCompilerService = TypeScriptCompilerService.getService(TypeScriptLanguageServiceEvents.this.myProject);
                if (typeScriptCompilerService == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$1", "compute"));
                }
                return typeScriptCompilerService;
            }
        };
        this.myProject = project;
    }

    public void onOpenEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "onOpenEditor"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        TypeScriptOpenEditorCommand command = this.createOpenEditorCommand(file);
        TypeScriptCompilerService service = (TypeScriptCompilerService)this.myCompilerService.getValue();
        if (!service.isServiceCreated()) {
            return;
        }
        service.sendCommand(command, JSLanguageServiceCommandResultProcessor.SUCCESS);
    }

    @NotNull
    public TypeScriptOpenEditorCommand createOpenEditorCommand(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "createOpenEditorCommand"));
        }
        TypeScriptFileWithConfigArgs arguments = new TypeScriptFileWithConfigArgs();
        arguments.file = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptOpenEditorCommand typeScriptOpenEditorCommand = new TypeScriptOpenEditorCommand(arguments, file);
        if (typeScriptOpenEditorCommand == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "createOpenEditorCommand"));
        }
        return typeScriptOpenEditorCommand;
    }

    public void onCloseEditor(@NotNull VirtualFile file, TypeScriptCompilerSettings settings) {
        VirtualFile mainFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "onCloseEditor"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        if (settings.isUseMainFile() && file.equals(mainFile = TypeScriptLanguageServiceUtil.getMainFile(settings))) {
            return;
        }
        TypeScriptCompilerService service = (TypeScriptCompilerService)this.myCompilerService.getValue();
        if (!service.isServiceCreated()) {
            return;
        }
        String normalizeNameAndPath = TypeScriptCompilerConfigUtil.normalizeNameAndPath(file);
        TypeScriptFileObject arguments = new TypeScriptFileObject();
        TypeScriptCloseEditorCommand command = new TypeScriptCloseEditorCommand(arguments, file);
        arguments.file = normalizeNameAndPath;
        service.sendCommand(command, JSLanguageServiceCommandResultProcessor.SUCCESS);
    }

    @Nullable
    public Future<TypeScriptSignatureHelpResponse> getSignatureHelp(VirtualFile file, Editor editor, int offset) {
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file, editor.getDocument(), offset);
        JSLanguageServiceCommandResultProcessor<TypeScriptSignatureHelpResponse> processor = new JSLanguageServiceCommandResultProcessor<TypeScriptSignatureHelpResponse>(){

            @Override
            @Nullable
            public TypeScriptSignatureHelpResponse process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$2", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$2", "process"));
                }
                JsonObject element = answer.getElement();
                JsonObject body = element.getAsJsonObject("body");
                if (body == null) {
                    return null;
                }
                return (TypeScriptSignatureHelpResponse)JSLanguageServiceImpl.GSON.fromJson((JsonElement)body, TypeScriptSignatureHelpResponse.class);
            }
        };
        TypeScriptCompilerService service = (TypeScriptCompilerService)this.myCompilerService.getValue();
        if (!service.isServiceCreated()) {
            return null;
        }
        return service.sendCommand(new TypeScriptSignatureHelpCommand(args), processor);
    }

    @Nullable
    public Future<TypeScriptResponseCommon.FileSpan[]> getDeclaration(@NotNull PsiElement sourceElement, @NotNull Document document) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "getDeclaration"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents", "getDeclaration"));
        }
        TypeScriptCompilerService service = (TypeScriptCompilerService)this.myCompilerService.getValue();
        if (!service.isServiceCreated()) {
            return null;
        }
        TypeScriptFileLocationRequestArgs args = new TypeScriptFileLocationRequestArgs();
        VirtualFile file = sourceElement.getContainingFile().getVirtualFile();
        if (file == null) {
            return null;
        }
        int offset = sourceElement.getTextRange().getStartOffset();
        TypeScriptLanguageServiceUtil.fillFilePosition(args, file, document, offset);
        TypeScriptGetDefinitionCommand command = new TypeScriptGetDefinitionCommand(args);
        return service.sendCommand(command, new JSLanguageServiceCommandResultProcessor<TypeScriptResponseCommon.FileSpan[]>(){

            @Override
            @NotNull
            public TypeScriptResponseCommon.FileSpan[] process(@NotNull JSLanguageServiceObject serviceObject, @NotNull JSLanguageServiceAnswer answer) {
                if (serviceObject == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serviceObject", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$3", "process"));
                }
                if (answer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "answer", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$3", "process"));
                }
                JsonObject element = answer.getElement();
                JsonElement jsonElement = element.get("body");
                if (jsonElement == null) {
                    if (TypeScriptResponseCommon.EMPTY_SPAN_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$3", "process"));
                    }
                    return TypeScriptResponseCommon.EMPTY_SPAN_ARRAY;
                }
                TypeScriptResponseCommon.FileSpan[] result = (TypeScriptResponseCommon.FileSpan[])JSLanguageServiceImpl.GSON.fromJson(jsonElement, TypeScriptResponseCommon.FileSpan[].class);
                if (result != null) {
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$3", "process"));
                    }
                    return result;
                }
                if (TypeScriptResponseCommon.EMPTY_SPAN_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/typescript/compiler/languageService/TypeScriptLanguageServiceEvents$3", "process"));
                }
                return TypeScriptResponseCommon.EMPTY_SPAN_ARRAY;
            }
        });
    }
}

