/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.compiler.ui;

import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.typescript.compiler.TypeScriptCompilerSettings;
import com.intellij.lang.typescript.compiler.ui.TypeScriptLanguageServiceDialog;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.JBCheckBox;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptLanguageServicePanel
extends JPanel {
    private final JButton myEditButton;
    private JBCheckBox myUseService = new JBCheckBox(JSBundle.message((String)"typescript.use.service.configurable.options.enable", (Object[])new Object[0]));
    private boolean myUseCompletion;
    private boolean myUseAnnotation;

    public TypeScriptLanguageServicePanel(final @Nullable Project project) {
        super(new FlowLayout(0));
        this.add((Component)this.myUseService, "Center");
        this.myEditButton = new JButton("Configure...");
        this.myUseService.addChangeListener(el -> this.myEditButton.setEnabled(this.myUseService.isSelected()));
        this.add((Component)this.myEditButton, "East");
        this.myEditButton.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeScriptLanguageServiceDialog dialog = new TypeScriptLanguageServiceDialog(project, TypeScriptLanguageServicePanel.this);
                if (dialog.showAndGet()) {
                    TypeScriptLanguageServicePanel.this.myUseCompletion = dialog.isUseCodeCompletion();
                    TypeScriptLanguageServicePanel.this.myUseAnnotation = dialog.isUseAnnotation();
                }
            }
        });
    }

    public boolean isUseServiceAnnotation() {
        return this.myUseAnnotation;
    }

    public boolean isUseServiceCompletion() {
        return this.myUseCompletion;
    }

    public void setValues(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/ui/TypeScriptLanguageServicePanel", "setValues"));
        }
        this.myUseService.setSelected(settings.isUseService());
        this.myUseAnnotation = settings.isUseServiceAnnotation();
        this.myUseCompletion = settings.isUseServiceCompletion();
        this.myEditButton.setEnabled(this.myUseService.isSelected());
    }

    public boolean isModified(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/ui/TypeScriptLanguageServicePanel", "isModified"));
        }
        return settings.isUseService() != this.myUseService.isSelected() || settings.isUseServiceCompletion() != this.myUseCompletion || settings.isUseServiceAnnotation() != this.myUseAnnotation;
    }

    public void apply(@NotNull TypeScriptCompilerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/lang/typescript/compiler/ui/TypeScriptLanguageServicePanel", "apply"));
        }
        settings.setUseService(this.myUseService.isSelected());
        settings.setUseServiceCompletion(this.myUseCompletion);
        settings.setUseServiceAnnotation(this.myUseAnnotation);
        this.myEditButton.setEnabled(this.myUseService.isSelected());
    }
}

