/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.typescript.settings.exclude;

import com.intellij.javascript.JSFileReference;
import com.intellij.lang.typescript.settings.exclude.TypeScriptGeneratedFilesManager;
import com.intellij.lang.typescript.settings.exclude.TypeScriptGeneratedFilesStartupActivity;
import com.intellij.openapi.fileEditor.impl.NonProjectFileWritingAccessExtension;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;

public class TypeScriptGeneratedFilesWriteAccess
implements NonProjectFileWritingAccessExtension {
    private final Project myProject;

    public TypeScriptGeneratedFilesWriteAccess(Project project) {
        this.myProject = project;
    }

    public boolean isWritable(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/lang/typescript/settings/exclude/TypeScriptGeneratedFilesWriteAccess", "isWritable"));
        }
        String name = file.getName();
        if (JSFileReference.findExtension(name, TypeScriptGeneratedFilesStartupActivity.JS_EXTENSIONS) != null) {
            TypeScriptGeneratedFilesManager manager = TypeScriptGeneratedFilesManager.getInstance(this.myProject);
            if (manager == null) {
                return false;
            }
            for (VirtualFile virtualFile : manager.getExcludedPlainJSFiles()) {
                if (!virtualFile.equals(file)) continue;
                return true;
            }
        }
        return false;
    }
}

