/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.web;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.util.PathUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WebRoot {
    private final String myRelativePath;
    private final VirtualFilePointer myVirtualFilePointer;

    public WebRoot(@NonNls String url, @NonNls String relativePath, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/javaee/web/WebRoot", "<init>"));
        }
        this.myRelativePath = WebRoot.normalize(relativePath);
        this.myVirtualFilePointer = VirtualFilePointerManager.getInstance().create(url, parentDisposable, null);
    }

    public WebRoot(@NotNull VirtualFile file, @NonNls String relativePath, @NotNull Disposable parentDisposable) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javaee/web/WebRoot", "<init>"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/javaee/web/WebRoot", "<init>"));
        }
        this(file.getUrl(), relativePath, parentDisposable);
    }

    public String getRelativePath() {
        return this.myRelativePath;
    }

    public String getDirectoryUrl() {
        return this.myVirtualFilePointer.getUrl();
    }

    public String getPresentableUrl() {
        return this.myVirtualFilePointer.getPresentableUrl();
    }

    @Nullable
    public VirtualFile getFile() {
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            @Nullable
            public VirtualFile compute() {
                return WebRoot.this.myVirtualFilePointer.getFile();
            }
        });
    }

    public String getURI() {
        return this.myRelativePath;
    }

    @Nullable
    private static String normalize(String relativePath) {
        if ((relativePath = PathUtil.getCanonicalPath((String)relativePath)) == null) {
            relativePath = "";
        }
        while (StringUtil.endsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = relativePath.substring(0, relativePath.length() - 1);
        }
        if (!StringUtil.startsWithChar((CharSequence)relativePath, (char)'/')) {
            relativePath = "/" + relativePath;
        }
        return relativePath;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof WebRoot)) {
            return false;
        }
        WebRoot webRoot = (WebRoot)o;
        if (!Comparing.equal((Object)this.getFile(), (Object)webRoot.getFile())) {
            return false;
        }
        return !(this.myRelativePath != null ? !this.myRelativePath.equals(webRoot.myRelativePath) : webRoot.myRelativePath != null);
    }

    public int hashCode() {
        VirtualFile myFile = this.getFile();
        int result = myFile != null ? myFile.hashCode() : 0;
        result = 29 * result + (this.myRelativePath != null ? this.myRelativePath.hashCode() : 0);
        return result;
    }

    @NonNls
    public String toString() {
        return "WebRoot: ('" + (this.myVirtualFilePointer == null ? "" : this.myVirtualFilePointer.getPresentableUrl()) + "' -> '" + this.myRelativePath + "')";
    }
}

