/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import icons.FreemarkerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class FtlCallableLookupElement
extends LookupElement {
    private final String myName;
    private final FtlCallableType myType;
    private final boolean myBuiltIn;
    private final Icon myIcon;

    public FtlCallableLookupElement(@NotNull String name, FtlCallableType type, boolean isBuiltIn) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/freemarker/psi/FtlCallableLookupElement", "<init>"));
        }
        this.myName = name;
        this.myType = type;
        this.myBuiltIn = isBuiltIn;
        this.myIcon = FtlCallableLookupElement.getCallableIcon(type, isBuiltIn);
    }

    public static Icon getCallableIcon(FtlCallableType type, boolean isBuiltIn) {
        return type.isMacro() ? FreemarkerIcons.Macro : (type.isFunction() || isBuiltIn ? PlatformIcons.FUNCTION_ICON : PlatformIcons.METHOD_ICON);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FtlCallableLookupElement)) {
            return false;
        }
        FtlCallableLookupElement that = (FtlCallableLookupElement)((Object)o);
        if (!this.myIcon.equals(that.myIcon)) {
            return false;
        }
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        return this.myType.equals(that.myType);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + this.myIcon.hashCode();
        return result;
    }

    @NotNull
    public String getLookupString() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/freemarker/psi/FtlCallableLookupElement", "getLookupString"));
        }
        return string;
    }

    public void handleInsert(InsertionContext context) {
        boolean hasParams;
        boolean bl = hasParams = this.myType.getParameters().length > 0;
        if (!(this.myType.isMacro() || this.myBuiltIn && !hasParams)) {
            (hasParams ? ParenthesesInsertHandler.WITH_PARAMETERS : ParenthesesInsertHandler.NO_PARAMETERS).handleInsert(context, (LookupElement)this);
        }
    }

    public void renderElement(LookupElementPresentation presentation) {
        presentation.setIcon(this.myIcon);
        presentation.setItemText(this.myName);
        presentation.setTailText(FtlCallableLookupElement.getSignature(this.myType));
        FtlType resultType = this.myType.getResultType();
        if (resultType != null) {
            presentation.setTypeText(resultType.getPresentableText());
        }
    }

    public static String getSignature(FtlCallableType type) {
        return "(" + StringUtil.join((Object[])type.getParameters(), (Function)new Function<FtlVariable, String>(){

            public String fun(FtlVariable variable) {
                FtlType ftlType = variable.getType();
                return (ftlType == null ? "" : ftlType.getPresentableText() + " ") + variable.getName();
            }
        }, (String)", ") + ")";
    }
}

