/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.lang.psi.impl;

import com.intellij.extapi.psi.ASTWrapperPsiElement;
import com.intellij.lang.ASTNode;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import java.util.Collections;
import java.util.List;
import org.intellij.plugins.markdown.lang.MarkdownTokenTypes;
import org.intellij.plugins.markdown.lang.psi.MarkdownPsiElement;
import org.intellij.plugins.markdown.structureView.MarkdownBasePresentation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MarkdownCodeBlockImpl
extends ASTWrapperPsiElement
implements MarkdownPsiElement {
    public MarkdownCodeBlockImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeBlockImpl", "<init>"));
        }
        super(node);
    }

    public ItemPresentation getPresentation() {
        return new MarkdownBasePresentation(){

            @Nullable
            public String getPresentableText() {
                return "Code block";
            }

            @Nullable
            public String getLocationString() {
                if (!MarkdownCodeBlockImpl.this.isValid()) {
                    return null;
                }
                StringBuilder sb = new StringBuilder();
                for (PsiElement child = MarkdownCodeBlockImpl.this.getFirstChild(); child != null; child = child.getNextSibling()) {
                    if (child.getNode().getElementType() != MarkdownTokenTypes.CODE_LINE) continue;
                    if (sb.length() > 0) {
                        sb.append("\\n");
                    }
                    sb.append(child.getText());
                    if (sb.length() >= 50) break;
                }
                return sb.toString();
            }
        };
    }

    @Override
    @NotNull
    public List<MarkdownPsiElement> getCompositeChildren() {
        List<MarkdownPsiElement> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/markdown/lang/psi/impl/MarkdownCodeBlockImpl", "getCompositeChildren"));
        }
        return list;
    }
}

