/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.build.ui;

import com.intellij.lang.aspectj.AspectJBundle;
import com.intellij.lang.aspectj.build.AjIdeaCompiler;
import com.intellij.lang.aspectj.build.AjJpsBundle;
import com.intellij.lang.aspectj.build.config.AjBuildProcessParametersProvider;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class AjCompilerOptionsPanel {
    private final Project myProject;
    private JPanel myPanel;
    private TextFieldWithBrowseButton myAjcPath;
    private RawCommandLineEditor myCmdLineParams;
    private JButton myTestButton;
    private JBCheckBox myGenerateDebugInfo;
    private JBCheckBox myDelegateToJavac;
    private JCheckBox myAptOptionsEnabled;
    private String myHeapSize;

    public AjCompilerOptionsPanel(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "<init>"));
        }
        this.myHeapSize = "";
        this.myProject = project;
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        String description = AspectJBundle.message("compiler.ajc.select.path", objectArray);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, false, true, true, false, false){

            public void validateSelectedFiles(VirtualFile[] files) throws Exception {
                AjCompilerOptionsPanel.checkCompilerJar(files[0].getPath());
            }
        };
        this.myAjcPath.addBrowseFolderListener(null, description, null, descriptor);
        this.myTestButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AjCompilerOptionsPanel.this.testCompiler();
            }
        });
    }

    private void testCompiler() {
        String path = this.getAjcPath();
        String heapSize = this.getHeapSize();
        try {
            AjCompilerOptionsPanel.checkCompilerJar(path);
            if (!StringUtil.isEmpty((String)heapSize)) {
                int hs = -1;
                try {
                    hs = Integer.parseInt(heapSize);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (hs <= 0) {
                    throw new IllegalArgumentException(AspectJBundle.message("compiler.ajc.bad.heap", new Object[0]));
                }
            }
            String version = AjIdeaCompiler.testCompiler(this.myProject, path, heapSize);
            Messages.showInfoMessage((String)version, (String)AspectJBundle.message("compiler.ajc.test.ok", new Object[0]));
        }
        catch (Exception e) {
            Messages.showErrorDialog((String)e.getMessage(), (String)AspectJBundle.message("compiler.ajc.error", new Object[0]));
        }
    }

    private static void checkCompilerJar(String path) throws Exception {
        if (!AjBuildProcessParametersProvider.checkCompilerJar(path)) {
            throw new IOException(AjJpsBundle.message((String)"aj.compiler.path.incorrect", (Object[])new Object[]{path}));
        }
    }

    @NotNull
    public JPanel getComponent() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "getComponent"));
        }
        return jPanel;
    }

    @NotNull
    public String getAjcPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myAjcPath.getText().trim());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "getAjcPath"));
        }
        return string;
    }

    public void setAjcPath(@NotNull String ajcPath) {
        if (ajcPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ajcPath", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "setAjcPath"));
        }
        this.myAjcPath.setText(FileUtil.toSystemDependentName((String)ajcPath));
    }

    @NotNull
    public String getHeapSize() {
        String string = this.myHeapSize;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "getHeapSize"));
        }
        return string;
    }

    public void setHeapSize(@NotNull String heapSize) {
        if (heapSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "heapSize", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "setHeapSize"));
        }
        this.myHeapSize = heapSize;
    }

    @NotNull
    public String getCmdLineParams() {
        String string = this.myCmdLineParams.getText().trim();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "getCmdLineParams"));
        }
        return string;
    }

    public void setCmdLineParams(@NotNull String params) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "com/intellij/lang/aspectj/build/ui/AjCompilerOptionsPanel", "setCmdLineParams"));
        }
        this.myCmdLineParams.setText(params);
    }

    public boolean isGenerateDebugInfo() {
        return this.myGenerateDebugInfo.isSelected();
    }

    public void setGenerateDebugInfo(boolean generateDebugInfo) {
        this.myGenerateDebugInfo.setSelected(generateDebugInfo);
    }

    public boolean isDelegateToJavac() {
        return this.myDelegateToJavac.isSelected();
    }

    public void setDelegateToJavac(boolean delegateToJavac) {
        this.myDelegateToJavac.setSelected(delegateToJavac);
    }

    public boolean areAptOptionsEnabled() {
        return this.myAptOptionsEnabled.isSelected();
    }

    public void setAptOptionsEnabled(boolean aptOptionsEnabled) {
        this.myAptOptionsEnabled.setSelected(aptOptionsEnabled);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        RawCommandLineEditor rawCommandLineEditor;
        JButton jButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        Font font = jPanel.getFont();
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Ajc Options", (int)0, (int)0, (Font)new Font(font.getName(), font.getStyle(), font.getSize()), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Path to Ajc compiler:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myAjcPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 3, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        this.myTestButton = jButton = new JButton();
        jButton.setText("Test");
        jButton.setMnemonic('T');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jButton, new GridConstraints(0, 4, 1, 1, 8, 0, 1, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Command line parameters:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myCmdLineParams = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Command line parameters");
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 3, 0, 1, 7, 0, null, null, null));
        this.myGenerateDebugInfo = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Generate debug info");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myDelegateToJavac = jBCheckBox = new JBCheckBox();
        jBCheckBox.setToolTipText("Use Javac to compile modules without AspectJ facet or with post-compile weaving enabled");
        jBCheckBox.setText("Delegate to Javac");
        jPanel.add((Component)jBCheckBox, new GridConstraints(3, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myAptOptionsEnabled = jCheckBox = new JCheckBox();
        jCheckBox.setText("Enable annotation processing options");
        jCheckBox.setToolTipText("Produce annotation processing options (for experimental Ajc builds which are able to handle them)");
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

