/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.aspectj.highlight;

import com.intellij.ide.highlighter.JavaFileHighlighter;
import com.intellij.ide.highlighter.JavaHighlightingColors;
import com.intellij.lang.aspectj.highlight.AjHighlightingLexer;
import com.intellij.lang.aspectj.parsing.AspectJTokenType;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.tree.IElementType;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AjFileHighlighter
extends JavaFileHighlighter {
    private static final Map<IElementType, TextAttributesKey> ATTRIBUTES = new HashMap<IElementType, TextAttributesKey>();

    public AjFileHighlighter(@NotNull LanguageLevel languageLevel) {
        if (languageLevel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "languageLevel", "com/intellij/lang/aspectj/highlight/AjFileHighlighter", "<init>"));
        }
        super(languageLevel);
    }

    @NotNull
    public Lexer getHighlightingLexer() {
        AjHighlightingLexer ajHighlightingLexer = new AjHighlightingLexer(this.myLanguageLevel);
        if (ajHighlightingLexer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/highlight/AjFileHighlighter", "getHighlightingLexer"));
        }
        return ajHighlightingLexer;
    }

    @NotNull
    public TextAttributesKey[] getTokenHighlights(IElementType tokenType) {
        TextAttributesKey key = ATTRIBUTES.get(tokenType);
        if (key != null) {
            TextAttributesKey[] textAttributesKeyArray = AjFileHighlighter.pack((TextAttributesKey)key);
            if (textAttributesKeyArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/highlight/AjFileHighlighter", "getTokenHighlights"));
            }
            return textAttributesKeyArray;
        }
        TextAttributesKey[] textAttributesKeyArray = super.getTokenHighlights(tokenType);
        if (textAttributesKeyArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/lang/aspectj/highlight/AjFileHighlighter", "getTokenHighlights"));
        }
        return textAttributesKeyArray;
    }

    static {
        AjFileHighlighter.fillMap(ATTRIBUTES, (TextAttributesKey)JavaHighlightingColors.KEYWORD, (IElementType[])new IElementType[]{AspectJTokenType.ASPECT_KEYWORD, AspectJTokenType.PRIVILEGED_KEYWORD, AspectJTokenType.ISSINGLETON_KEYWORD, AspectJTokenType.PERCFLOW_KEYWORD, AspectJTokenType.PERCFLOWBELOW_KEYWORD, AspectJTokenType.PERTARGET_KEYWORD, AspectJTokenType.PERTHIS_KEYWORD, AspectJTokenType.PERTYPE_KEYWORD, AspectJTokenType.PERTYPEWITHIN_KEYWORD, AspectJTokenType.DECLARE_KEYWORD, AspectJTokenType.ERROR_KEYWORD, AspectJTokenType.PARENTS_KEYWORD, AspectJTokenType.PRECEDENCE_KEYWORD, AspectJTokenType.SOFT_KEYWORD, AspectJTokenType.WARNING_KEYWORD, AspectJTokenType.CONSTRUCTOR_KEYWORD, AspectJTokenType.FIELD_KEYWORD, AspectJTokenType.METHOD_KEYWORD, AspectJTokenType.TYPE_KEYWORD, AspectJTokenType.AFTER_KEYWORD, AspectJTokenType.AROUND_KEYWORD, AspectJTokenType.BEFORE_KEYWORD, AspectJTokenType.POINTCUT_KEYWORD, AspectJTokenType.RETURNING_KEYWORD, AspectJTokenType.THROWING_KEYWORD});
    }
}

