/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.editorActions;

import com.intellij.lang.ASTNode;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.psi.VtlElementTypes;
import org.jetbrains.annotations.NotNull;

public class VtlCommenter
implements CodeDocumentationAwareCommenter {
    public static PsiComment findDocComment(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/editorActions/VtlCommenter", "findDocComment"));
        }
        VtlCommenter commenter = new VtlCommenter();
        for (PsiElement each = element.getPrevSibling(); each != null; each = each.getPrevSibling()) {
            if (each instanceof PsiComment && commenter.isDocumentationComment((PsiComment)each)) {
                return (PsiComment)each;
            }
            if (!FormatterUtil.containsWhiteSpacesOnly((ASTNode)each.getNode())) break;
        }
        return null;
    }

    public String getLineCommentPrefix() {
        return "##";
    }

    public String getBlockCommentPrefix() {
        return "#*";
    }

    public String getBlockCommentSuffix() {
        return "*#";
    }

    public String getCommentedBlockCommentPrefix() {
        return null;
    }

    public String getCommentedBlockCommentSuffix() {
        return null;
    }

    public IElementType getLineCommentTokenType() {
        return VtlElementTypes.ONELINE_COMMENT;
    }

    public IElementType getBlockCommentTokenType() {
        return VtlElementTypes.MULTILINE_COMMENT;
    }

    public IElementType getDocumentationCommentTokenType() {
        return VtlElementTypes.MULTILINE_COMMENT;
    }

    public String getDocumentationCommentPrefix() {
        return "#**";
    }

    public String getDocumentationCommentLinePrefix() {
        return "*";
    }

    public String getDocumentationCommentSuffix() {
        return "*#";
    }

    public boolean isDocumentationComment(PsiComment element) {
        return element.getText().startsWith(this.getDocumentationCommentPrefix());
    }
}

