/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.psi.parsers;

import com.intellij.lang.PsiBuilder;
import com.intellij.psi.tree.IElementType;
import com.intellij.velocity.VelocityBundle;
import com.intellij.velocity.psi.VtlCompositeElementTypes;
import com.intellij.velocity.psi.VtlElementTypes;
import com.intellij.velocity.psi.VtlTokenType;
import com.intellij.velocity.psi.parsers.CompositeBodyParser;
import com.intellij.velocity.psi.parsers.VtlParser;
import org.jetbrains.annotations.NotNull;

class ListHandler {
    private final IElementType myTerminator;
    static final ListHandler GENERAL_LIST_HANDLER = new ListHandler(VtlElementTypes.RIGHT_PAREN);
    static final ListHandler MAP_HANDLER = new ListHandler(VtlElementTypes.RIGHT_BRACE_IN_EXPR){

        @Override
        public boolean parseListElement(PsiBuilder builder) {
            if (!super.parseListElement(builder)) {
                return false;
            }
            if (CompositeBodyParser.assertToken(builder, VtlElementTypes.COLON)) {
                super.parseListElement(builder);
            }
            return true;
        }
    };
    static final ListHandler LIST_HANDLER = new ListHandler(VtlElementTypes.RIGHT_BRACKET){

        @Override
        public boolean parseListElement(PsiBuilder builder) {
            PsiBuilder.Marker rangeOperator = builder.mark();
            boolean elementFound = super.parseListElement(builder);
            if (!elementFound || builder.getTokenType() != VtlElementTypes.RANGE) {
                rangeOperator.drop();
                return elementFound;
            }
            builder.advanceLexer();
            super.parseListElement(builder);
            rangeOperator.done((IElementType)VtlCompositeElementTypes.RANGE_EXPRESSION);
            return true;
        }
    };
    static final ListHandler PARAMETER_LIST_HANDLER = new ListHandler(VtlElementTypes.RIGHT_PAREN){

        @Override
        public boolean parseListElement(PsiBuilder builder) {
            PsiBuilder.Marker elementMarker = builder.mark();
            IElementType elementStarter = builder.getTokenType();
            builder.advanceLexer();
            if (elementStarter != VtlElementTypes.START_REFERENCE && elementStarter != VtlElementTypes.START_REF_FORMAL) {
                elementMarker.error(VelocityBundle.message("parameter.expected", new Object[0]));
                return false;
            }
            CompositeBodyParser.assertToken(builder, VtlElementTypes.IDENTIFIER);
            if (elementStarter == VtlElementTypes.START_REF_FORMAL) {
                CompositeBodyParser.assertToken(builder, VtlElementTypes.RIGHT_BRACE);
            }
            elementMarker.done((IElementType)VtlCompositeElementTypes.PARAMETER);
            return true;
        }
    };

    private ListHandler(@NotNull VtlTokenType terminator) {
        if (terminator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "terminator", "com/intellij/velocity/psi/parsers/ListHandler", "<init>"));
        }
        this.myTerminator = terminator;
    }

    public boolean parseListElement(PsiBuilder builder) {
        return VtlParser.parseOperand(builder, false);
    }

    public boolean parseSeparator(PsiBuilder builder) {
        return CompositeBodyParser.consumeTokenIfPresent(builder, VtlElementTypes.COMMA);
    }

    public final boolean isListFinished(PsiBuilder builder) {
        return builder.getTokenType() == this.myTerminator;
    }
}

