/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cloudconfig;

import com.jetbrains.cloudconfig.AbstractHttpClient;
import com.jetbrains.cloudconfig.Configuration;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class CloudConfigClient
extends AbstractHttpClient {
    public CloudConfigClient(String endpoint) {
        super(endpoint);
    }

    public CloudConfigClient(String endpoint, Configuration config) {
        super(endpoint, config);
    }

    public Map<String, String> get(String product, String ... properties) throws IOException {
        return this.download("GET", this.url(product, properties), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Accept", "application/json");
            }
        }, new AbstractHttpClient.StreamParser<Map<String, String>>(){

            @Override
            public Map<String, String> parse(InputStream stream) {
                return (Map)AbstractHttpClient.GSON.fromJson((Reader)new InputStreamReader(stream), Map.class);
            }
        }, true);
    }

    public void put(String product, final Map<String, String> properties) throws IOException {
        this.upload("PUT", this.url(product, new String[0]), (Map<String, String>)new HashMap<String, String>(){
            {
                this.put("Content-Type", "application/json");
            }
        }, new AbstractHttpClient.StreamWriter(){

            @Override
            public void write(OutputStream stream) throws IOException {
                OutputStreamWriter writer = new OutputStreamWriter(stream);
                AbstractHttpClient.GSON.toJson((Object)properties, (Appendable)writer);
                writer.flush();
            }
        });
    }

    private URL url(String product, String ... properties) throws IOException {
        String path = this.endpoint + "/" + URLEncoder.encode(product, "UTF-8");
        if (properties != null && properties.length > 0) {
            StringBuilder sb = new StringBuilder("?");
            for (int i = 0; i < properties.length; ++i) {
                sb.append("key=").append(URLEncoder.encode(properties[i], "UTF-8"));
                if (i >= properties.length - 1) continue;
                sb.append("&");
            }
            path = path + sb.toString();
        }
        return new URL(path);
    }
}

