/*
 * Decompiled with CFR 0.152.
 */
package aQute.bnd.jpm;

import aQute.bnd.http.HttpClient;
import aQute.lib.hex.Hex;
import aQute.lib.io.IO;
import aQute.lib.json.JSONCodec;
import aQute.lib.settings.Settings;
import aQute.service.library.Library;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class StoredRevisionCache {
    private final File root;
    final File tmpdir;
    final File repodir;
    final File programdir;
    final Settings settings;
    boolean sign;
    final Map<File, Exception> errors = new HashMap<File, Exception>();
    private Map<String, Library.Program> programs = new HashMap<String, Library.Program>();
    private static final JSONCodec codec = new JSONCodec();
    File refresh;
    private HttpClient httpc = new HttpClient();

    public StoredRevisionCache(File root, Settings settings, HttpClient client) throws Exception {
        if (client != null) {
            this.httpc = client;
        }
        this.root = root;
        this.settings = settings;
        this.getRoot().mkdirs();
        this.tmpdir = new File(root, "tmp");
        this.tmpdir.mkdir();
        this.repodir = new File(root, "shas");
        this.repodir.mkdir();
        this.programdir = new File(root, "programs");
        this.programdir.mkdir();
        this.refresh = new File(root, ".refreshed");
        if (!this.refresh.isFile()) {
            this.refresh.createNewFile();
        }
    }

    public File getPath(String bsn, String version, byte[] sha) {
        return this.getPath(bsn, version, sha, false);
    }

    public File getPath(String bsn, String version, byte[] sha, boolean withsource) {
        if (withsource) {
            return IO.getFile(this.repodir, Hex.toHexString(sha) + "/+" + bsn + "-" + version + ".jar");
        }
        return IO.getFile(this.repodir, Hex.toHexString(sha) + "/" + bsn + "-" + version + ".jar");
    }

    public void delete(byte[] sha) {
        File f = IO.getFile(this.getRoot(), Hex.toHexString(sha));
        IO.delete(f);
    }

    public void download(File file, Set<URI> urls, byte[] sha) throws Exception {
        if (this.errors.containsKey(file)) {
            throw this.errors.get(file);
        }
        if (urls.isEmpty()) {
            throw new Exception("No URLs to download " + file);
        }
        for (URI url : urls) {
            Download d = null;
            try {
                d = this.doDownload(url);
                if (d == null) continue;
                if (!Arrays.equals(sha, d.sha)) {
                    throw new Exception("Shas did not match (expected)" + Hex.toHexString(sha) + " (downloaded)" + d.tmp + " (" + Hex.toHexString(d.sha) + ")");
                }
                file.getParentFile().mkdirs();
                if (!d.tmp.renameTo(file)) {
                    d.tmp.delete();
                }
                return;
            }
            catch (Exception e) {
                this.errors.put(file, e);
                throw e;
            }
            finally {
                if (d == null) continue;
                d.tmp.delete();
            }
        }
        throw new FileNotFoundException(urls.toString());
    }

    Download doDownload(URI url) throws Exception {
        InputStream connect = this.httpc.connect(url.toURL());
        if (connect == null) {
            return null;
        }
        Download d = new Download();
        d.tmp = IO.createTempFile(this.tmpdir, "tmp", ".tmp");
        MessageDigest sha = MessageDigest.getInstance("SHA1");
        MessageDigest md5 = MessageDigest.getInstance("MD5");
        DigestInputStream shaIn = new DigestInputStream(connect, sha);
        DigestInputStream md5In = new DigestInputStream(shaIn, md5);
        IO.copy((InputStream)md5In, d.tmp);
        d.sha = sha.digest();
        d.md5 = md5.digest();
        return d;
    }

    public void add(Library.RevisionRef d, File file) throws IOException {
        File path = this.getPath(d.bsn, d.version, d.revision);
        path.getParentFile().mkdirs();
        IO.copy(file, path);
        long modified = file.lastModified();
        if (modified > 0L) {
            path.setLastModified(modified);
        }
    }

    public File getRoot() {
        return this.root;
    }

    public void refresh() {
        this.errors.clear();
        this.refresh.setLastModified(System.currentTimeMillis());
    }

    public void deleteAll() {
        IO.delete(this.root);
        this.root.mkdirs();
    }

    public Library.Program getProgram(String bsn) {
        Library.Program p = this.programs.get(bsn);
        if (p != null) {
            return p;
        }
        File pf = IO.getFile(this.programdir, bsn + ".json");
        if (pf != null && pf.isFile() && pf.lastModified() >= this.refresh.lastModified()) {
            try {
                p = codec.dec().from(pf).get(Library.Program.class);
                this.programs.put(bsn, p);
                return p;
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }

    public void putProgram(String bsn, Library.Program p) throws IOException, Exception {
        this.programs.put(bsn, p);
        File pf = IO.getFile(this.root, bsn + ".json");
        codec.enc().to(pf).put(p);
    }

    public boolean hasSources(String bsn, String version, byte[] sha) {
        return this.getPath(bsn, version, sha, true).isFile();
    }

    public void removeSources(String bsn, String version, byte[] sha) {
        this.getPath(bsn, version, sha, true).delete();
    }

    public void makePermanent(Library.RevisionRef ref, Download d) {
        File f = this.getPath(ref.bsn, ref.version, ref.revision);
        f.getParentFile().mkdirs();
        d.tmp.renameTo(f);
    }

    static class Download {
        File tmp;
        byte[] md5;
        byte[] sha;
        URI uri;

        Download() {
        }
    }
}

