/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.seam.fileEditor;

import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.view.Graph2DView;
import com.intellij.openapi.graph.view.Overview;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.seam.fileEditor.PageflowDesignerComponent;
import com.intellij.seam.resources.messages.PageflowBundle;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ui.PerspectiveFileEditor;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PageflowDesignerFileEditor
extends PerspectiveFileEditor {
    private PageflowDesignerComponent myComponent;
    private final XmlFile myXmlFile;

    public PageflowDesignerFileEditor(Project project, VirtualFile file) {
        super(project, file);
        PsiFile psiFile = this.getPsiFile();
        assert (psiFile instanceof XmlFile);
        this.myXmlFile = (XmlFile)psiFile;
    }

    @Nullable
    protected DomElement getSelectedDomElement() {
        List<DomElement> selectedDomElements = this.getPageflowDesignerComponent().getSelectedDomElements();
        return selectedDomElements.size() > 0 ? selectedDomElements.get(0) : null;
    }

    protected void setSelectedDomElement(DomElement domElement) {
        this.getPageflowDesignerComponent().setSelectedDomElement(domElement);
    }

    @NotNull
    protected JComponent createCustomComponent() {
        PageflowDesignerComponent pageflowDesignerComponent = this.getPageflowDesignerComponent();
        if (pageflowDesignerComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/fileEditor/PageflowDesignerFileEditor", "createCustomComponent"));
        }
        return pageflowDesignerComponent;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return ((Graph2DView)this.getPageflowDesignerComponent().getBuilder().getGraph().getCurrentView()).getJComponent();
    }

    public void commit() {
    }

    public void reset() {
        this.getPageflowDesignerComponent().getBuilder().queueUpdate();
    }

    @NotNull
    public String getName() {
        String string = PageflowBundle.message("seam.pageflow.designer", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/seam/fileEditor/PageflowDesignerFileEditor", "getName"));
        }
        return string;
    }

    public StructureViewBuilder getStructureViewBuilder() {
        return GraphViewUtil.createStructureViewBuilder((Overview)this.getPageflowDesignerComponent().getOverview());
    }

    private PageflowDesignerComponent getPageflowDesignerComponent() {
        if (this.myComponent == null) {
            this.myComponent = new PageflowDesignerComponent(this.myXmlFile);
            Disposer.register((Disposable)this, (Disposable)this.myComponent);
        }
        return this.myComponent;
    }
}

