/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.formatter;

import com.intellij.formatting.Alignment;
import com.intellij.formatting.Block;
import com.intellij.formatting.ChildAttributes;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.xml.AbstractXmlBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.GspLanguage;
import org.jetbrains.plugins.grails.lang.gsp.formatter.AbstractGspBlock;
import org.jetbrains.plugins.grails.lang.gsp.formatter.GspBlockGenerator;
import org.jetbrains.plugins.grails.lang.gsp.formatter.processors.GspIndentProcessor;
import org.jetbrains.plugins.grails.lang.gsp.formatter.processors.GspSpacingProcessor;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.parsing.GspElementTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspTag;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.gtag.GspTaggedElement;
import org.jetbrains.plugins.grails.lang.gsp.psi.html.api.GspHtmlOuterElement;

public class GspHtmlBlock
extends AbstractXmlBlock
implements Block,
GspElementTypes,
AbstractGspBlock {
    private static final Logger LOG = Logger.getInstance(GspHtmlBlock.class);
    private static final Comparator<PsiElement> myComparator = (elem1, elem2) -> {
        int offset1 = elem1.getTextRange().getStartOffset();
        int offset2 = elem2.getTextRange().getStartOffset();
        return offset1 - offset2;
    };
    private final Indent myIndent;
    private final XmlTag[] myNestedGspTags;

    public GspHtmlBlock(ASTNode node, Wrap wrap, Alignment alignment, XmlFormattingPolicy policy, Indent indent, XmlTag[] nestedGspTags) {
        super(node, wrap, alignment, policy);
        this.myNestedGspTags = nestedGspTags;
        this.myIndent = indent;
    }

    protected List<Block> buildChildren() {
        ASTNode child = this.myNode.getFirstChildNode();
        if (child == null) {
            return EMPTY;
        }
        ArrayList<Block> result2 = new ArrayList<Block>();
        Wrap attrWrap = Wrap.createWrap((WrapType)GspHtmlBlock.getWrapType((int)this.myXmlFormattingPolicy.getAttributesWrap()), (boolean)false);
        Alignment attrAlignment = Alignment.createAlignment();
        while (child != null) {
            if (child.getTextLength() == 0 || FormatterUtil.containsWhiteSpacesOnly((ASTNode)child)) {
                child = child.getTreeNext();
                continue;
            }
            ASTNode newChild = this.processChild(result2, child, this.chooseWrap(child, null, attrWrap, null), this.chooseAlignment(child, attrAlignment, null), Indent.getNoneIndent());
            if (newChild != null) {
                LOG.assertTrue(newChild.getTreeParent() == this.myNode);
                if (newChild == child) {
                    newChild = child.getTreeNext();
                }
            }
            child = newChild;
        }
        return result2;
    }

    private ASTNode processInnerChild(ASTNode innerRoot, Wrap wrap, Alignment alignment, List<Block> result2) {
        ASTNode next;
        boolean isComment;
        ASTNode parent = innerRoot.getTreeParent();
        if (!(innerRoot.getPsi() instanceof GspHtmlOuterElement)) {
            ASTNode found;
            if (!(innerRoot.getPsi() instanceof CompositeElement)) {
                GspBlockGenerator.createHtmlBlockByChildNode(result2, this.myNode, innerRoot, wrap, alignment, this.myXmlFormattingPolicy, this.calculateNestedGspTagsForElement(innerRoot.getPsi()));
                return innerRoot.getTreeNext();
            }
            XmlTag[] tags = this.calculateIntersectedTags(innerRoot.getPsi(), true);
            if (tags.length == 0) {
                GspBlockGenerator.createHtmlBlockByChildNode(result2, this.myNode, innerRoot, wrap, alignment, this.myXmlFormattingPolicy, this.calculateNestedGspTagsForElement(innerRoot.getPsi()));
                return innerRoot.getTreeNext();
            }
            ASTNode inner = innerRoot.getFirstChildNode();
            while (inner != null) {
                if (inner.getText().trim().length() == 0) {
                    inner = inner.getTreeNext();
                    continue;
                }
                if (!(inner instanceof CompositeElement) && GspHtmlBlock.intersects(inner, tags)) {
                    inner = inner.getTreeNext();
                    continue;
                }
                inner = this.processInnerChild(inner, wrap, alignment, result2);
            }
            for (XmlTag tag : tags) {
                if (GspHtmlBlock.alreadyHas(tag, result2)) continue;
                GspBlockGenerator.createGspBlockByChildNode(result2, this.myNode, tag.getNode(), wrap, alignment, this.myXmlFormattingPolicy);
            }
            for (found = parent.findLeafElementAt(tags[tags.length - 1].getTextRange().getEndOffset() - parent.getStartOffset()); found != null && !parent.equals(found.getTreeParent()); found = found.getTreeParent()) {
            }
            return found != null && found.equals(innerRoot) ? found.getTreeNext() : found;
        }
        FileViewProvider viewProvider = innerRoot.getPsi().getContainingFile().getViewProvider();
        PsiElement gspElement = viewProvider.findElementAt(innerRoot.getStartOffset(), (Language)GspLanguage.INSTANCE);
        assert (gspElement != null);
        int offset = gspElement.getTextRange().getStartOffset();
        while (!(gspElement.getParent() == null || gspElement.getParent().getTextRange().getStartOffset() != offset || gspElement instanceof GspTag || gspElement instanceof GspTaggedElement || gspElement instanceof PsiComment)) {
            gspElement = gspElement.getParent();
        }
        ASTNode node = gspElement.getNode();
        boolean bl = isComment = node != null && (node.getElementType() == GspTokenTypes.JSP_STYLE_COMMENT || node.getElementType() == GspTokenTypes.GSP_STYLE_COMMENT);
        if (!(gspElement instanceof GspTaggedElement || gspElement instanceof GspTag || isComment)) {
            GspBlockGenerator.createHtmlBlockByChildNode(result2, this.myNode, innerRoot, wrap, alignment, this.myXmlFormattingPolicy, this.calculateNestedGspTagsForElement(gspElement));
            return innerRoot.getTreeNext();
        }
        if (!this.getTextRange().contains(gspElement.getTextRange())) {
            LOG.error("Formatter error", new String[]{"outer html block text: [" + this.myNode.getText() + "]", "inner gsp block text: [" + gspElement.getText() + "]"});
        }
        GspBlockGenerator.createGspBlockByChildNode(result2, this.myNode, gspElement.getNode(), wrap, alignment, this.myXmlFormattingPolicy);
        int outerAbsoluteEndOffset = gspElement.getTextRange().getEndOffset();
        if (outerAbsoluteEndOffset == this.getTextRange().getEndOffset()) {
            return null;
        }
        for (next = parent.findLeafElementAt(outerAbsoluteEndOffset - parent.getStartOffset()); next != null && next.getTreeParent() != parent; next = next.getTreeParent()) {
        }
        return next;
    }

    private static boolean intersects(ASTNode node, XmlTag[] tags) {
        for (XmlTag tag : tags) {
            if (!node.getTextRange().intersectsStrict(tag.getTextRange())) continue;
            return true;
        }
        return false;
    }

    private static boolean nonContainedInTags(ASTNode node, XmlTag[] tags) {
        TextRange nodeTextRange = node.getTextRange();
        for (XmlTag tag : tags) {
            if (!tag.getTextRange().contains(nodeTextRange)) continue;
            return false;
        }
        return true;
    }

    protected ASTNode processChild(List<Block> result2, ASTNode child, Wrap wrap, Alignment alignment, Indent indent) {
        if (!(child.getPsi() instanceof GspHtmlOuterElement)) {
            if (this.doesNotIntersectSubTagsWith(child.getPsi())) {
                GspBlockGenerator.createHtmlBlockByChildNode(result2, this.myNode, child, wrap, alignment, this.myXmlFormattingPolicy, this.calculateNestedGspTagsForElement(child.getPsi()));
                return child;
            }
            XmlTag[] tags = this.calculateIntersectedTags(child.getPsi(), false);
            ASTNode inner = child.getFirstChildNode();
            while (inner != null) {
                if (inner.getText().trim().length() == 0) {
                    inner = inner.getTreeNext();
                    continue;
                }
                if (!(inner instanceof CompositeElement) && GspHtmlBlock.intersects(inner, tags)) {
                    inner = inner.getTreeNext();
                    continue;
                }
                if ((inner instanceof XmlAttribute || inner instanceof XmlAttributeValue || inner instanceof XmlTag || inner instanceof XmlText || inner instanceof PsiErrorElement) && GspHtmlBlock.intersects(inner, tags)) {
                    this.processCompositeElementRecursive(inner, this.calculateIntersectedTags(inner.getPsi(), true), result2, wrap, alignment, indent);
                    inner = inner.getTreeNext();
                    continue;
                }
                inner = this.processInnerChild(inner, wrap, alignment, result2);
            }
            for (XmlTag tag : tags) {
                if (GspHtmlBlock.alreadyHas(tag, result2)) continue;
                GspBlockGenerator.createGspBlockByChildNode(result2, this.myNode, tag.getNode(), wrap, alignment, this.myXmlFormattingPolicy);
            }
            if (tags.length > 0) {
                ASTNode found;
                for (found = this.myNode.findLeafElementAt(tags[tags.length - 1].getTextRange().getEndOffset() - this.myNode.getStartOffset()); found != null && !this.myNode.equals(found.getTreeParent()); found = found.getTreeParent()) {
                }
                return found;
            }
            return child;
        }
        return this.processInnerChild(child, wrap, alignment, result2);
    }

    private void processCompositeElementRecursive(ASTNode inner, XmlTag[] tags, List<Block> result2, Wrap wrap, Alignment alignment, Indent indent) {
        for (ASTNode node : inner.getChildren(null)) {
            if (node.getText().trim().length() <= 0) continue;
            if (!GspHtmlBlock.intersects(node, tags)) {
                GspBlockGenerator.createHtmlBlockByChildNode(result2, this.myNode, node, wrap, alignment, this.myXmlFormattingPolicy, this.calculateNestedGspTagsForElement(inner.getPsi()));
                continue;
            }
            if (!GspHtmlBlock.nonContainedInTags(node, tags)) continue;
            this.processCompositeElementRecursive(node, tags, result2, wrap, alignment, indent);
        }
    }

    private static boolean alreadyHas(XmlTag tag, List<Block> result2) {
        for (Block block : result2) {
            if (!block.getTextRange().equals((Object)tag.getTextRange())) continue;
            return true;
        }
        return false;
    }

    public Spacing getSpacing(Block child1, @NotNull Block child2) {
        if (child2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "child2", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspHtmlBlock", "getSpacing"));
        }
        if (child1 instanceof AbstractGspBlock && child2 instanceof AbstractGspBlock) {
            return GspSpacingProcessor.getSpacing(this.myXmlFormattingPolicy, (AbstractGspBlock)child1, (AbstractGspBlock)child2);
        }
        return null;
    }

    protected boolean doesNotIntersectSubTagsWith(PsiElement element) {
        TextRange range = element.getTextRange();
        for (XmlTag subTag : this.myNestedGspTags) {
            TextRange subTagRange = subTag.getTextRange();
            if (subTagRange.getEndOffset() < range.getStartOffset() || subTagRange.getStartOffset() > range.getEndOffset() || !GspHtmlBlock.areOvercrossing(range, subTagRange)) continue;
            return false;
        }
        return true;
    }

    private XmlTag[] calculateIntersectedTags(PsiElement element, boolean isInner) {
        if (element == null) {
            return XmlTag.EMPTY;
        }
        TextRange range = element.getTextRange();
        ArrayList<XmlTag> tags = new ArrayList<XmlTag>();
        for (XmlTag subTag : this.myNestedGspTags) {
            TextRange subTagRange = subTag.getTextRange();
            if (subTagRange.getEndOffset() < range.getStartOffset() || subTagRange.getStartOffset() > range.getEndOffset() || !GspHtmlBlock.areOvercrossing(range, subTagRange) && (!isInner || !subTagRange.contains(range))) continue;
            tags.add(subTag);
        }
        GspHtmlBlock.filterInners(tags);
        XmlTag[] tagsArr = tags.toArray(new XmlTag[tags.size()]);
        Arrays.sort(tagsArr, myComparator);
        return tagsArr;
    }

    private static void filterInners(Collection<XmlTag> tags) {
        for (XmlTag tag : tags) {
            Iterator<XmlTag> innerIterator = tags.iterator();
            while (innerIterator.hasNext()) {
                XmlTag xmlTag = innerIterator.next();
                if (!tag.getTextRange().contains(xmlTag.getTextRange()) || tag == xmlTag) continue;
                innerIterator.remove();
            }
        }
    }

    public static boolean areOvercrossing(TextRange range, TextRange subTagRange) {
        return range.getStartOffset() > subTagRange.getStartOffset() && range.getStartOffset() < subTagRange.getEndOffset() && range.getEndOffset() >= subTagRange.getEndOffset() || range.getEndOffset() > subTagRange.getStartOffset() && range.getEndOffset() <= subTagRange.getEndOffset() && range.getStartOffset() <= subTagRange.getStartOffset();
    }

    private XmlTag[] calculateNestedGspTagsForElement(PsiElement element) {
        TextRange range = element.getTextRange();
        ArrayList<XmlTag> tags = new ArrayList<XmlTag>();
        for (XmlTag tag : this.myNestedGspTags) {
            if (!range.contains(tag.getTextRange())) continue;
            tags.add(tag);
        }
        return tags.toArray(XmlTag.EMPTY);
    }

    @NotNull
    public ChildAttributes getChildAttributes(int newChildIndex) {
        ASTNode astNode = this.getNode();
        PsiElement psiParent = astNode.getPsi();
        if (psiParent instanceof HtmlTag) {
            ChildAttributes childAttributes = new ChildAttributes(GspIndentProcessor.indentForHtmlTag(this.myXmlFormattingPolicy, (XmlTag)((HtmlTag)psiParent)), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspHtmlBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        if (psiParent instanceof XmlTag) {
            ChildAttributes childAttributes = new ChildAttributes(Indent.getNormalIndent(), null);
            if (childAttributes == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspHtmlBlock", "getChildAttributes"));
            }
            return childAttributes;
        }
        ChildAttributes childAttributes = new ChildAttributes(Indent.getNoneIndent(), null);
        if (childAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/lang/gsp/formatter/GspHtmlBlock", "getChildAttributes"));
        }
        return childAttributes;
    }

    public boolean insertLineBreakBeforeTag() {
        return false;
    }

    public boolean removeLineBreakBeforeTag() {
        return false;
    }

    public boolean isTextElement() {
        return this.myNode.getElementType() == XmlElementType.XML_TEXT || this.myNode.getElementType() == XmlElementType.XML_DATA_CHARACTERS || this.myNode.getElementType() == XmlElementType.XML_CHAR_ENTITY_REF;
    }

    public Indent getIndent() {
        return this.myIndent;
    }
}

