/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.lang.gsp.highlighter;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighterFactory;
import com.intellij.openapi.editor.impl.EditorHighlighterCache;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.cache.impl.id.PlatformIdTableBuilding;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.lang.gsp.lexer.GspTokenTypesEx;
import org.jetbrains.plugins.grails.lang.gsp.lexer.core.GspTokenTypes;
import org.jetbrains.plugins.grails.lang.gsp.psi.gsp.api.GspFile;
import org.jetbrains.plugins.groovy.lang.groovydoc.parser.GroovyDocElementTypes;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;

public class GspIndexPatternBuilder
implements IndexPatternBuilder {
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspIndexPatternBuilder", "getIndexingLexer"));
        }
        if (file instanceof GspFile) {
            EditorHighlighter highlighter;
            Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
            boolean alreadyInitializedHighlighter = false;
            EditorHighlighter cachedEditorHighlighter = EditorHighlighterCache.getEditorHighlighterForCachesBuilding((Document)document);
            if (cachedEditorHighlighter != null && PlatformIdTableBuilding.checkCanUseCachedEditorHighlighter((CharSequence)file.getText(), (EditorHighlighter)cachedEditorHighlighter)) {
                highlighter = cachedEditorHighlighter;
                alreadyInitializedHighlighter = true;
            } else {
                VirtualFile virtualFile = file.getVirtualFile();
                if (virtualFile == null) {
                    return null;
                }
                highlighter = EditorHighlighterFactory.getInstance().createEditorHighlighter(file.getProject(), virtualFile);
            }
            return new LexerEditorHighlighterLexer(highlighter, alreadyInitializedHighlighter);
        }
        return null;
    }

    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/grails/lang/gsp/highlighter/GspIndexPatternBuilder", "getCommentTokenSet"));
        }
        return GspTokenTypesEx.GSP_COMMENTS;
    }

    public int getCommentStartDelta(IElementType tokenType) {
        if (tokenType == GspTokenTypes.JSP_STYLE_COMMENT || tokenType == GspTokenTypes.GSP_STYLE_COMMENT) {
            return 4;
        }
        return 0;
    }

    public int getCommentEndDelta(IElementType tokenType) {
        if (tokenType == GspTokenTypes.JSP_STYLE_COMMENT || tokenType == GspTokenTypes.GSP_STYLE_COMMENT) {
            return 4;
        }
        if (tokenType == GroovyTokenTypes.mML_COMMENT || tokenType == GroovyDocElementTypes.GROOVY_DOC_COMMENT) {
            return 2;
        }
        return 0;
    }
}

