/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.references.constraints;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedHashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.grails.references.constraints.GrailsConstraintsUtil;
import org.jetbrains.plugins.grails.references.domain.GormUtils;
import org.jetbrains.plugins.groovy.extensions.GroovyNamedArgumentProvider;
import org.jetbrains.plugins.groovy.extensions.NamedArgumentDescriptor;
import org.jetbrains.plugins.groovy.extensions.impl.NamedArgumentDescriptorBase;
import org.jetbrains.plugins.groovy.extensions.impl.NamedArgumentDescriptorImpl;
import org.jetbrains.plugins.groovy.extensions.impl.StringTypeCondition;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyPsiManager;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;

public class GrailsConstraintNamedArgumentProvider
extends GroovyNamedArgumentProvider {
    static final Map<String, Trinity<String, Integer, ?>> DESCRIPTORS = new LinkedHashMap();
    private static final int SUPPORT_ANY = 1;
    private static final int SUPPORT_STRING = 2;
    private static final int SUPPORT_COLLECTIONS = 4;
    private static final int SUPPORT_NOT_PRIMITIVE = 8;
    private static final int SUPPORT_DECIMAL = 16;
    private static final int SUPPORT_COMPARABLE = 32;

    public void getNamedArguments(@NotNull GrCall call, @Nullable PsiElement resolve, @Nullable String argumentName, boolean forCompletion, Map<String, NamedArgumentDescriptor> result2) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "call", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider", "getNamedArguments"));
        }
        PsiType type = GrailsConstraintsUtil.getValidatedValueType(resolve);
        int fieldTypeRestriction = -1;
        if (forCompletion && type != null) {
            fieldTypeRestriction = 1;
            if (PsiType.BYTE.equals((Object)type) || PsiType.SHORT.equals((Object)type) || PsiType.INT.equals((Object)type) || PsiType.LONG.equals((Object)type) || PsiType.FLOAT.equals((Object)type) || PsiType.DOUBLE.equals((Object)type) || GroovyPsiManager.isInheritorCached((PsiType)type, (String)"java.lang.Comparable")) {
                fieldTypeRestriction |= 0x20;
            }
            PsiType boxedType = type;
            if (type instanceof PsiPrimitiveType) {
                boxedType = TypesUtil.boxPrimitiveType((PsiType)type, (PsiManager)call.getManager(), (GlobalSearchScope)call.getResolveScope());
            } else {
                fieldTypeRestriction |= 8;
            }
            if (boxedType.equalsToText("java.lang.String")) {
                fieldTypeRestriction |= 6;
            } else if (boxedType instanceof PsiArrayType || GroovyPsiManager.isInheritorCached((PsiType)boxedType, (String)"java.util.Collection")) {
                fieldTypeRestriction |= 4;
            } else if (boxedType.equalsToText("java.lang.Float") || boxedType.equalsToText("java.lang.Double") || boxedType.equalsToText("java.math.BigDecimal")) {
                fieldTypeRestriction |= 0x10;
            }
        }
        for (Map.Entry<String, Trinity<String, Integer, ?>> entry : DESCRIPTORS.entrySet()) {
            String name;
            if (argumentName != null && !argumentName.equals(entry.getKey()) || (fieldTypeRestriction & (Integer)entry.getValue().second) == 0 || "unique".equals(name = entry.getKey()) && !GrailsConstraintNamedArgumentProvider.isDomainConstraintMethod(call)) continue;
            Object argumentDescriptorMarker = entry.getValue().third;
            Object argumentDescriptor = argumentDescriptorMarker == MinMaxArgumentDescriptor.class ? (type == null ? NamedArgumentDescriptor.SIMPLE_ON_TOP : new MinMaxArgumentDescriptor(type)) : (NamedArgumentDescriptor)argumentDescriptorMarker;
            result2.put(name, (NamedArgumentDescriptor)new MyArgumentDescriptor((String)entry.getValue().first, (NamedArgumentDescriptor)argumentDescriptor, resolve));
        }
        if (argumentName == null || argumentName.equals("shared")) {
            result2.put("shared", NamedArgumentDescriptor.SIMPLE_ON_TOP);
        }
    }

    private static boolean isDomainConstraintMethod(GrCall method) {
        GrClosableBlock closure = (GrClosableBlock)PsiTreeUtil.getParentOfType((PsiElement)method, GrClosableBlock.class);
        if (closure == null) {
            return false;
        }
        PsiElement parent = closure.getParent();
        if (!(parent instanceof GrField)) {
            return false;
        }
        GrField field = (GrField)parent;
        if (!"constraints".equals(field.getName()) || !field.hasModifierProperty("static")) {
            return false;
        }
        PsiClass aClass = field.getContainingClass();
        return GormUtils.isGormBean(aClass);
    }

    static {
        DESCRIPTORS.put("creditCard", Trinity.create((Object)"org.codehaus.groovy.grails.validation.CreditCardConstraint", (Object)2, (Object)NamedArgumentDescriptor.TYPE_BOOL));
        DESCRIPTORS.put("email", Trinity.create((Object)"org.codehaus.groovy.grails.validation.EmailConstraint", (Object)2, (Object)NamedArgumentDescriptor.TYPE_BOOL));
        DESCRIPTORS.put("blank", Trinity.create((Object)"org.codehaus.groovy.grails.validation.BlankConstraint", (Object)2, (Object)NamedArgumentDescriptor.TYPE_BOOL));
        DESCRIPTORS.put("range", Trinity.create((Object)"org.codehaus.groovy.grails.validation.RangeConstraint", (Object)32, (Object)new StringTypeCondition("groovy.lang.Range")));
        DESCRIPTORS.put("inList", Trinity.create((Object)"org.codehaus.groovy.grails.validation.InListConstraint", (Object)1, (Object)new StringTypeCondition("java.util.List")));
        DESCRIPTORS.put("url", Trinity.create((Object)"org.codehaus.groovy.grails.validation.UrlConstraint", (Object)2, (Object)((Object)new StringArrayTypeCondition("java.lang.Boolean", "java.lang.String", "java.util.List"))));
        DESCRIPTORS.put("size", Trinity.create((Object)"org.codehaus.groovy.grails.validation.SizeConstraint", (Object)4, (Object)new StringTypeCondition("groovy.lang.IntRange")));
        DESCRIPTORS.put("matches", Trinity.create((Object)"org.codehaus.groovy.grails.validation.MatchesConstraint", (Object)2, (Object)NamedArgumentDescriptor.TYPE_STRING));
        DESCRIPTORS.put("min", Trinity.create((Object)"org.codehaus.groovy.grails.validation.MinConstraint", (Object)32, MinMaxArgumentDescriptor.class));
        DESCRIPTORS.put("max", Trinity.create((Object)"org.codehaus.groovy.grails.validation.MaxConstraint", (Object)32, MinMaxArgumentDescriptor.class));
        DESCRIPTORS.put("maxSize", Trinity.create((Object)"org.codehaus.groovy.grails.validation.MaxSizeConstraint", (Object)4, (Object)NamedArgumentDescriptor.TYPE_INTEGER));
        DESCRIPTORS.put("minSize", Trinity.create((Object)"org.codehaus.groovy.grails.validation.MinSizeConstraint", (Object)4, (Object)NamedArgumentDescriptor.TYPE_INTEGER));
        DESCRIPTORS.put("scale", Trinity.create((Object)"org.codehaus.groovy.grails.validation.ScaleConstraint", (Object)16, (Object)NamedArgumentDescriptor.TYPE_INTEGER));
        DESCRIPTORS.put("notEqual", Trinity.create((Object)"org.codehaus.groovy.grails.validation.NotEqualConstraint", (Object)1, (Object)NamedArgumentDescriptor.SIMPLE_ON_TOP));
        DESCRIPTORS.put("nullable", Trinity.create((Object)"org.codehaus.groovy.grails.validation.NullableConstraint", (Object)8, (Object)NamedArgumentDescriptor.TYPE_BOOL));
        DESCRIPTORS.put("validator", Trinity.create((Object)"org.codehaus.groovy.grails.validation.ValidatorConstraint", (Object)1, (Object)new StringTypeCondition("groovy.lang.Closure")));
        DESCRIPTORS.put("unique", Trinity.create((Object)"org.codehaus.groovy.grails.orm.hibernate.validation.UniqueConstraint", (Object)1, (Object)((Object)new StringArrayTypeCondition("java.lang.Boolean", "java.lang.String", "java.util.List"))));
    }

    static class StringArrayTypeCondition
    extends NamedArgumentDescriptorBase {
        @NotNull
        private final String[] myTypeNames;

        public StringArrayTypeCondition(String ... typeNames) {
            if (typeNames == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeNames", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$StringArrayTypeCondition", "<init>"));
            }
            this.myTypeNames = typeNames;
        }

        public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$StringArrayTypeCondition", "checkType"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$StringArrayTypeCondition", "checkType"));
            }
            for (String typeName : this.myTypeNames) {
                if (!GroovyPsiManager.isInheritorCached((PsiType)type, (String)typeName)) continue;
                return true;
            }
            return false;
        }
    }

    static class MyArgumentDescriptor
    extends NamedArgumentDescriptorImpl {
        private final PsiElement myContext;
        private final String myClassToNavigate;
        private final NamedArgumentDescriptor myDelegatedArgumentDescriptor;

        public MyArgumentDescriptor(String classToNavigate, NamedArgumentDescriptor delegatedArgumentDescriptor, PsiElement context) {
            this.myContext = context;
            this.myClassToNavigate = classToNavigate;
            this.myDelegatedArgumentDescriptor = delegatedArgumentDescriptor;
        }

        public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$MyArgumentDescriptor", "checkType"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$MyArgumentDescriptor", "checkType"));
            }
            return this.myDelegatedArgumentDescriptor.checkType(type, context);
        }

        public PsiElement getNavigationElement() {
            return JavaPsiFacade.getInstance((Project)this.myContext.getProject()).findClass(this.myClassToNavigate, this.myContext.getResolveScope());
        }
    }

    static class MinMaxArgumentDescriptor
    extends NamedArgumentDescriptorBase {
        private final PsiType myFieldType;

        public MinMaxArgumentDescriptor(@NotNull PsiType fieldType) {
            if (fieldType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldType", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$MinMaxArgumentDescriptor", "<init>"));
            }
            this.myFieldType = fieldType;
        }

        public boolean checkType(@NotNull PsiType type, @NotNull GroovyPsiElement context) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$MinMaxArgumentDescriptor", "checkType"));
            }
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/grails/references/constraints/GrailsConstraintNamedArgumentProvider$MinMaxArgumentDescriptor", "checkType"));
            }
            PsiType boxedType = TypesUtil.boxPrimitiveType((PsiType)type, (PsiManager)context.getManager(), (GlobalSearchScope)context.getResolveScope());
            return boxedType.isAssignableFrom(this.myFieldType);
        }
    }
}

