/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.grails.structure.sync;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.grails.structure.GrailsApplication;
import org.jetbrains.plugins.grails.structure.GrailsApplicationManager;

public abstract class GrailsApplicationBackgroundTask
extends Task.Backgroundable {
    @NotNull
    protected final NotNullLazyValue<Collection<GrailsApplication>> myApplicationsComputable;

    public GrailsApplicationBackgroundTask(@NotNull Project project, @NotNull String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask", "<init>"));
        }
        this(project, title, new GrailsApplicationsGetter(project));
    }

    protected GrailsApplicationBackgroundTask(@NotNull Project project, @NotNull String title, @NotNull NotNullLazyValue<Collection<GrailsApplication>> computable) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask", "<init>"));
        }
        if (computable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "computable", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask", "<init>"));
        }
        super(project, title, false);
        this.myApplicationsComputable = computable;
    }

    public final void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask", "run"));
        }
        Collection applications = (Collection)this.myApplicationsComputable.getValue();
        for (GrailsApplication application : applications) {
            indicator.checkCanceled();
            if (application.isDisposed()) continue;
            indicator.setText(this.getTitle() + " in " + application.getName());
            this.run(application, indicator);
        }
    }

    protected abstract void run(@NotNull GrailsApplication var1, @NotNull ProgressIndicator var2);

    private static class GrailsApplicationsGetter
    extends NotNullLazyValue<Collection<GrailsApplication>> {
        @NotNull
        private final Project myProject;

        private GrailsApplicationsGetter(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask$GrailsApplicationsGetter", "<init>"));
            }
            this.myProject = project;
        }

        @NotNull
        public Collection<GrailsApplication> compute() {
            Collection collection = (Collection)ApplicationManager.getApplication().runReadAction(() -> GrailsApplicationManager.getInstance(this.myProject).getApplications());
            if (collection == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/grails/structure/sync/GrailsApplicationBackgroundTask$GrailsApplicationsGetter", "compute"));
            }
            return collection;
        }
    }
}

