/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.gwt.index.impl;

import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.PathUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.gwt.index.JpsGwtModule;
import org.jetbrains.jps.incremental.artifacts.impl.JpsArtifactPathUtil;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.java.JpsJavaDependenciesEnumerator;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;

public class JpsGwtModuleImpl
implements JpsGwtModule {
    private final JpsModule myModule;
    private final File myModuleFile;
    private final boolean myInTests;
    private final List<String> myPublicPaths;
    private final List<String> mySourcePaths;
    private final List<String> myInheritedNames;
    private boolean myHasEntryPoints;
    private final String myOutputName;
    private final String myQualifiedName;
    private final String myModuleRootRelativePath;

    public JpsGwtModuleImpl(File moduleFile, JpsModule module, File sourceRoot, boolean inTests) throws JDOMException, IOException {
        this.myModule = module;
        this.myModuleFile = moduleFile;
        this.myInTests = inTests;
        this.myPublicPaths = new ArrayList<String>();
        this.mySourcePaths = new ArrayList<String>();
        this.myInheritedNames = new ArrayList<String>();
        String relativePath = FileUtil.toSystemIndependentName((String)FileUtil.getRelativePath((File)sourceRoot, (File)moduleFile));
        this.myModuleRootRelativePath = PathUtilRt.getParentPath((String)relativePath);
        this.myQualifiedName = StringUtil.trimEnd((String)relativePath, (String)".gwt.xml").replace('/', '.');
        Element root = JDOMUtil.load((File)moduleFile);
        String renameTo = root.getAttributeValue("rename-to");
        this.myOutputName = renameTo != null ? renameTo : this.myQualifiedName;
        for (Element child : root.getChildren()) {
            String name = child.getName();
            if (name.equals("public")) {
                ContainerUtil.addIfNotNull(this.myPublicPaths, (Object)child.getAttributeValue("path"));
                continue;
            }
            if (name.equals("source") || name.equals("super-source")) {
                ContainerUtil.addIfNotNull(this.mySourcePaths, (Object)child.getAttributeValue("path"));
                continue;
            }
            if (name.equals("entry-point")) {
                this.myHasEntryPoints = true;
                continue;
            }
            if (!name.equals("inherits")) continue;
            ContainerUtil.addIfNotNull(this.myInheritedNames, (Object)child.getAttributeValue("name"));
        }
    }

    @Override
    public boolean isInTests() {
        return this.myInTests;
    }

    @Override
    public boolean hasEntryPoints() {
        return this.myHasEntryPoints;
    }

    @Override
    public String getOutputName() {
        return this.myOutputName;
    }

    @Override
    public String getQualifiedName() {
        return this.myQualifiedName;
    }

    @Override
    @NotNull
    public File getModuleFile() {
        File file = this.myModuleFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleImpl", "getModuleFile"));
        }
        return file;
    }

    @Override
    @NotNull
    public JpsModule getModule() {
        JpsModule jpsModule = this.myModule;
        if (jpsModule == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleImpl", "getModule"));
        }
        return jpsModule;
    }

    private List<File> getRoots(List<String> originalRelativePaths, String defaultPath, final boolean includeTests) {
        final List<String> relativePaths = originalRelativePaths.isEmpty() ? Collections.singletonList(defaultPath) : originalRelativePaths;
        JpsJavaDependenciesEnumerator enumerator = JpsJavaExtensionService.dependencies((JpsModule)this.myModule);
        if (!includeTests) {
            enumerator.productionOnly();
        }
        final ArrayList<File> roots = new ArrayList<File>();
        enumerator.recursively().processModules((Consumer)new Consumer<JpsModule>(){

            public void consume(JpsModule module) {
                for (JpsModuleSourceRoot sourceRoot : module.getSourceRoots()) {
                    if (!sourceRoot.getRootType().equals(JavaSourceRootType.SOURCE) && (!includeTests || !sourceRoot.getRootType().equals(JavaSourceRootType.TEST_SOURCE))) continue;
                    for (String relativePath : relativePaths) {
                        String pathFromSourceRoot = JpsArtifactPathUtil.appendToPath((String)JpsGwtModuleImpl.this.myModuleRootRelativePath, (String)relativePath);
                        File root = new File(sourceRoot.getFile(), FileUtil.toSystemDependentName((String)pathFromSourceRoot));
                        if (!root.isDirectory()) continue;
                        roots.add(root);
                    }
                }
            }
        });
        return roots;
    }

    @Override
    public List<String> getInheritedNames() {
        return this.myInheritedNames;
    }

    @Override
    @NotNull
    public List<File> getPublicRoots(boolean includeTests) {
        List<File> list = this.getRoots(this.myPublicPaths, "public", includeTests);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleImpl", "getPublicRoots"));
        }
        return list;
    }

    @Override
    @NotNull
    public List<File> getSourceRoots(boolean includeTests) {
        List<File> list = this.getRoots(this.mySourcePaths, "client", includeTests);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/gwt/index/impl/JpsGwtModuleImpl", "getSourceRoots"));
        }
        return list;
    }
}

