/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.actions;

import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.lang.ant.config.AntConfigurationListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.atomic.AtomicBoolean;

public class TargetActionStub
extends AnAction
implements Disposable {
    private final String myActionId;
    private Project myProject;
    private final AtomicBoolean myActionInvoked = new AtomicBoolean(false);

    public TargetActionStub(String actionId, Project project) {
        super("ant target action stub");
        this.myActionId = actionId;
        this.myProject = project;
        Disposer.register((Disposable)project, (Disposable)this);
    }

    public void dispose() {
        ActionManager.getInstance().unregisterAction(this.myActionId);
        this.myProject = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(final AnActionEvent e) {
        if (this.myProject == null) {
            return;
        }
        try {
            final AntConfiguration config = AntConfiguration.getInstance(this.myProject);
            AntConfigurationListener listener = new AntConfigurationListener(){

                @Override
                public void configurationLoaded() {
                    config.removeAntConfigurationListener(this);
                    TargetActionStub.this.invokeAction(e);
                }
            };
            config.addAntConfigurationListener(listener);
            Disposer.register((Disposable)this.myProject, (Disposable)new ListenerRemover(config, listener));
        }
        finally {
            this.invokeAction(e);
            this.dispose();
        }
    }

    private void invokeAction(AnActionEvent e) {
        AnAction action = ActionManager.getInstance().getAction(this.myActionId);
        if (action == null || action instanceof TargetActionStub) {
            return;
        }
        if (!this.myActionInvoked.getAndSet(true)) {
            action.actionPerformed(e);
        }
    }

    private static class ListenerRemover
    implements Disposable {
        private AntConfiguration myConfig;
        private AntConfigurationListener myListener;

        private ListenerRemover(AntConfiguration config, AntConfigurationListener listener) {
            this.myConfig = config;
            this.myListener = listener;
        }

        public void dispose() {
            AntConfiguration configuration = this.myConfig;
            AntConfigurationListener listener = this.myListener;
            this.myConfig = null;
            this.myListener = null;
            if (configuration != null && listener != null) {
                configuration.removeAntConfigurationListener(listener);
            }
        }
    }
}

