/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.beans;

import com.intellij.spring.contexts.model.CachedLocalModel;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.diagram.SpringLocalModelsDataModel;
import com.intellij.spring.contexts.model.diagram.beans.LocalAnnotationModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalXmlModelWrapper;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public abstract class LocalModelWrapper<T extends LocalModel>
extends LocalModelGraphElementWrapper<T> {
    protected LocalModelWrapper(@NotNull T element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "<init>"));
        }
        super(element);
    }

    @Override
    public String getToolTip() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><table>");
        LocalModelWrapper.addTr(sb, "Context", this.getLocalModelQualifiedName());
        LocalModelWrapper.addTr(sb, "Beans", ((CachedLocalModel)this.myElement).getLocalBeans().size());
        LocalModelWrapper.addTr(sb, "Component Scans", ((LocalModel)this.myElement).getComponentScans().size());
        this.addImportsInformation(sb);
        sb.append("</table></html>");
        return sb.toString();
    }

    @Override
    @NotNull
    public T getElement() {
        LocalModel localModel = (LocalModel)super.getElement();
        if (localModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "getElement"));
        }
        return (T)localModel;
    }

    protected abstract void addImportsInformation(StringBuilder var1);

    @NotNull
    protected abstract String getLocalModelQualifiedName();

    protected static void addTr(@NotNull StringBuilder sb, @NotNull String title, int size) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "addTr"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "addTr"));
        }
        if (size > 0) {
            LocalModelWrapper.addTr(sb, title, String.valueOf(size));
        }
    }

    protected static void addTr(@NotNull StringBuilder sb, @NotNull String title, @NotNull String value) {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "addTr"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "addTr"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "addTr"));
        }
        sb.append("<tr><td><strong>");
        sb.append(title);
        sb.append(":</strong></td><td>");
        sb.append(value);
        sb.append("</td></tr>");
    }

    @NotNull
    public static LocalModelWrapper create(@NotNull LocalModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "create"));
        }
        if (model instanceof LocalXmlModel) {
            LocalXmlModelWrapper localXmlModelWrapper = new LocalXmlModelWrapper((LocalXmlModel)model);
            if (localXmlModelWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "create"));
            }
            return localXmlModelWrapper;
        }
        if (model instanceof LocalAnnotationModel) {
            LocalAnnotationModelWrapper localAnnotationModelWrapper = new LocalAnnotationModelWrapper((LocalAnnotationModel)model);
            if (localAnnotationModelWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "create"));
            }
            return localAnnotationModelWrapper;
        }
        throw new IllegalArgumentException(String.format("Spring local model '%s' is '%s' while only XML and Annotation models are supported", model.getConfig(), model.getClass().getName()));
    }

    @Override
    public Icon getIcon() {
        return ((LocalModel)this.myElement).getConfig().getIcon(0);
    }

    @Override
    public void accept(@NotNull SpringLocalModelsDataModel.RelatedVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitor", "com/intellij/spring/contexts/model/diagram/beans/LocalModelWrapper", "accept"));
        }
        visitor.visitLocalModel((LocalModel)this.myElement);
    }
}

