/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.extras;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramElementManager;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.extras.DiagramExtras;
import com.intellij.diagram.extras.EditNodeHandler;
import com.intellij.diagram.util.DiagramUtils;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.graph.GraphManager;
import com.intellij.openapi.graph.builder.util.GraphViewUtil;
import com.intellij.openapi.graph.layout.LayoutOrientation;
import com.intellij.openapi.graph.layout.LayoutStage;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.layout.hierarchic.HierarchicGroupLayouter;
import com.intellij.openapi.graph.layout.hierarchic.Layerer;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.contexts.model.diagram.beans.LocalModelWrapper;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDependencyEdge;
import com.intellij.ui.JBColor;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Container;
import java.awt.Point;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringLocalModelsExtras
extends DiagramExtras<LocalModelGraphElementWrapper> {
    private final boolean showModuleFilesetNodes;

    public SpringLocalModelsExtras(boolean showModuleFilesetNodes) {
        this.showModuleFilesetNodes = showModuleFilesetNodes;
    }

    @Nullable
    public Layouter getCustomLayouter(Graph2D graph, Project project) {
        HierarchicGroupLayouter layouter = GraphManager.getGraphManager().createHierarchicGroupLayouter();
        layouter.setOrientationLayouter((LayoutStage)GraphManager.getGraphManager().createOrientationLayouter(LayoutOrientation.LEFT_TO_RIGHT));
        layouter.setMinimalNodeDistance(40.0);
        layouter.setMinimalLayerDistance(80.0);
        layouter.setLayerer((Layerer)GraphManager.getGraphManager().createBFSLayerer());
        return layouter;
    }

    @NotNull
    public JComponent createNodeComponent(DiagramNode<LocalModelGraphElementWrapper> node, DiagramBuilder builder, Point basePoint, JPanel wrapper) {
        this.setEmptyBorders(wrapper);
        SimpleColoredComponent label = this.createLabel(builder, node);
        this.setColors(label);
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/extras/SpringLocalModelsExtras", "createNodeComponent"));
        }
        return simpleColoredComponent;
    }

    @NotNull
    public SimpleColoredComponent createLabel(DiagramBuilder builder, DiagramNode<LocalModelGraphElementWrapper> node) {
        SimpleColoredComponent label = new SimpleColoredComponent(){

            protected boolean shouldDrawMacShadow() {
                return !GraphViewUtil.isPrintMode() && (super.shouldDrawMacShadow() || UIUtil.isUnderDarcula());
            }
        };
        DiagramElementManager manager = builder.getProvider().getElementManager();
        String presentableName = manager.getElementTitle(node.getIdentifyingElement());
        if (presentableName != null) {
            if (GraphViewUtil.isPrintMode()) {
                label.append(presentableName, new SimpleTextAttributes(0, (Color)JBColor.BLACK));
            } else {
                label.append(presentableName, new SimpleTextAttributes(0, null));
            }
        }
        label.setIcon(node.getIcon());
        SimpleColoredComponent simpleColoredComponent = label;
        if (simpleColoredComponent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/diagram/extras/SpringLocalModelsExtras", "createLabel"));
        }
        return simpleColoredComponent;
    }

    public void setColors(SimpleColoredComponent label) {
        if (GraphViewUtil.isPrintMode()) {
            label.setForeground((Color)JBColor.BLACK);
        }
        label.setOpaque(false);
        label.setIconOpaque(false);
        label.setForeground(JBColor.foreground());
    }

    public void setEmptyBorders(JPanel wrapper) {
        wrapper.setBorder((Border)JBUI.Borders.empty());
        Container outerPanel = wrapper.getParent();
        if (outerPanel instanceof JPanel) {
            ((JPanel)outerPanel).setBorder((Border)JBUI.Borders.empty());
        }
        wrapper.setBackground(JBColor.background());
    }

    @Nullable
    public EditNodeHandler<LocalModelGraphElementWrapper> getEditNodeHandler() {
        return super.getEditNodeHandler();
    }

    public Object getData(String dataId, List<DiagramNode<LocalModelGraphElementWrapper>> diagramNodes, DiagramBuilder builder) {
        List edges;
        LocalModelGraphElementWrapper wrapper;
        if (!CommonDataKeys.NAVIGATABLE.is(dataId) && !CommonDataKeys.PSI_ELEMENT.is(dataId)) {
            return super.getData(dataId, diagramNodes, builder);
        }
        if (diagramNodes != null && diagramNodes.size() == 1 && (wrapper = (LocalModelGraphElementWrapper)diagramNodes.get(0).getIdentifyingElement()) instanceof LocalModelWrapper) {
            Object localModel = ((LocalModelWrapper)wrapper).getElement();
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) || CommonDataKeys.NAVIGATABLE.is(dataId)) {
                return localModel.getConfig();
            }
        }
        if ((edges = DiagramUtils.getSelectedEdges((DiagramBuilder)builder)).size() == 1) {
            DiagramEdge edge = (DiagramEdge)edges.get(0);
            PsiElement psiElement = null;
            if (edge instanceof SpringLocalModelDependencyEdge) {
                psiElement = ((SpringLocalModelDependencyEdge)edge).getDependency().getIdentifyingElement();
            }
            if (psiElement != null && CommonDataKeys.PSI_ELEMENT.is(dataId)) {
                return psiElement;
            }
        }
        return super.getData(dataId, diagramNodes, builder);
    }
}

