/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns;

import com.intellij.codeInsight.generation.PatternDescriptor;
import com.intellij.codeInsight.generation.PatternProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.actions.patterns.PatternActionAdapter;
import com.intellij.spring.model.actions.patterns.aop.AopPatternsGroup;
import com.intellij.spring.model.actions.patterns.dataAccess.GenerateDataAccessPatternsGroup;
import com.intellij.spring.model.actions.patterns.factoryBeans.GenerateCommonBeansPatternsGroup;
import com.intellij.spring.model.actions.patterns.integration.GenerateIntegrationPatternsGroup;
import com.intellij.spring.model.actions.patterns.integration.GenerateSchedulersPatternsGroup;
import java.util.ArrayList;
import java.util.List;

public class SpringPatternProvider
implements PatternProvider {
    public PatternDescriptor[] getDescriptors() {
        ArrayList<PatternDescriptor> descriptors = new ArrayList<PatternDescriptor>();
        SpringPatternProvider.addItems(descriptors, new GenerateCommonBeansPatternsGroup());
        SpringPatternProvider.addItems(descriptors, new GenerateDataAccessPatternsGroup());
        SpringPatternProvider.addItems(descriptors, new GenerateIntegrationPatternsGroup());
        SpringPatternProvider.addItems(descriptors, new GenerateSchedulersPatternsGroup());
        SpringPatternProvider.addItems(descriptors, new AopPatternsGroup());
        return descriptors.toArray(new PatternDescriptor[descriptors.size()]);
    }

    private static void addItems(List<PatternDescriptor> descriptors, PatternActionAdapter group) {
        descriptors.addAll(group.getChildren());
    }

    public boolean isAvailable(DataContext context) {
        PsiFile file = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        return file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file));
    }
}

