/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.navigation;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.navigation.GotoRelatedItem;
import com.intellij.navigation.GotoRelatedProvider;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringModelRelatedFileProvider
extends GotoRelatedProvider {
    @NotNull
    public List<? extends GotoRelatedItem> getItems(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/spring/navigation/SpringModelRelatedFileProvider", "getItems"));
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null || SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/navigation/SpringModelRelatedFileProvider", "getItems"));
            }
            return list;
        }
        ArrayList<GotoRelatedItem> items = new ArrayList<GotoRelatedItem>();
        for (SpringModel model : SpringManager.getInstance((Project)psiElement.getProject()).getSpringModelsByFile(containingFile)) {
            SpringFileSet set = model.getFileSet();
            String groupName = set != null ? "Spring Context: \"" + set.getName() + "\"" : "Spring Application Contexts";
            SpringModelRelatedFileProvider.addItems(items, containingFile, (CommonSpringModel)model, groupName);
        }
        PsiClass type = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class);
        if (SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)type) && SpringTestContextUtil.getInstance().isTestContextConfigurationClass(type)) {
            SpringModelRelatedFileProvider.addItems(items, containingFile, SpringTestContextUtil.getInstance().getSpringTestingModel(type), "Spring Test Contexts");
        }
        if (!items.isEmpty()) {
            UsageTrigger.trigger((String)"spring.ModelRelatedProvider");
        }
        ArrayList<GotoRelatedItem> arrayList = items;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/navigation/SpringModelRelatedFileProvider", "getItems"));
        }
        return arrayList;
    }

    private static void addItems(@NotNull List<GotoRelatedItem> items, @NotNull PsiFile containingFile, @NotNull CommonSpringModel model, @NotNull String groupName) {
        if (items == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "items", "com/intellij/spring/navigation/SpringModelRelatedFileProvider", "addItems"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingFile", "com/intellij/spring/navigation/SpringModelRelatedFileProvider", "addItems"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/spring/navigation/SpringModelRelatedFileProvider", "addItems"));
        }
        if (groupName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupName", "com/intellij/spring/navigation/SpringModelRelatedFileProvider", "addItems"));
        }
        for (PsiFile file : model.getConfigFiles()) {
            if (file.equals(containingFile)) continue;
            items.add(new GotoRelatedItem((PsiElement)file, groupName));
        }
    }
}

