/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringManager;
import com.intellij.spring.contexts.model.CombinedSpringModelImpl;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringFileSetFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import icons.SpringApiIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringConfigFilesFinderRecursivePanel
extends FinderRecursivePanel<PsiFile> {
    @NotNull
    private final SpringFileSet myFileSet;
    private final Module myModule;

    public SpringConfigFilesFinderRecursivePanel(SpringFileSetFinderRecursivePanel panel, @NotNull SpringFileSet fileSet, Module module) {
        if (fileSet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileSet", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "<init>"));
        }
        super((FinderRecursivePanel)panel);
        this.myFileSet = fileSet;
        this.myModule = module;
    }

    @NotNull
    protected List<PsiFile> getListItems() {
        SpringModel model = this.findModel();
        if (model != null) {
            TreeSet files = new TreeSet((o1, o2) -> StringUtil.naturalCompare((String)o1.getName(), (String)o2.getName()));
            files.addAll(model.getConfigFiles());
            ArrayList<PsiFile> arrayList = new ArrayList<PsiFile>(files);
            if (arrayList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getListItems"));
            }
            return arrayList;
        }
        List<PsiFile> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getListItems"));
        }
        return list;
    }

    @Nullable
    private SpringModel findModel() {
        for (SpringModel model : SpringManager.getInstance((Project)this.getProject()).getAllModels(this.myModule)) {
            if (!this.myFileSet.equals((Object)model.getFileSet())) continue;
            return model;
        }
        return SpringCombinedModelFactory.createModel(this.myFileSet, this.myModule);
    }

    protected boolean hasChildren(PsiFile file) {
        return true;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        PsiFile psiFile = (PsiFile)this.getSelectedValue();
        if (CommonDataKeys.PSI_FILE.is(dataId) && psiFile != null) {
            return psiFile;
        }
        return super.getData(dataId);
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{ActionManager.getInstance().getAction("SpringChangeActiveProfiles")};
    }

    @NotNull
    protected String getItemText(PsiFile file) {
        if (file instanceof XmlFile) {
            String string = file.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getItemText"));
            }
            return string;
        }
        String string = FileUtil.getNameWithoutExtension((String)file.getName());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/toolWindow/panels/SpringConfigFilesFinderRecursivePanel", "getItemText"));
        }
        return string;
    }

    @Nullable
    private static PsiClass getTopLevelClass(PsiFile psiFile) {
        PsiClassOwner owner;
        PsiClass[] classes;
        if (!psiFile.isValid()) {
            return null;
        }
        if (psiFile instanceof PsiClassOwner && (classes = (owner = (PsiClassOwner)psiFile).getClasses()).length > 0) {
            return classes[0];
        }
        return null;
    }

    @Nullable
    protected Icon getItemIcon(PsiFile file) {
        PsiClass topLevelClass = SpringConfigFilesFinderRecursivePanel.getTopLevelClass(file);
        if (topLevelClass == null) {
            return file.getIcon(0);
        }
        if (SpringCommonUtils.isConfiguration((PsiClass)topLevelClass)) {
            return SpringApiIcons.SpringJavaConfig;
        }
        return topLevelClass.getIcon(0);
    }

    @Nullable
    protected VirtualFile getContainingFile(PsiFile psiFile) {
        return psiFile.getVirtualFile();
    }

    @Nullable
    protected JComponent createRightComponent(PsiFile file) {
        NullableFactory<CommonSpringModel> factory = this.getLocalSpringModel(file);
        return new SpringBeanPointerFinderRecursivePanel(this, factory);
    }

    private NullableFactory<CommonSpringModel> getLocalSpringModel(PsiFile file) {
        return () -> {
            PsiClass[] classes;
            if (!file.isValid()) {
                return null;
            }
            LocalXmlModel model = null;
            if (file instanceof XmlFile) {
                model = SpringManager.getInstance((Project)this.getProject()).getLocalSpringModel((XmlFile)file);
            } else if (file instanceof PsiClassOwner && (classes = ((PsiClassOwner)file).getClasses()).length == 1) {
                model = SpringManager.getInstance((Project)this.getProject()).getLocalSpringModel(classes[0]);
            }
            return model != null ? new CombinedSpringModelImpl((LocalModel)model) : null;
        };
    }
}

