/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MultiLineLabelUI;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.DoubleClickListener;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import icons.TFSIcons;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.plaf.LabelUI;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.tfsIntegration.checkin.CheckinParameters;
import org.jetbrains.tfsIntegration.checkin.CheckinPoliciesManager;
import org.jetbrains.tfsIntegration.checkin.NotInstalledPolicyFailure;
import org.jetbrains.tfsIntegration.checkin.PolicyFailure;
import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.ui.MultiLineTableRenderer;
import org.jetbrains.tfsIntegration.ui.WorkItemsPanel;

public class CheckinParametersForm
implements Disposable {
    private static final Color REQUIRED_BACKGROUND_COLOR = new Color(252, 248, 199);
    private static final Color NOT_INSTALLED_POLICY_COLOR = UIUtil.getInactiveTextColor();
    private static final Icon WARNING_ICON = UIUtil.getBalloonWarningIcon();
    private static final Icon ERROR_ICON = UIUtil.getBalloonErrorIcon();
    private static final Icon EMPTY_ICON = new EmptyIcon(0, WARNING_ICON.getIconHeight());
    private JPanel myContentPane;
    private JComboBox myServersCombo;
    private JPanel myServerChooserPanel;
    private JTabbedPane myTabbedPane;
    private JPanel myNotesPanel;
    private JPanel myCheckinNotesTab;
    private JLabel myErrorLabel;
    private JPanel myWorkItemsTab;
    private JPanel myPoliciesTab;
    private TableView<PolicyFailure> myWarningsTable;
    private JButton myEvaluateButton;
    private WorkItemsPanel myWorkItemsPanel;
    private final CheckinParameters myState;
    private final Project myProject;
    private static final MultiLineTableRenderer WARNING_TABLE_RENDERER = new MultiLineTableRenderer(){

        @Override
        protected void customize(JTable table, JTextArea textArea, boolean isSelected, Object value) {
            PolicyFailure failure = (PolicyFailure)value;
            textArea.setText(failure.getMessage());
            String tooltip = failure.getTooltipText();
            textArea.setToolTipText(StringUtil.isNotEmpty((String)tooltip) ? tooltip : null);
            Color foreground = isSelected ? table.getSelectionForeground() : (failure instanceof NotInstalledPolicyFailure ? NOT_INSTALLED_POLICY_COLOR : table.getForeground());
            textArea.setForeground(foreground);
        }
    };
    public static final ColumnInfo<PolicyFailure, PolicyFailure> WARNING_COLUMN_INFO = new ColumnInfo<PolicyFailure, PolicyFailure>("message"){

        public PolicyFailure valueOf(PolicyFailure policyFailure) {
            return policyFailure;
        }

        public TableCellRenderer getRenderer(PolicyFailure policyFailure) {
            return WARNING_TABLE_RENDERER;
        }
    };

    public CheckinParametersForm(CheckinParameters state, Project project) {
        this.myProject = project;
        this.myState = state;
        this.$$$setupUI$$$();
        this.myServersCombo.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ServerInfo) {
                    label.setText(((ServerInfo)value).getPresentableUri());
                }
                label.setIcon(TFSIcons.Teamserver);
                return label;
            }
        });
        this.myServersCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckinParametersForm.this.myWorkItemsPanel.update();
                CheckinParametersForm.this.udpateCheckinNotes();
                CheckinParametersForm.this.updatePoliciesWarnings();
                CheckinParametersForm.this.updateErrorMessage(false);
            }
        });
        this.myWarningsTable.setModelAndUpdateColumns(new ListTableModel(new ColumnInfo[]{WARNING_COLUMN_INFO}));
        this.myWarningsTable.setTableHeader(null);
        new DoubleClickListener(){

            protected boolean onDoubleClick(MouseEvent e) {
                PolicyFailure failure = (PolicyFailure)CheckinParametersForm.this.myWarningsTable.getSelectedObject();
                if (failure != null) {
                    failure.activate(CheckinParametersForm.this.myProject);
                }
                return true;
            }
        }.installOn(this.myWarningsTable);
        this.myEvaluateButton.setEnabled(this.myState.evaluationEnabled() && this.myState.getPoliciesLoadError() == null);
        this.myEvaluateButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CheckinParametersForm.this.evaluatePolicies();
            }
        });
        this.myServerChooserPanel.setVisible(this.myState.getServers().size() > 1);
        this.myServersCombo.setModel(new DefaultComboBoxModel<Object>(this.myState.getServers().toArray()));
        Pair<ServerInfo, ? extends Component> pair = this.getInitialSelectedTab();
        this.myServersCombo.setSelectedItem(pair.first);
        this.myTabbedPane.setSelectedIndex(this.myTabbedPane.indexOfComponent((Component)pair.second));
    }

    public CheckinParameters getState() {
        return this.myState;
    }

    public Project getProject() {
        return this.myProject;
    }

    private void evaluatePolicies() {
        boolean completed = ProgressManager.getInstance().runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                ProgressIndicator pi = ProgressManager.getInstance().getProgressIndicator();
                pi.setIndeterminate(true);
                CheckinParametersForm.this.myState.evaluatePolicies(pi);
            }
        }, "Evaluating Checkin Policies", true, this.myProject);
        if (completed) {
            this.updatePoliciesWarnings();
            this.updateErrorMessage(false);
        }
    }

    private void updatePoliciesWarnings() {
        ArrayList<PolicyFailure> failures = new ArrayList<PolicyFailure>();
        if (!this.myState.evaluationEnabled()) {
            failures.add(new PolicyFailure(CheckinPoliciesManager.DUMMY_POLICY, "Evaluation of checkin policies was disabled", "Use Project Settings | TFS configuration settings to enable checkin policies evaluation"));
        } else if (this.myState.getPoliciesLoadError() != null) {
            failures.add(new PolicyFailure(CheckinPoliciesManager.DUMMY_POLICY, "Cannot load checkin policies definitions", this.myState.getPoliciesLoadError()));
        } else if (!this.myState.policiesEvaluated()) {
            failures.add(new PolicyFailure(CheckinPoliciesManager.DUMMY_POLICY, "Checkin policies were not evaluated"){

                @Override
                public void activate(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/ui/CheckinParametersForm$8", "activate"));
                    }
                    CheckinParametersForm.this.evaluatePolicies();
                }
            });
        } else if (this.myState.getFailures(this.getSelectedServer()).isEmpty()) {
            failures.add(new PolicyFailure(CheckinPoliciesManager.DUMMY_POLICY, "All checkin policies are satisfied"){

                @Override
                public void activate(@NotNull Project project) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/tfsIntegration/ui/CheckinParametersForm$9", "activate"));
                    }
                }
            });
        } else {
            for (PolicyFailure failure : this.myState.getFailures(this.getSelectedServer())) {
                failures.add(failure);
            }
        }
        ((ListTableModel)this.myWarningsTable.getModel()).setItems(failures);
    }

    private Pair<ServerInfo, ? extends Component> getInitialSelectedTab() {
        for (ServerInfo server : this.myState.getServers()) {
            if (!this.myState.hasEmptyNotes(server)) continue;
            return Pair.create((Object)server, (Object)this.myCheckinNotesTab);
        }
        for (ServerInfo server : this.myState.getServers()) {
            if (!this.myState.hasPolicyFailures(server)) continue;
            return Pair.create((Object)server, (Object)this.myPoliciesTab);
        }
        return Pair.create((Object)this.myState.getServers().get(0), (Object)this.myWorkItemsTab);
    }

    private void createUIComponents() {
        this.myWorkItemsPanel = new WorkItemsPanel(this);
        Disposer.register((Disposable)this, (Disposable)this.myWorkItemsPanel);
        this.myErrorLabel = new JLabel(){

            @Override
            public void updateUI() {
                this.setUI((LabelUI)new MultiLineLabelUI());
            }

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }
        };
        this.myErrorLabel.setVerticalTextPosition(1);
    }

    public ServerInfo getSelectedServer() {
        return (ServerInfo)this.myServersCombo.getSelectedItem();
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    private void udpateCheckinNotes() {
        this.myNotesPanel.removeAll();
        List<CheckinParameters.CheckinNote> notes = this.myState.getCheckinNotes(this.getSelectedServer());
        Insets labelInsets = new Insets(0, 0, 5, 0);
        Insets fieldInsets = new Insets(0, 20, 10, 0);
        int i = 0;
        for (final CheckinParameters.CheckinNote note : notes) {
            String text = note.name + ":";
            if (note.required) {
                text = "<html><b>" + text + "</b></html>";
            }
            JLabel label = new JLabel(text);
            GridBagConstraints c = new GridBagConstraints(0, i++, 1, 1, 0.0, 0.0, 17, 0, labelInsets, 0, 0);
            this.myNotesPanel.add((Component)label, c);
            final JTextField field = new JTextField(note.value);
            if (note.required) {
                field.setBackground(REQUIRED_BACKGROUND_COLOR);
            }
            c = new GridBagConstraints(0, i++, 1, 1, 0.0, 0.0, 18, 2, fieldInsets, 0, 0);
            this.myNotesPanel.add((Component)field, c);
            field.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                protected void textChanged(DocumentEvent e) {
                    note.value = field.getText();
                    CheckinParametersForm.this.updateErrorMessage(true);
                }
            });
        }
        this.myNotesPanel.add((Component)new JPanel(), new GridBagConstraints(0, i, 1, 1, 1.0, 10.0, 17, 3, labelInsets, 0, 0));
    }

    public void updateErrorMessage(boolean evaluateNotes) {
        if (evaluateNotes) {
            this.myState.validateNotes();
        }
        Icon icon = this.myState.hasPolicyFailures(this.getSelectedServer()) ? WARNING_ICON : EMPTY_ICON;
        this.myTabbedPane.setIconAt(this.myTabbedPane.indexOfComponent(this.myPoliciesTab), icon);
        icon = this.myState.hasEmptyNotes(this.getSelectedServer()) ? ERROR_ICON : EMPTY_ICON;
        this.myTabbedPane.setIconAt(this.myTabbedPane.indexOfComponent(this.myCheckinNotesTab), icon);
        Pair<String, CheckinParameters.Severity> message = this.myState.getValidationMessage(CheckinParameters.Severity.BOTH);
        this.myErrorLabel.setText(message != null ? (String)message.first : null);
        this.myErrorLabel.setIcon(message == null ? null : (message.second == CheckinParameters.Severity.ERROR ? ERROR_ICON : WARNING_ICON));
    }

    public void dispose() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        TableView tableView;
        JPanel jPanel;
        JPanel jPanel2;
        JPanel jPanel3;
        JPanel jPanel4;
        JComboBox jComboBox;
        JPanel jPanel5;
        JPanel jPanel6;
        this.createUIComponents();
        this.myContentPane = jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerChooserPanel = jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.add((Component)jPanel5, new GridConstraints(0, 0, 1, 1, 1, 1, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Server:");
        jLabel.setDisplayedMnemonic('S');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myServersCombo = jComboBox = new JComboBox();
        jPanel5.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        this.myTabbedPane = jBTabbedPane;
        jPanel6.add((Component)jBTabbedPane, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 7, null, new Dimension(200, 200), null));
        this.myWorkItemsTab = jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Work Items", null, jPanel4, null);
        WorkItemsPanel workItemsPanel = this.myWorkItemsPanel;
        JComponent jComponent = workItemsPanel.$$$getRootComponent$$$();
        jPanel4.add((Component)jComponent, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myCheckinNotesTab = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Checkin Notes", null, jPanel3, null);
        JPanel jPanel7 = new JPanel();
        jPanel7.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel3.add((Component)jPanel7, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("<html><b>Highlighted fields are required</b></html>");
        jPanel7.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNotesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        jPanel7.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 7, null, null, null));
        this.myPoliciesTab = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Policy Warnings", null, jPanel, null);
        JPanel jPanel8 = new JPanel();
        jPanel8.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(5, 5, 5, 5), -1, -1, false, false));
        jPanel.add((Component)jPanel8, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jBScrollPane.setHorizontalScrollBarPolicy(31);
        jPanel8.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 2, 0, 3, 7, 7, null, null, null));
        this.myWarningsTable = tableView = new TableView();
        tableView.setAutoResizeMode(3);
        jBScrollPane.setViewportView((Component)tableView);
        this.myEvaluateButton = jButton = new JButton();
        jButton.setToolTipText("Evaluate checkin policies for all affected TFS servers");
        jButton.setText("Evaluate All");
        jButton.setMnemonic('E');
        jButton.setDisplayedMnemonicIndex(0);
        jPanel8.add((Component)jButton, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel8.add((Component)spacer2, new GridConstraints(1, 1, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel3 = this.myErrorLabel;
        jLabel3.setText(" ");
        jPanel6.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

