/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.tfsIntegration.ui.checkoutwizard;

import org.jetbrains.tfsIntegration.core.tfs.ServerInfo;
import org.jetbrains.tfsIntegration.core.tfs.WorkspaceInfo;

public class CheckoutWizardModel {
    private ServerInfo myServer;
    private Mode myMode = Mode.Auto;
    private WorkspaceInfo myWorkspace;
    private String myNewWorkspaceName;
    private String myServerPath;
    private String myDestinationFolder;

    public ServerInfo getServer() {
        return this.myServer;
    }

    public Mode getMode() {
        return this.myMode;
    }

    public WorkspaceInfo getWorkspace() {
        return this.myWorkspace;
    }

    public String getNewWorkspaceName() {
        return this.myNewWorkspaceName;
    }

    public String getServerPath() {
        return this.myServerPath;
    }

    public String getDestinationFolder() {
        return this.myDestinationFolder;
    }

    public void setServer(ServerInfo server) {
        if (this.myServer != null && !this.myServer.getUri().equals(server.getUri())) {
            this.myWorkspace = null;
            this.myServerPath = null;
        }
        this.myServer = server;
    }

    public void setMode(Mode mode) {
        this.myMode = mode;
    }

    public void setWorkspace(WorkspaceInfo workspace) {
        if (this.myMode != Mode.Manual) {
            throw new IllegalStateException("Attempt to set workspace in Auto mode");
        }
        this.myWorkspace = workspace;
    }

    public void setNewWorkspaceName(String newWorkspaceName) {
        this.myNewWorkspaceName = newWorkspaceName;
    }

    public void setServerPath(String serverPath) {
        this.myServerPath = serverPath;
    }

    public void setDestinationFolder(String destinationFolder) {
        if (this.myMode != Mode.Auto) {
            throw new IllegalStateException("Attempt to set destination path in Manual mode");
        }
        this.myDestinationFolder = destinationFolder;
    }

    public boolean isComplete() {
        if (this.getServer() == null) {
            return false;
        }
        if (this.getMode() == Mode.Auto) {
            if (this.getNewWorkspaceName() == null || this.getNewWorkspaceName().length() == 0) {
                return false;
            }
            if (this.getDestinationFolder() == null) {
                return false;
            }
        } else if (this.getWorkspace() == null) {
            return false;
        }
        return true;
    }

    public static enum Mode {
        Auto,
        Manual;

    }
}

