/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.heroku.cloud;

import com.intellij.execution.ExecutionException;
import com.intellij.javaee.heroku.agent.cloud.HerokuCloudAgentDeployment;
import com.intellij.javaee.heroku.cloud.HerokuDeploymentConfiguration;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugConnectionData;
import com.intellij.remoteServer.runtime.deployment.debug.JavaDebugServerModeHandler;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.ServerRuntimeException;
import org.jetbrains.annotations.Nullable;

public class HerokuDebugConnectionDelegate
extends JavaDebugServerModeHandler {
    private final DeploymentTask<? extends CloudDeploymentNameConfiguration> myDeploymentTask;
    private final HerokuCloudAgentDeployment myAgentDeployment;
    private final AgentTaskExecutor myAgentTaskExecutor;

    public HerokuDebugConnectionDelegate(DeploymentTask<? extends CloudDeploymentNameConfiguration> task, HerokuCloudAgentDeployment deployment, AgentTaskExecutor executor) {
        this.myDeploymentTask = task;
        this.myAgentDeployment = deployment;
        this.myAgentTaskExecutor = executor;
    }

    public JavaDebugConnectionData getDebugConnectionData() throws ServerRuntimeException {
        HerokuDeploymentConfiguration deploymentConfiguration = (HerokuDeploymentConfiguration)this.myDeploymentTask.getConfiguration();
        return new JavaDebugConnectionData("127.0.0.1", deploymentConfiguration.getDebugPort()){

            @Nullable
            public JavaDebugServerModeHandler getServerModeHandler() {
                return HerokuDebugConnectionDelegate.this;
            }
        };
    }

    public void attachRemote() throws ExecutionException {
        HerokuDeploymentConfiguration deploymentConfiguration = (HerokuDeploymentConfiguration)this.myDeploymentTask.getConfiguration();
        try {
            this.myAgentTaskExecutor.execute(() -> {
                this.myAgentDeployment.attachDebugRemote(deploymentConfiguration.getHost(), deploymentConfiguration.getDebugPort());
                return null;
            });
        }
        catch (ServerRuntimeException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    public void detachRemote() throws ExecutionException {
        try {
            this.doDetachRemote();
        }
        catch (ServerRuntimeException e) {
            throw new ExecutionException((Throwable)e);
        }
    }

    private void doDetachRemote() throws ServerRuntimeException {
        this.myAgentTaskExecutor.execute(() -> {
            this.myAgentDeployment.detachDebugRemote();
            return null;
        });
    }

    public void checkDebugMode() throws ServerRuntimeException {
        if (this.myDeploymentTask.isDebugMode()) {
            HerokuDeploymentConfiguration deploymentConfiguration = (HerokuDeploymentConfiguration)this.myDeploymentTask.getConfiguration();
            if (deploymentConfiguration.getDebugPort() == null) {
                throw new ServerRuntimeException("Debug port required");
            }
            if (deploymentConfiguration.getHost() == null) {
                throw new ServerRuntimeException("Debug host required");
            }
        }
        this.doDetachRemote();
    }
}

