/*
 * Decompiled with CFR 0.152.
 */
package git4idea.history;

import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.diff.ItemLatestState;
import com.intellij.openapi.vcs.history.VcsFileRevision;
import com.intellij.openapi.vcs.history.VcsRevisionDescription;
import com.intellij.openapi.vcs.history.VcsRevisionDescriptionImpl;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.NullableFunction;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsCommitMetadata;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsLogObjectsFactory;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.VcsRef;
import com.intellij.vcs.log.VcsRefType;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.HashImpl;
import com.intellij.vcs.log.impl.LogDataImpl;
import com.intellij.vcs.log.util.StopWatch;
import git4idea.GitCommit;
import git4idea.GitFileRevision;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.commands.GitCommand;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerAdapter;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitSimpleHandler;
import git4idea.commands.GitTextHandler;
import git4idea.config.GitVersion;
import git4idea.config.GitVersionSpecialty;
import git4idea.history.GitChangeType;
import git4idea.history.GitLogParser;
import git4idea.history.GitLogRecord;
import git4idea.history.GitLogStatusInfo;
import git4idea.history.browser.GitHeavyCommit;
import git4idea.history.browser.SHAHash;
import git4idea.history.browser.SymbolicRefs;
import git4idea.history.browser.SymbolicRefsI;
import git4idea.history.wholeTree.AbstractHash;
import git4idea.i18n.GitBundle;
import git4idea.log.GitLogProvider;
import git4idea.log.GitRefManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitHistoryUtils {
    public static final List<String> LOG_ALL = Arrays.asList("HEAD", "--branches", "--remotes", "--tags");
    private static final Logger LOG = Logger.getInstance((String)"#git4idea.history.GitHistoryUtils");

    private GitHistoryUtils() {
    }

    @Nullable
    public static VcsRevisionNumber getCurrentRevision(@NotNull Project project, @NotNull FilePath filePath, @Nullable String branch) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getCurrentRevision"));
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters(!StringUtil.isEmpty((String)branch) ? branch : "--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        return new GitRevisionNumber(record.getHash(), record.getDate());
    }

    @Nullable
    public static VcsRevisionDescription getCurrentRevisionDescription(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getCurrentRevisionDescription"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getCurrentRevisionDescription"));
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, GitUtil.getGitRoot(filePath), GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty());
        h.addParameters("--all");
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        record.setUsedHandler(h);
        String author = Comparing.equal((String)record.getAuthorName(), (String)record.getCommitterName()) ? record.getAuthorName() : record.getAuthorName() + " (" + record.getCommitterName() + ")";
        return new VcsRevisionDescriptionImpl((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), record.getDate(), author, record.getFullMessage());
    }

    @Nullable
    public static ItemLatestState getLastRevision(@NotNull Project project, @NotNull FilePath filePath) throws VcsException {
        GitRemoteBranch t;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getLastRevision"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getLastRevision"));
        }
        VirtualFile root = GitUtil.getGitRoot(filePath);
        GitLocalBranch c = GitBranchUtil.getCurrentBranch(project, root);
        GitRemoteBranch gitRemoteBranch = t = c == null ? null : GitBranchUtil.tracked(project, root, c.getName());
        if (t == null) {
            return new ItemLatestState(GitHistoryUtils.getCurrentRevision(project, filePath, null), true, false);
        }
        filePath = GitHistoryUtils.getLastCommitName(project, filePath);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setSilent(true);
        h.addParameters("-n1", parser.getPretty(), "--name-status", t.getFullName());
        h.endOptions();
        h.addRelativePaths(filePath);
        String result = h.run();
        if (result.length() == 0) {
            return null;
        }
        GitLogRecord record = parser.parseOneRecord(result);
        if (record == null) {
            return null;
        }
        List<Change> changes = record.parseChanges(project, root);
        boolean exists = changes.isEmpty() || !FileStatus.DELETED.equals(changes.get(0).getFileStatus());
        record.setUsedHandler(h);
        return new ItemLatestState((VcsRevisionNumber)new GitRevisionNumber(record.getHash(), record.getDate()), exists, false);
    }

    public static void history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @NotNull Consumer<GitFileRevision> consumer, @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (exceptionConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionConsumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        GitHistoryUtils.history(project, path, root, (VcsRevisionNumber)GitRevisionNumber.HEAD, consumer, exceptionConsumer, parameters);
    }

    public static void history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @NotNull VcsRevisionNumber startingRevision, @NotNull Consumer<GitFileRevision> consumer, final @NotNull Consumer<VcsException> exceptionConsumer, String ... parameters) {
        VirtualFile finalRoot;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (startingRevision == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingRevision", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (exceptionConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionConsumer", "git4idea/history/GitHistoryUtils", "history"));
        }
        FilePath filePath = GitHistoryUtils.getLastCommitName(project, path);
        try {
            finalRoot = root == null ? GitUtil.getGitRoot(filePath) : root;
        }
        catch (VcsException e) {
            exceptionConsumer.consume((Object)e);
            return;
        }
        GitLogParser logParser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.AUTHOR_TIME);
        AtomicReference<String> firstCommit = new AtomicReference<String>(startingRevision.asString());
        AtomicReference<String> firstCommitParent = new AtomicReference<String>(firstCommit.get());
        AtomicReference<FilePath> currentPath = new AtomicReference<FilePath>(filePath);
        AtomicReference<GitLineHandler> logHandler = new AtomicReference<GitLineHandler>();
        AtomicBoolean skipFurtherOutput = new AtomicBoolean();
        final Consumer resultAdapter = record -> {
            if (exceptionConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "exceptionConsumer", "git4idea/history/GitHistoryUtils", "lambda$history$0"));
            }
            if (consumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "git4idea/history/GitHistoryUtils", "lambda$history$0"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "lambda$history$0"));
            }
            if (skipFurtherOutput.get()) {
                return;
            }
            if (record == null) {
                exceptionConsumer.consume((Object)new VcsException("revision details are null."));
                return;
            }
            record.setUsedHandler((GitHandler)logHandler.get());
            GitRevisionNumber revision = new GitRevisionNumber(record.getHash(), record.getDate());
            firstCommit.set(record.getHash());
            String[] parentHashes = record.getParentsHashes();
            if (parentHashes.length < 1) {
                firstCommitParent.set(null);
            } else {
                firstCommitParent.set(parentHashes[0]);
            }
            String message = record.getFullMessage();
            try {
                List<FilePath> paths = record.getFilePaths(finalRoot);
                FilePath revisionPath = paths.size() > 0 ? paths.get(0) : (FilePath)currentPath.get();
                Couple authorPair = Couple.of((Object)record.getAuthorName(), (Object)record.getAuthorEmail());
                Couple committerPair = Couple.of((Object)record.getCommitterName(), (Object)record.getCommitterEmail());
                List<String> parents = Arrays.asList(parentHashes);
                consumer.consume((Object)new GitFileRevision(project, finalRoot, revisionPath, revision, (Couple<Couple<String>>)Couple.of((Object)authorPair, (Object)committerPair), message, null, new Date(record.getAuthorTimeStamp()), parents));
                List<GitLogStatusInfo> statusInfos = record.getStatusInfos();
                if (statusInfos.isEmpty()) {
                    return;
                }
                if (statusInfos.get(0).getType() == GitChangeType.ADDED && !filePath.isDirectory()) {
                    skipFurtherOutput.set(true);
                }
            }
            catch (VcsException e) {
                exceptionConsumer.consume((Object)e);
            }
        };
        GitVcs vcs = GitVcs.getInstance(project);
        GitVersion version = vcs != null ? vcs.getVersion() : GitVersion.NULL;
        final AtomicBoolean criticalFailure = new AtomicBoolean();
        while (currentPath.get() != null && firstCommitParent.get() != null) {
            logHandler.set(GitHistoryUtils.getLogHandler(project, version, finalRoot, logParser, currentPath.get(), firstCommitParent.get(), parameters));
            final MyTokenAccumulator accumulator = new MyTokenAccumulator(logParser);
            final Semaphore semaphore = new Semaphore();
            ((GitLineHandler)logHandler.get()).addLineListener(new GitLineHandlerAdapter(){

                @Override
                public void onLineAvailable(String line, Key outputType) {
                    GitLogRecord record = accumulator.acceptLine(line);
                    if (record != null) {
                        resultAdapter.consume((Object)record);
                    }
                }

                @Override
                public void startFailed(Throwable exception) {
                    try {
                        exceptionConsumer.consume((Object)new VcsException(exception));
                    }
                    finally {
                        criticalFailure.set(true);
                        semaphore.up();
                    }
                }

                @Override
                public void processTerminated(int exitCode) {
                    try {
                        super.processTerminated(exitCode);
                        GitLogRecord record = accumulator.processLast();
                        if (record != null) {
                            resultAdapter.consume((Object)record);
                        }
                    }
                    catch (Throwable t) {
                        LOG.error(t);
                        exceptionConsumer.consume((Object)new VcsException("Internal error " + t.getMessage(), t));
                        criticalFailure.set(true);
                    }
                    finally {
                        semaphore.up();
                    }
                }
            });
            semaphore.down();
            ((GitLineHandler)logHandler.get()).start();
            semaphore.waitFor();
            if (criticalFailure.get()) {
                return;
            }
            try {
                Pair<String, FilePath> firstCommitParentAndPath = GitHistoryUtils.getFirstCommitParentAndPathIfRename(project, finalRoot, firstCommit.get(), currentPath.get(), version);
                currentPath.set(firstCommitParentAndPath == null ? null : (FilePath)firstCommitParentAndPath.second);
                firstCommitParent.set(firstCommitParentAndPath == null ? null : (String)firstCommitParentAndPath.first);
                skipFurtherOutput.set(false);
            }
            catch (VcsException e) {
                LOG.warn("Tried to get first commit rename path", (Throwable)e);
                exceptionConsumer.consume((Object)e);
                return;
            }
        }
    }

    @NotNull
    private static GitLineHandler getLogHandler(@NotNull Project project, @NotNull GitVersion version, @NotNull VirtualFile root, @NotNull GitLogParser parser, @NotNull FilePath path, @NotNull String lastCommit, String ... parameters) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        if (lastCommit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lastCommit", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setStdoutSuppressed(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8", lastCommit);
        if (GitVersionSpecialty.FULL_HISTORY_SIMPLIFY_MERGES_WORKS_CORRECTLY.existsIn(version) && Registry.is((String)"git.file.history.full")) {
            h.addParameters("--full-history", "--simplify-merges");
        }
        if (parameters != null && parameters.length > 0) {
            h.addParameters(parameters);
        }
        h.endOptions();
        h.addRelativePaths(path);
        GitLineHandler gitLineHandler = h;
        if (gitLineHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "getLogHandler"));
        }
        return gitLineHandler;
    }

    @Nullable
    private static Pair<String, FilePath> getFirstCommitParentAndPathIfRename(@NotNull Project project, @NotNull VirtualFile root, @NotNull String commit, @NotNull FilePath filePath, @NotNull GitVersion version) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (commit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commit", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        if (version == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "version", "git4idea/history/GitHistoryUtils", "getFirstCommitParentAndPathIfRename"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.PARENTS);
        h.setStdoutSuppressed(true);
        h.addParameters("-M", "--name-status", parser.getPretty(), "--encoding=UTF-8", commit);
        if (!GitVersionSpecialty.FOLLOW_IS_BUGGY_IN_THE_LOG.existsIn(version)) {
            h.addParameters("--follow");
            h.endOptions();
            h.addRelativePaths(filePath);
        } else {
            h.endOptions();
        }
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.isEmpty()) {
            return null;
        }
        GitLogRecord record = records.get(0);
        List<Change> changes = record.parseChanges(project, root);
        for (Change change : changes) {
            if (!change.isMoved() && !change.isRenamed() || !filePath.equals(((ContentRevision)ObjectUtils.notNull((Object)change.getAfterRevision())).getFile())) continue;
            String[] parents = record.getParentsHashes();
            String parent = parents.length > 0 ? parents[0] : null;
            return Pair.create((Object)parent, (Object)((ContentRevision)ObjectUtils.notNull((Object)change.getBeforeRevision())).getFile());
        }
        return null;
    }

    @NotNull
    public static List<? extends VcsShortCommitDetails> readMiniDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> hashes) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "readMiniDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "readMiniDetails"));
        }
        if (hashes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hashes", "git4idea/history/GitHistoryUtils", "readMiniDetails"));
        }
        VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "readMiniDetails"));
            }
            return list;
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(hashes));
        h.endOptions();
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        List list = ContainerUtil.map(records, record -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$readMiniDetails$1"));
            }
            SmartList parents = new SmartList();
            for (String parent : record.getParentsHashes()) {
                parents.add(HashImpl.build((String)parent));
            }
            return factory.createShortDetails(HashImpl.build((String)record.getHash()), (List)parents, record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "readMiniDetails"));
        }
        return list;
    }

    @Nullable
    public static List<VcsCommitMetadata> readLastCommits(@NotNull Project project, @NotNull VirtualFile root, String ... refs) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/history/GitHistoryUtils", "readLastCommits"));
        }
        VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return null;
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.RAW_BODY, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--no-walk");
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(refs);
        h.endOptions();
        String output = h.run();
        List<GitLogRecord> records = parser.parse(output);
        if (records.size() != refs.length) {
            return null;
        }
        return ContainerUtil.map(records, record -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$readLastCommits$2"));
            }
            return factory.createCommitMetadata(factory.createHash(record.getHash()), GitHistoryUtils.getParentHashes(factory, record), record.getCommitTime(), root, record.getSubject(), record.getAuthorName(), record.getAuthorEmail(), record.getFullMessage(), record.getCommitterName(), record.getCommitterEmail(), record.getAuthorTimeStamp());
        });
    }

    private static void processHandlerOutputByLine(@NotNull GitLineHandler handler, @NotNull GitLogParser parser, @NotNull Consumer<GitLogRecord> recordConsumer) throws VcsException {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/history/GitHistoryUtils", "processHandlerOutputByLine"));
        }
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils", "processHandlerOutputByLine"));
        }
        if (recordConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordConsumer", "git4idea/history/GitHistoryUtils", "processHandlerOutputByLine"));
        }
        Ref parseError = new Ref();
        GitHistoryUtils.processHandlerOutputByLine(handler, (Consumer<StringBuilder>)((Consumer)builder -> {
            block7: {
                if (parser == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils", "lambda$processHandlerOutputByLine$3"));
                }
                if (recordConsumer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordConsumer", "git4idea/history/GitHistoryUtils", "lambda$processHandlerOutputByLine$3"));
                }
                if (handler == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/history/GitHistoryUtils", "lambda$processHandlerOutputByLine$3"));
                }
                try {
                    GitLogRecord record = parser.parseOneRecord(builder.toString());
                    if (record != null) {
                        recordConsumer.consume((Object)record);
                    }
                }
                catch (ProcessCanceledException pce) {
                    throw pce;
                }
                catch (Throwable t) {
                    if (!parseError.isNull()) break block7;
                    parseError.set((Object)t);
                    LOG.error("Could not parse \" " + StringUtil.escapeStringCharacters((String)builder.toString()) + "\"\nCommand " + handler.printableCommandLine(), t);
                }
            }
        }), 0);
        if (!parseError.isNull()) {
            throw new VcsException((Throwable)parseError.get());
        }
    }

    private static void processHandlerOutputByLine(@NotNull GitLineHandler handler, final @NotNull Consumer<StringBuilder> recordConsumer, final int bufferSize) throws VcsException {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/history/GitHistoryUtils", "processHandlerOutputByLine"));
        }
        if (recordConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "recordConsumer", "git4idea/history/GitHistoryUtils", "processHandlerOutputByLine"));
        }
        final StringBuilder output = new StringBuilder();
        final StringBuilder errors = new StringBuilder();
        final Ref foundRecordEnd = Ref.create((Object)false);
        final Ref ex = new Ref();
        final AtomicInteger records = new AtomicInteger();
        handler.addLineListener(new GitLineHandlerListener(){

            @Override
            public void onLineAvailable(String line, Key outputType) {
                if (outputType == ProcessOutputTypes.STDERR) {
                    errors.append(line).append("\n");
                } else if (outputType == ProcessOutputTypes.STDOUT) {
                    try {
                        String tail = null;
                        if (!((Boolean)foundRecordEnd.get()).booleanValue()) {
                            int recordEnd = line.indexOf("\u0003");
                            if (recordEnd != -1) {
                                foundRecordEnd.set((Object)true);
                                output.append(line.substring(0, recordEnd + 1));
                                line = line.substring(recordEnd + 1);
                            } else {
                                output.append(line).append("\n");
                            }
                        }
                        if (((Boolean)foundRecordEnd.get()).booleanValue()) {
                            int nextRecordStart = line.indexOf("\u0001");
                            if (nextRecordStart == -1) {
                                output.append(line).append("\n");
                            } else if (nextRecordStart == 0) {
                                tail = line + "\n";
                            } else {
                                output.append(line.substring(0, nextRecordStart));
                                tail = line.substring(nextRecordStart) + "\n";
                            }
                        }
                        if (tail != null) {
                            if (records.incrementAndGet() > bufferSize) {
                                recordConsumer.consume((Object)output);
                                output.setLength(0);
                            }
                            output.append(tail);
                            foundRecordEnd.set((Object)tail.contains("\u0003"));
                        }
                    }
                    catch (Exception e) {
                        ex.set((Object)new VcsException((Throwable)e));
                    }
                }
            }

            public void processTerminated(int exitCode) {
                if (exitCode != 0) {
                    String errorMessage = errors.toString();
                    if (errorMessage.isEmpty()) {
                        errorMessage = GitBundle.message("git.error.exit", exitCode);
                    }
                    ex.set((Object)new VcsException(errorMessage));
                } else {
                    try {
                        recordConsumer.consume((Object)output);
                    }
                    catch (Exception e) {
                        ex.set((Object)new VcsException((Throwable)e));
                    }
                }
            }

            public void startFailed(Throwable exception) {
                ex.set((Object)new VcsException(exception));
            }
        });
        handler.runInCurrentThread(null);
        if (!ex.isNull()) {
            if (((VcsException)((Object)ex.get())).getCause() instanceof ProcessCanceledException) {
                throw (ProcessCanceledException)((VcsException)((Object)ex.get())).getCause();
            }
            throw (VcsException)((Object)ex.get());
        }
    }

    public static void readCommits(@NotNull Project project, @NotNull VirtualFile root, @NotNull List<String> parameters, @NotNull Consumer<VcsUser> userConsumer, @NotNull Consumer<VcsRef> refConsumer, @NotNull Consumer<TimedVcsCommit> commitConsumer) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (userConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userConsumer", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (refConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitHistoryUtils", "readCommits"));
        }
        VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.NONE, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.REF_NAMES);
        h.setStdoutSuppressed(true);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.addParameters("--decorate=full");
        h.addParameters(parameters);
        h.endOptions();
        int COMMIT_BUFFER = 1000;
        GitHistoryUtils.processHandlerOutputByLine(h, (Consumer<StringBuilder>)((Consumer)buffer -> {
            if (userConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userConsumer", "git4idea/history/GitHistoryUtils", "lambda$readCommits$4"));
            }
            if (refConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitHistoryUtils", "lambda$readCommits$4"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$readCommits$4"));
            }
            if (commitConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitHistoryUtils", "lambda$readCommits$4"));
            }
            List<TimedVcsCommit> commits = GitHistoryUtils.parseCommit(parser, buffer, userConsumer, refConsumer, factory, root);
            for (TimedVcsCommit commit : commits) {
                commitConsumer.consume((Object)commit);
            }
        }), 1000);
    }

    @NotNull
    private static List<TimedVcsCommit> parseCommit(@NotNull GitLogParser parser, @NotNull StringBuilder record, @NotNull Consumer<VcsUser> userRegistry, @NotNull Consumer<VcsRef> refConsumer, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (parser == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (userRegistry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (refConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        List<GitLogRecord> gitLogRecords = parser.parse(record.toString());
        List list = ContainerUtil.mapNotNull(gitLogRecords, gitLogRecord -> {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "lambda$parseCommit$5"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$parseCommit$5"));
            }
            if (refConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refConsumer", "git4idea/history/GitHistoryUtils", "lambda$parseCommit$5"));
            }
            if (userRegistry == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userRegistry", "git4idea/history/GitHistoryUtils", "lambda$parseCommit$5"));
            }
            if (gitLogRecord == null) {
                return null;
            }
            Pair<TimedVcsCommit, Collection<VcsRef>> pair = GitHistoryUtils.convert(gitLogRecord, factory, root);
            TimedVcsCommit commit = (TimedVcsCommit)pair.first;
            for (VcsRef ref : (Collection)pair.second) {
                refConsumer.consume((Object)ref);
            }
            userRegistry.consume((Object)factory.createUser(gitLogRecord.getAuthorName(), gitLogRecord.getAuthorEmail()));
            return commit;
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "parseCommit"));
        }
        return list;
    }

    @NotNull
    private static Pair<TimedVcsCommit, Collection<VcsRef>> convert(@NotNull GitLogRecord rec, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (rec == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rec", "git4idea/history/GitHistoryUtils", "convert"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "convert"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "convert"));
        }
        Hash hash = HashImpl.build((String)rec.getHash());
        List<Hash> parents = GitHistoryUtils.getParentHashes(factory, rec);
        TimedVcsCommit commit = factory.createTimedCommit(hash, parents, rec.getCommitTime());
        Pair pair = Pair.create((Object)commit, GitHistoryUtils.parseRefs(rec.getRefs(), hash, factory, root));
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "convert"));
        }
        return pair;
    }

    @NotNull
    private static Collection<VcsRef> parseRefs(@NotNull Collection<String> refs, @NotNull Hash hash, @NotNull VcsLogObjectsFactory factory, @NotNull VirtualFile root) {
        if (refs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refs", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (hash == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        List list = ContainerUtil.mapNotNull(refs, refName -> {
            if (factory == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "lambda$parseRefs$6"));
            }
            if (hash == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hash", "git4idea/history/GitHistoryUtils", "lambda$parseRefs$6"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$parseRefs$6"));
            }
            VcsRefType type = GitRefManager.getRefType(refName);
            return (refName = GitBranchUtil.stripRefsPrefix(refName)).equals("origin/HEAD") ? null : factory.createRef(hash, refName, type, root);
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        return list;
    }

    @Nullable
    private static VcsLogObjectsFactory getObjectsFactoryWithDisposeCheck(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getObjectsFactoryWithDisposeCheck"));
        }
        return (VcsLogObjectsFactory)ApplicationManager.getApplication().runReadAction(() -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "lambda$getObjectsFactoryWithDisposeCheck$7"));
            }
            if (!project.isDisposed()) {
                return (VcsLogObjectsFactory)ServiceManager.getService((Project)project, VcsLogObjectsFactory.class);
            }
            return null;
        });
    }

    @NotNull
    public static List<VcsFileRevision> history(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        VirtualFile root = GitUtil.getGitRoot(path);
        List<VcsFileRevision> list = GitHistoryUtils.history(project, path, root, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    public static List<VcsFileRevision> history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        List<VcsFileRevision> list = GitHistoryUtils.history(project, path, root, (VcsRevisionNumber)GitRevisionNumber.HEAD, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    public static List<VcsFileRevision> history(@NotNull Project project, @NotNull FilePath path, @Nullable VirtualFile root, @NotNull VcsRevisionNumber startingFrom, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (startingFrom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingFrom", "git4idea/history/GitHistoryUtils", "history"));
        }
        ArrayList<VcsFileRevision> rc = new ArrayList<VcsFileRevision>();
        ArrayList exceptions = new ArrayList();
        GitHistoryUtils.history(project, path, root, startingFrom, (Consumer<GitFileRevision>)((Consumer)rc::add), (Consumer<VcsException>)((Consumer)exceptions::add), parameters);
        if (!exceptions.isEmpty()) {
            throw (VcsException)((Object)exceptions.get(0));
        }
        ArrayList<VcsFileRevision> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return arrayList;
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        VirtualFile root = GitUtil.getGitRoot(path);
        List<Pair<SHAHash, Date>> list = GitHistoryUtils.onlyHashesHistory(project, path, root, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        return list;
    }

    @Deprecated
    @NotNull
    public static List<Pair<SHAHash, Date>> onlyHashesHistory(@NotNull Project project, @NotNull FilePath path, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        GitLogParser parser = new GitLogParser(project, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        h.endOptions();
        h.addRelativePaths(path);
        String output = h.run();
        ArrayList<Pair<SHAHash, Date>> rc = new ArrayList<Pair<SHAHash, Date>>();
        for (GitLogRecord record : parser.parse(output)) {
            record.setUsedHandler(h);
            rc.add((Pair<SHAHash, Date>)Pair.create((Object)new SHAHash(record.getHash()), (Object)record.getDate()));
        }
        ArrayList<Pair<SHAHash, Date>> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "onlyHashesHistory"));
        }
        return arrayList;
    }

    @NotNull
    public static VcsLogProvider.DetailedLogData loadMetadata(@NotNull Project project, @NotNull VirtualFile root, String ... params) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            LogDataImpl logDataImpl = LogDataImpl.empty();
            if (logDataImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadMetadata"));
            }
            return logDataImpl;
        }
        OpenTHashSet refs = new OpenTHashSet(GitLogProvider.DONT_CONSIDER_SHA);
        List commits = GitHistoryUtils.collectDetails(project, root, true, false, arg_0 -> GitHistoryUtils.lambda$loadMetadata$9(project, root, factory, (Set)refs, arg_0), params);
        LogDataImpl logDataImpl = new LogDataImpl((Set)refs, commits);
        if (logDataImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "loadMetadata"));
        }
        return logDataImpl;
    }

    @NotNull
    public static List<GitCommit> history(@NotNull Project project, @NotNull VirtualFile root, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "history"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "history"));
        }
        VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            List<GitCommit> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
            }
            return list;
        }
        List<GitCommit> list = GitHistoryUtils.collectDetails(project, root, false, true, record -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "lambda$history$10"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$history$10"));
            }
            return GitHistoryUtils.createCommit(project, root, record, factory);
        }, parameters);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "history"));
        }
        return list;
    }

    @NotNull
    private static GitLogParser createParserForDetails(@NotNull GitTextHandler h, @NotNull Project project, boolean withRefs, boolean withChanges, String ... parameters) {
        if (h == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "h", "git4idea/history/GitHistoryUtils", "createParserForDetails"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "createParserForDetails"));
        }
        GitLogParser.NameStatus status = withChanges ? GitLogParser.NameStatus.STATUS : GitLogParser.NameStatus.NONE;
        GitLogParser.GitLogOption[] options = new GitLogParser.GitLogOption[]{GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY};
        if (withRefs) {
            options = (GitLogParser.GitLogOption[])ArrayUtil.append((Object[])options, (Object)((Object)GitLogParser.GitLogOption.REF_NAMES));
        }
        GitLogParser parser = new GitLogParser(project, status, options);
        h.setStdoutSuppressed(true);
        h.addParameters(parameters);
        h.addParameters(parser.getPretty(), "--encoding=UTF-8");
        if (withRefs) {
            h.addParameters("--decorate=full");
        }
        if (withChanges) {
            h.addParameters("-M", "--name-status", "-c");
        }
        h.endOptions();
        GitLogParser gitLogParser = parser;
        if (gitLogParser == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "createParserForDetails"));
        }
        return gitLogParser;
    }

    @NotNull
    public static <T> List<T> collectDetails(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, @NotNull NullableFunction<GitLogRecord, T> converter, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "collectDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "collectDetails"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitHistoryUtils", "collectDetails"));
        }
        ArrayList commits = ContainerUtil.newArrayList();
        GitHistoryUtils.loadDetails(project, root, withRefs, withChanges, (Consumer<GitLogRecord>)((Consumer)record -> {
            if (converter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitHistoryUtils", "lambda$collectDetails$11"));
            }
            commits.add(converter.fun(record));
        }), parameters);
        ArrayList arrayList = commits;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "collectDetails"));
        }
        return arrayList;
    }

    public static void loadDetails(@NotNull Project project, @NotNull VirtualFile root, @NotNull Consumer<VcsFullCommitDetails> commitConsumer, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (commitConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameters", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        VcsLogObjectsFactory factory = GitHistoryUtils.getObjectsFactoryWithDisposeCheck(project);
        if (factory == null) {
            return;
        }
        GitHistoryUtils.loadDetails(project, root, false, true, (Consumer<GitLogRecord>)((Consumer)record -> {
            if (commitConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitConsumer", "git4idea/history/GitHistoryUtils", "lambda$loadDetails$12"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "lambda$loadDetails$12"));
            }
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$loadDetails$12"));
            }
            commitConsumer.consume((Object)GitHistoryUtils.createCommit(project, root, record, factory));
        }), parameters);
    }

    public static void loadDetails(@NotNull Project project, @NotNull VirtualFile root, boolean withRefs, boolean withChanges, @NotNull Consumer<GitLogRecord> converter, String ... parameters) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitHistoryUtils", "loadDetails"));
        }
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        GitLogParser parser = GitHistoryUtils.createParserForDetails(h, project, withRefs, withChanges, parameters);
        StopWatch sw = StopWatch.start((String)"loading details");
        GitHistoryUtils.processHandlerOutputByLine(h, parser, (Consumer<GitLogRecord>)((Consumer)record -> {
            if (converter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "git4idea/history/GitHistoryUtils", "lambda$loadDetails$13"));
            }
            converter.consume(record);
        }));
        sw.report();
    }

    @NotNull
    private static GitCommit createCommit(@NotNull Project project, @NotNull VirtualFile root, @NotNull GitLogRecord record, @NotNull VcsLogObjectsFactory factory) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        List<Hash> parents = GitHistoryUtils.getParentHashes(factory, record);
        GitCommit gitCommit = new GitCommit(project, HashImpl.build((String)record.getHash()), parents, record.getCommitTime(), root, record.getSubject(), factory.createUser(record.getAuthorName(), record.getAuthorEmail()), record.getFullMessage(), factory.createUser(record.getCommitterName(), record.getCommitterEmail()), record.getAuthorTimeStamp(), record.getStatusInfos());
        if (gitCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        return gitCommit;
    }

    @NotNull
    private static List<Hash> getParentHashes(@NotNull VcsLogObjectsFactory factory, @NotNull GitLogRecord record) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        List list = ContainerUtil.map((Object[])record.getParentsHashes(), arg_0 -> ((VcsLogObjectsFactory)factory).createHash(arg_0));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "getParentHashes"));
        }
        return list;
    }

    @NotNull
    private static GitHeavyCommit createCommit(@NotNull Project project, @Nullable SymbolicRefsI refs, @NotNull VirtualFile root, @NotNull GitLogRecord record) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        if (record == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "record", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        Collection<String> currentRefs = record.getRefs();
        ArrayList<String> locals = new ArrayList<String>();
        ArrayList<String> remotes = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        String s = GitHistoryUtils.parseRefs(refs, currentRefs, locals, remotes, tags);
        GitHeavyCommit gitCommit = new GitHeavyCommit(root, AbstractHash.create(record.getHash()), new SHAHash(record.getHash()), record.getAuthorName(), record.getCommitterName(), record.getDate(), record.getSubject(), record.getFullMessage(), new HashSet<String>(Arrays.asList(record.getParentsHashes())), record.getFilePaths(root), record.getAuthorEmail(), record.getCommitterEmail(), tags, locals, remotes, record.parseChanges(project, root), record.getAuthorTimeStamp());
        gitCommit.setCurrentBranch(s);
        GitHeavyCommit gitHeavyCommit = gitCommit;
        if (gitHeavyCommit == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "createCommit"));
        }
        return gitHeavyCommit;
    }

    @Nullable
    private static String parseRefs(@Nullable SymbolicRefsI refs, @NotNull Collection<String> currentRefs, @NotNull List<String> locals, @NotNull List<String> remotes, @NotNull List<String> tags) {
        if (currentRefs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentRefs", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (locals == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "locals", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (tags == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tags", "git4idea/history/GitHistoryUtils", "parseRefs"));
        }
        if (refs == null) {
            return null;
        }
        for (String ref : currentRefs) {
            SymbolicRefs.Kind kind = refs.getKind(ref);
            if (SymbolicRefs.Kind.LOCAL.equals((Object)kind)) {
                locals.add(ref);
                continue;
            }
            if (SymbolicRefs.Kind.REMOTE.equals((Object)kind)) {
                remotes.add(ref);
                continue;
            }
            tags.add(ref);
        }
        if (refs.getCurrent() != null && currentRefs.contains(refs.getCurrent().getName())) {
            return refs.getCurrent().getName();
        }
        return null;
    }

    @Deprecated
    @NotNull
    public static List<GitHeavyCommit> commitsDetails(@NotNull Project project, @NotNull FilePath path, @Nullable SymbolicRefsI refs, @NotNull Collection<String> commitsIds) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        if (commitsIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsIds", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.HASH, GitLogParser.GitLogOption.COMMIT_TIME, GitLogParser.GitLogOption.AUTHOR_NAME, GitLogParser.GitLogOption.AUTHOR_TIME, GitLogParser.GitLogOption.AUTHOR_EMAIL, GitLogParser.GitLogOption.COMMITTER_NAME, GitLogParser.GitLogOption.COMMITTER_EMAIL, GitLogParser.GitLogOption.PARENTS, GitLogParser.GitLogOption.REF_NAMES, GitLogParser.GitLogOption.SUBJECT, GitLogParser.GitLogOption.BODY, GitLogParser.GitLogOption.RAW_BODY);
        h.setSilent(true);
        h.addParameters("--name-status", "-M", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(new ArrayList<String>(commitsIds));
        String output = h.run();
        ArrayList<GitHeavyCommit> rc = new ArrayList<GitHeavyCommit>();
        for (GitLogRecord record : parser.parse(output)) {
            GitHeavyCommit gitCommit = GitHistoryUtils.createCommit(project, refs, root, record);
            rc.add(gitCommit);
        }
        ArrayList<GitHeavyCommit> arrayList = rc;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/history/GitHistoryUtils", "commitsDetails"));
        }
        return arrayList;
    }

    public static long getAuthorTime(@NotNull Project project, @NotNull FilePath path, @NotNull String commitsId) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getAuthorTime"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/history/GitHistoryUtils", "getAuthorTime"));
        }
        if (commitsId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitsId", "git4idea/history/GitHistoryUtils", "getAuthorTime"));
        }
        path = GitHistoryUtils.getLastCommitName(project, path);
        VirtualFile root = GitUtil.getGitRoot(path);
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.SHOW);
        GitLogParser parser = new GitLogParser(project, GitLogParser.NameStatus.STATUS, GitLogParser.GitLogOption.AUTHOR_TIME);
        h.setSilent(true);
        h.addParameters("--name-status", parser.getPretty(), "--encoding=UTF-8");
        h.addParameters(commitsId);
        String output = h.run();
        GitLogRecord logRecord = parser.parseOneRecord(output);
        if (logRecord == null) {
            throw new VcsException("Can not parse log output \"" + output + "\"");
        }
        return logRecord.getAuthorTimeStamp();
    }

    public static FilePath getLastCommitName(@NotNull Project project, FilePath path) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getLastCommitName"));
        }
        if (project.isDefault()) {
            return path;
        }
        ChangeListManager changeManager = ChangeListManager.getInstance((Project)project);
        Change change = changeManager.getChange(path);
        if (change != null && change.getType() == Change.Type.MOVED) {
            assert (change.getBeforeRevision() != null) : "Move change always have beforeRevision";
            path = change.getBeforeRevision().getFile();
        }
        return path;
    }

    @Nullable
    public static GitRevisionNumber getMergeBase(@NotNull Project project, @NotNull VirtualFile root, @NotNull String first, @NotNull String second) throws VcsException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (first == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "first", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        if (second == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "second", "git4idea/history/GitHistoryUtils", "getMergeBase"));
        }
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.MERGE_BASE);
        h.setSilent(true);
        h.addParameters(first, second);
        String output = h.run().trim();
        if (output.length() == 0) {
            return null;
        }
        return GitRevisionNumber.resolve(project, root, output);
    }

    private static /* synthetic */ VcsCommitMetadata lambda$loadMetadata$9(@NotNull Project project, @NotNull VirtualFile root, VcsLogObjectsFactory factory, Set refs, GitLogRecord record) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/history/GitHistoryUtils", "lambda$loadMetadata$9"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/history/GitHistoryUtils", "lambda$loadMetadata$9"));
        }
        GitCommit commit = GitHistoryUtils.createCommit(project, root, record, factory);
        Collection<VcsRef> refsInRecord = GitHistoryUtils.parseRefs(record.getRefs(), commit.getId(), factory, root);
        for (VcsRef ref : refsInRecord) {
            if (refs.add(ref)) continue;
            VcsRef otherRef = (VcsRef)ContainerUtil.find((Iterable)refs, r -> GitLogProvider.DONT_CONSIDER_SHA.equals(r, (Object)ref));
            LOG.error("Adding duplicate element " + ref + " to the set containing " + otherRef);
        }
        return commit;
    }

    private static class MyTokenAccumulator {
        @NotNull
        private final StringBuilder myBuffer;
        @NotNull
        private final GitLogParser myParser;
        private boolean myNotStarted;

        public MyTokenAccumulator(@NotNull GitLogParser parser) {
            if (parser == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parser", "git4idea/history/GitHistoryUtils$MyTokenAccumulator", "<init>"));
            }
            this.myBuffer = new StringBuilder();
            this.myNotStarted = true;
            this.myParser = parser;
        }

        @Nullable
        public GitLogRecord acceptLine(String s) {
            boolean recordStart = s.startsWith("\u0001");
            if (recordStart) {
                s = s.substring("\u0001".length());
            }
            if (this.myNotStarted) {
                this.myBuffer.append(s);
                this.myBuffer.append("\n");
                this.myNotStarted = false;
                return null;
            }
            if (recordStart) {
                String line = this.myBuffer.toString();
                this.myBuffer.setLength(0);
                this.myBuffer.append(s);
                this.myBuffer.append("\n");
                return this.processResult(line);
            }
            this.myBuffer.append(s);
            this.myBuffer.append("\n");
            return null;
        }

        @Nullable
        public GitLogRecord processLast() {
            return this.processResult(this.myBuffer.toString());
        }

        @Nullable
        private GitLogRecord processResult(@NotNull String line) {
            if (line == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "git4idea/history/GitHistoryUtils$MyTokenAccumulator", "processResult"));
            }
            return this.myParser.parseOneRecord(line);
        }
    }
}

