/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.dialects.beans;

import com.intellij.thymeleaf.constants.ThymeleafNamespaceConstants;
import com.intellij.thymeleaf.dialects.ThymeleafAttributeProcessor;
import com.intellij.thymeleaf.dialects.ThymeleafDialect;
import com.intellij.thymeleaf.dialects.ThymeleafElementProcessor;
import com.intellij.thymeleaf.dialects.beans.ThymeleafDialectBean;
import com.intellij.thymeleaf.dialects.beans.ThymeleafExpressionObjectBean;
import com.intellij.thymeleaf.lang.ThymeleafLanguage;
import com.intellij.util.xmlb.XmlSerializer;
import java.net.URL;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractThymeleafDialect
implements ThymeleafDialect {
    private ThymeleafAttributeProcessor[] myAttributeProcessors;
    private ThymeleafElementProcessor[] myElementProcessors;
    private ThymeleafExpressionObjectBean[] myExpressionObjects;

    public AbstractThymeleafDialect(URL url) {
        ThymeleafDialectBean dialectBean = (ThymeleafDialectBean)XmlSerializer.deserialize((URL)url, ThymeleafDialectBean.class);
        if (dialectBean != null) {
            this.myAttributeProcessors = dialectBean.myAttributesProcessors;
            this.myElementProcessors = dialectBean.myElementProcessors;
            this.myExpressionObjects = dialectBean.myExpressionObjects;
        }
    }

    @Override
    @NotNull
    public ThymeleafAttributeProcessor[] getAttributeProcessors() {
        ThymeleafAttributeProcessor[] thymeleafAttributeProcessorArray = this.myAttributeProcessors != null ? this.myAttributeProcessors : new ThymeleafAttributeProcessor[]{};
        if (thymeleafAttributeProcessorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/dialects/beans/AbstractThymeleafDialect", "getAttributeProcessors"));
        }
        return thymeleafAttributeProcessorArray;
    }

    @Override
    @NotNull
    public ThymeleafElementProcessor[] getElementProcessors() {
        ThymeleafElementProcessor[] thymeleafElementProcessorArray = this.myElementProcessors != null ? this.myElementProcessors : new ThymeleafElementProcessor[]{};
        if (thymeleafElementProcessorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/dialects/beans/AbstractThymeleafDialect", "getElementProcessors"));
        }
        return thymeleafElementProcessorArray;
    }

    public ThymeleafExpressionObjectBean[] getExpressionObjects() {
        return this.myExpressionObjects != null ? this.myExpressionObjects : new ThymeleafExpressionObjectBean[]{};
    }

    @Override
    public String[] getNamespaces() {
        return ThymeleafNamespaceConstants.THYMELEAF_URIS;
    }

    @Override
    public ThymeleafLanguage getLanguage() {
        return ThymeleafLanguage.EXPRESSIONS;
    }
}

