/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.thymeleaf.providers.contexts;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.model.utils.PsiTypeUtil;
import com.intellij.thymeleaf.lang.psi.ThymesElExpression;
import com.intellij.thymeleaf.lang.psi.ThymesIterableVariable;
import com.intellij.thymeleaf.lang.psi.ThymesIterateExpression;
import com.intellij.thymeleaf.lang.psi.ThymesStatusVariable;
import com.intellij.thymeleaf.lang.support.ThymeleafContextVariablesProvider;
import com.intellij.thymeleaf.lang.support.ThymeleafElementProcessor;
import com.intellij.thymeleaf.lang.support.beans.ThymeleafVariable;
import com.intellij.thymeleaf.lang.support.utils.ThymeleafCommonUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThymeleafIterateVariablesProvider
extends ThymeleafContextVariablesProvider {
    private static Map<String, PsiType> map = ContainerUtil.newHashMap();

    @Override
    @NotNull
    public Collection<? extends PsiVariable> getContextVariables(@NotNull PsiElement contextElement) {
        if (contextElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contextElement", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "getContextVariables"));
        }
        HashSet variables = new HashSet();
        for (ThymesElExpression expression : ThymeleafCommonUtil.findEachExpressions(contextElement)) {
            if (!(expression instanceof ThymesIterateExpression)) continue;
            ThymesIterateExpression iterateExpression = (ThymesIterateExpression)expression;
            PsiType itType = ThymeleafIterateVariablesProvider.getIterateExpressionType(iterateExpression);
            List<ThymesElExpression> list = iterateExpression.getIterateVariables().getElExpressionList();
            for (ThymesElExpression variable : list) {
                String name;
                if (variable instanceof ThymesStatusVariable) {
                    name = variable.getText();
                    variables.add(ThymeleafIterateVariablesProvider.createStatVariable(name, variable, itType));
                    continue;
                }
                if (!(variable instanceof ThymesIterableVariable)) continue;
                name = variable.getText();
                if (itType != null) {
                    variables.add((ThymesIterableVariable)variable);
                }
                if (list.size() != 1) continue;
                variables.add(ThymeleafIterateVariablesProvider.createStatVariable(name + "Stat", variable, itType));
            }
        }
        HashSet hashSet = variables;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "getContextVariables"));
        }
        return hashSet;
    }

    @Nullable
    public static PsiType getIterateExpressionType(@NotNull ThymesIterateExpression iterateExpression) {
        if (iterateExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterateExpression", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "getIterateExpressionType"));
        }
        return (PsiType)RecursionManager.doPreventingRecursion((Object)iterateExpression, (boolean)true, () -> {
            if (iterateExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "iterateExpression", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "lambda$getIterateExpressionType$0"));
            }
            ThymesElExpression iteratedExpression = iterateExpression.getElExpression();
            PsiType type = iteratedExpression.getType();
            if (type instanceof PsiClassType) {
                PsiType typeParameter = null;
                PsiClassType classType = (PsiClassType)type;
                Project project = iteratedExpression.getProject();
                if (ThymeleafIterateVariablesProvider.isAssignable(classType, Iterable.class, project)) {
                    typeParameter = PsiUtil.substituteTypeParameter((PsiType)type, (String)"java.lang.Iterable", (int)0, (boolean)false);
                } else if (ThymeleafIterateVariablesProvider.isAssignable(classType, Map.class, project)) {
                    typeParameter = ThymeleafIterateVariablesProvider.getMapEntryType(classType, project);
                }
                return typeParameter != null ? typeParameter : PsiType.getJavaLangObject((PsiManager)iteratedExpression.getManager(), (GlobalSearchScope)GlobalSearchScope.allScope((Project)iterateExpression.getProject()));
            }
            if (type instanceof PsiArrayType) {
                return ((PsiArrayType)type).getComponentType();
            }
            return null;
        });
    }

    @Nullable
    private static PsiType getMapEntryType(@NotNull PsiClassType mapType, @NotNull Project project) {
        if (mapType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapType", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "getMapEntryType"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "getMapEntryType"));
        }
        PsiClass entryClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.Map.Entry", GlobalSearchScope.allScope((Project)project));
        if (entryClass != null) {
            PsiType keyType = PsiUtil.substituteTypeParameter((PsiType)mapType, (String)"java.util.Map", (int)0, (boolean)false);
            PsiType valueType = PsiUtil.substituteTypeParameter((PsiType)mapType, (String)"java.util.Map", (int)1, (boolean)false);
            if (keyType != null && valueType != null) {
                return JavaPsiFacade.getElementFactory((Project)project).createType(entryClass, new PsiType[]{keyType, valueType});
            }
        }
        return null;
    }

    private static boolean isAssignable(@NotNull PsiClassType type, @NotNull Class clazz, @NotNull Project project) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "isAssignable"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "isAssignable"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "isAssignable"));
        }
        PsiType iterableType = PsiTypeUtil.getInstance((Project)project).findType(clazz);
        return iterableType != null && iterableType.isAssignableFrom((PsiType)type);
    }

    @NotNull
    private static ThymeleafVariable createStatVariable(@NotNull String s, @NotNull ThymesElExpression variable, @Nullable PsiType itType) {
        if (s == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "s", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "createStatVariable"));
        }
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "createStatVariable"));
        }
        ThymeleafStatusVariable thymeleafStatusVariable = new ThymeleafStatusVariable(s, variable, itType);
        if (thymeleafStatusVariable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "createStatVariable"));
        }
        return thymeleafStatusVariable;
    }

    public static boolean processStatusVariableDeclarations(ThymeleafElementProcessor processor, @Nullable PsiType itType, @NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider", "processStatusVariableDeclarations"));
        }
        for (Map.Entry<String, PsiType> entry : map.entrySet()) {
            if (processor.processVariable((PsiVariable)new ThymeleafVariable(entry.getKey(), entry.getValue(), element), PsiSubstitutor.EMPTY)) continue;
            return false;
        }
        return itType == null || processor.processVariable((PsiVariable)new ThymeleafVariable("current", itType, element), PsiSubstitutor.EMPTY);
    }

    static {
        map.put("index", (PsiType)PsiType.INT);
        map.put("count", (PsiType)PsiType.INT);
        map.put("size", (PsiType)PsiType.INT);
        map.put("even", (PsiType)PsiType.BOOLEAN);
        map.put("odd", (PsiType)PsiType.BOOLEAN);
        map.put("first", (PsiType)PsiType.BOOLEAN);
        map.put("last", (PsiType)PsiType.BOOLEAN);
    }

    private static class ThymeleafStatusVariable
    extends ThymeleafVariable {
        @Nullable
        private final PsiType myItType;

        public ThymeleafStatusVariable(String s, ThymesElExpression navigationElement, @Nullable PsiType itType) {
            super(s, (PsiType)PsiType.VOID, navigationElement);
            this.myItType = itType;
        }

        @Override
        public boolean processDeclarations(@NotNull ThymeleafElementProcessor processor) {
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/thymeleaf/providers/contexts/ThymeleafIterateVariablesProvider$ThymeleafStatusVariable", "processDeclarations"));
            }
            return ThymeleafIterateVariablesProvider.processStatusVariableDeclarations(processor, this.myItType, this.getNavigationElement());
        }
    }
}

