/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.model.common;

import com.intellij.jsf.model.common.JsfCommonConverter;
import com.intellij.jsf.model.common.JsfConvertersDiscoverer;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.HashSet;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JsfPredefinedConvertersDiscoverer
implements JsfConvertersDiscoverer {
    private static Set<Trinity<String, String, String>> set = new HashSet();
    private static final Key<CachedValue<Set<JsfCommonConverter>>> CONVERTERS_VARS = Key.create((String)"jsf predefined converters");

    @Override
    public void addJsfConverters(@NotNull Module module, @NotNull Set<JsfCommonConverter> converters) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "addJsfConverters"));
        }
        if (converters == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converters", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "addJsfConverters"));
        }
        CachedValue cachedVars = (CachedValue)module.getUserData(CONVERTERS_VARS);
        if (cachedVars == null) {
            cachedVars = CachedValuesManager.getManager((Project)module.getProject()).createCachedValue(() -> {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "lambda$addJsfConverters$0"));
                }
                HashSet converterSet = new HashSet();
                for (Trinity<String, String, String> entry : set) {
                    converterSet.add(JsfPredefinedConvertersDiscoverer.createConverter((String)entry.first, (String)entry.second, (String)entry.third, module));
                }
                return CachedValueProvider.Result.create((Object)converterSet, (Object[])new Object[]{ProjectRootManager.getInstance((Project)module.getProject()), PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
            }, false);
            module.putUserData(CONVERTERS_VARS, (Object)cachedVars);
        }
        converters.addAll((Collection)cachedVars.getValue());
    }

    @NotNull
    private static JsfCommonConverter createConverter(final @NotNull String converterId, @NotNull String converterClass, @NotNull String converterForClass, @NotNull Module module) {
        if (converterId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converterId", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "createConverter"));
        }
        if (converterClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converterClass", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "createConverter"));
        }
        if (converterForClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converterForClass", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "createConverter"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "createConverter"));
        }
        final JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)module.getProject());
        final PsiClass converterPsiClass = facade.findClass(converterClass, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
        final PsiClass converterForPsiClass = facade.findClass(converterForClass, GlobalSearchScope.moduleWithLibrariesScope((Module)module));
        JsfCommonConverter jsfCommonConverter = new JsfCommonConverter(){

            @Override
            public String getConverterId() {
                return converterId;
            }

            @Override
            public PsiType getForClass() {
                return converterForPsiClass == null ? null : facade.getElementFactory().createType(converterForPsiClass);
            }

            @Override
            public PsiElement getIdentifyingElement() {
                return converterPsiClass;
            }
        };
        if (jsfCommonConverter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/model/common/JsfPredefinedConvertersDiscoverer", "createConverter"));
        }
        return jsfCommonConverter;
    }

    static {
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.BigDecimal", (Object)"javax.faces.convert.BigDecimalConverter", (Object)BigDecimal.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.BigInteger", (Object)"javax.faces.convert.BigIntegerConverter", (Object)BigInteger.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Boolean", (Object)"javax.faces.convert.BooleanConverter", (Object)Boolean.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Byte", (Object)"javax.faces.convert.ByteConverter", (Object)Byte.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Character", (Object)"javax.faces.convert.CharacterConverter", (Object)Character.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.DateTime", (Object)"javax.faces.convert.DateTimeConverter", (Object)""));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Double", (Object)"javax.faces.convert.DoubleConverter", (Object)Double.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Enum", (Object)"javax.faces.convert.EnumConverter", (Object)Enum.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Float", (Object)"javax.faces.convert.FloatConverter", (Object)Float.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Integer", (Object)"javax.faces.convert.IntegerConverter", (Object)Integer.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Long", (Object)"javax.faces.convert.LongConverter", (Object)Long.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Number", (Object)"javax.faces.convert.NumberConverter", (Object)Number.class.getName()));
        set.add((Trinity<String, String, String>)Trinity.create((Object)"javax.faces.Short", (Object)"javax.faces.convert.ShortConverter", (Object)Short.class.getName()));
    }
}

