/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsf.toolWindow.tree.nodes;

import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.jsf.model.jam.JsfJamModel;
import com.intellij.jsf.model.jam.JsfJamValidator;
import com.intellij.jsf.model.xml.FacesDomModel;
import com.intellij.jsf.model.xml.validator.Validator;
import com.intellij.jsf.resources.FacesUIBundle;
import com.intellij.jsf.toolWindow.tree.nodes.AbstractJsfTypeNode;
import com.intellij.jsf.toolWindow.tree.nodes.AnnotatedMembersNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfDomModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModelElementNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfModuleNode;
import com.intellij.jsf.toolWindow.tree.nodes.JsfNodeTypes;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.ui.treeStructure.SimpleNode;
import icons.JsfIcons;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class ValidatorsNode
extends AbstractJsfTypeNode {
    public ValidatorsNode(Module module, JsfModuleNode jsfModuleNode, boolean showFromLibraries) {
        super(jsfModuleNode, module, JsfNodeTypes.VALIDATOR, showFromLibraries);
        this.setUniformIcon(JsfIcons.Validator);
    }

    protected void doUpdate() {
        this.setPlainText(FacesUIBundle.message("validators.node.name", new Object[0]));
    }

    @Override
    protected void addAnnotatedNodes(Collection<JsfModelElementNode> nodes) {
        List<JsfJamValidator> jamElements = JsfJamModel.getModel(this.getModule()).getValidators(this.isShowFromLibraries());
        for (JsfJamValidator validator : jamElements) {
            nodes.add(new AnnotatedMembersNode<PsiClass>(this.getModule(), validator.getPsiElement(), this));
        }
    }

    @Override
    @NotNull
    protected Collection<SimpleNode> getFacesDomModelNodes(@NotNull FacesDomModel domModel) {
        if (domModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domModel", "com/intellij/jsf/toolWindow/tree/nodes/ValidatorsNode", "getFacesDomModelNodes"));
        }
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        List<Validator> validators = domModel.getFacesConfig().getValidators();
        for (final Validator validator : validators) {
            nodes.add(new JsfDomModelElementNode<Validator>(this.getProject(), (NodeDescriptor)this, validator, JsfIcons.Validator){

                @Override
                protected String getActualNodeName() {
                    return validator.getValidatorId().getStringValue();
                }

                @Override
                protected String getNodeTextExt() {
                    return validator.getValidatorClass().getStringValue();
                }
            });
        }
        ArrayList<SimpleNode> arrayList = nodes;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/jsf/toolWindow/tree/nodes/ValidatorsNode", "getFacesDomModelNodes"));
        }
        return arrayList;
    }
}

