/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.history.LocalHistoryAction;
import com.intellij.ide.impl.ProjectUtil;
import com.intellij.ide.util.DelegatingProgressIndicator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbModePermission;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.ui.GuiUtils;
import com.jetbrains.plugins.webDeployment.AutoUploadComponent;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentMode;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.DeploymentRevisionTracker;
import com.jetbrains.plugins.webDeployment.DistinctRootsCollections;
import com.jetbrains.plugins.webDeployment.ExecutionContextBase;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.ServerTreeContentListener;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.WebDeploymentTopics;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnection;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import com.jetbrains.plugins.webDeployment.ui.DeploymentNotifier;
import com.jetbrains.plugins.webDeployment.ui.FileTransferToolWindow;
import com.jetbrains.plugins.webDeployment.ui.auth.AuthHelper;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeoutException;
import javax.swing.Icon;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RemoteHostTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance((String)RemoteHostTask.class.getName());
    private final DistinctRootsCollections.SystemIndependentPaths myAffectedLocalRoots;
    private final DistinctRootsCollections.RemotePaths myAffectedRemoteRoots;
    private Pair<WebServerConfig.RemotePath, Object> myToSelect;
    protected final ConnectionOwner myConnectionOwner;
    private final Deployable myServerConfig;
    private final PublishConfig myPublishConfig;
    protected final DeploymentMode myDeploymentMode;
    private volatile boolean myProjectCloseRequested;
    private volatile boolean myFinished;
    protected LocalHistoryAction myLocalHistoryAction;
    protected final DeploymentRevisionTracker myRevisionTracker;

    protected RemoteHostTask(@Nullable Project project, @NotNull ConnectionOwner connectionOwner, @NotNull Deployable serverConfig, @NotNull PublishConfig publishConfig, @NotNull String title, final boolean background, @NotNull DeploymentRevisionTracker revisionTracker, @NotNull DeploymentMode mode) {
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "<init>"));
        }
        if (serverConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverConfig", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "<init>"));
        }
        if (publishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "publishConfig", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "<init>"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "<init>"));
        }
        if (revisionTracker == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revisionTracker", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "<init>"));
        }
        if (mode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "<init>"));
        }
        super(project, title, true, new PerformInBackgroundOption(){

            public void processSentToBackground() {
            }

            public boolean shouldStartInBackground() {
                return background;
            }
        });
        this.myConnectionOwner = connectionOwner;
        this.myServerConfig = serverConfig;
        this.myPublishConfig = publishConfig;
        this.myAffectedLocalRoots = new DistinctRootsCollections.SystemIndependentPaths(SystemInfo.isFileSystemCaseSensitive);
        boolean isCaseSensitive = this.myServerConfig.getAccessType().isProtocolBased() ? this.myServerConfig.isCaseSensitive() : SystemInfo.isFileSystemCaseSensitive;
        this.myAffectedRemoteRoots = new DistinctRootsCollections.RemotePaths(isCaseSensitive);
        this.myRevisionTracker = revisionTracker;
        this.myDeploymentMode = mode;
    }

    public boolean isConditionalModal() {
        return true;
    }

    public void run(@NotNull ProgressIndicator pi) {
        if (pi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "run"));
        }
        this.doRun(pi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final boolean doRun(@NotNull ProgressIndicator pi) {
        boolean bl;
        RemoteConnection connection;
        block40: {
            String error;
            if (pi == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pi", "com/jetbrains/plugins/webDeployment/RemoteHostTask", "doRun"));
            }
            LOG.assertTrue(!this.myFinished);
            Object pi_ = !this.canChangeProgressText() ? new DelegatingProgressIndicator(){

                public void setText(String text) {
                }
            } : pi;
            pi.setText(WDBundle.message("validating.server", new Object[0]));
            try {
                error = this.myServerConfig.validateInternalSlow(-1L);
            }
            catch (TimeoutException e) {
                LOG.error((Throwable)e);
                error = null;
            }
            if (error != null) {
                String message = WDBundle.message("operation.failed", this.getTitle(), StringUtil.decapitalize((String)error));
                this.print(message, ConsoleViewContentType.ERROR_OUTPUT);
                this.showBalloon(MessageType.ERROR, message, true);
                return false;
            }
            String operationCancelledMessage = WDBundle.message("operation.cancelled", this.getTitle());
            if (!AuthHelper.ensureAuthSpecified(this.myProject, this.myServerConfig, this.myConnectionOwner)) {
                this.print(operationCancelledMessage, ConsoleViewContentType.ERROR_OUTPUT);
                return false;
            }
            pi.setText(WDBundle.message("logging.in", new Object[0]));
            if (this.getExistingConnection() != null) {
                connection = this.getExistingConnection().clone();
            } else {
                try {
                    connection = RemoteConnectionManager.getInstance().openConnection(this.myConnectionOwner, this.myTitle, this.myServerConfig, FileTransferConfig.Origin.Default, null, (ProgressIndicator)pi_);
                }
                catch (FileSystemException e) {
                    LOG.warn((Throwable)e);
                    this.print(WDBundle.message("operation.failed", this.getTitle(), StringUtil.decapitalize((String)PublishUtils.getMessage(e, true))), ConsoleViewContentType.ERROR_OUTPUT);
                    this.showBalloon(MessageType.ERROR, WDBundle.message("operation.failed", this.getTitle(), StringUtil.decapitalize((String)PublishUtils.getMessage(e, false))), true);
                    if (PublishUtils.isAuthFail(e)) {
                        this.myServerConfig.clearPasswordIfNotStored();
                    }
                    return false;
                }
            }
            pi.setText(WDBundle.message("running", new Object[0]));
            ProjectManagerAdapter listener = null;
            try {
                if (this.myProject != null) {
                    listener = new ProjectManagerAdapter((ProgressIndicator)pi_){
                        final /* synthetic */ ProgressIndicator val$pi_;
                        {
                            this.val$pi_ = progressIndicator;
                        }

                        public boolean canCloseProject(Project project) {
                            String title = WDBundle.message("warning.running.dialog.title", RemoteHostTask.this.getTitle());
                            String text = WDBundle.message("warning.running.on.project.close", RemoteHostTask.this.getTitle());
                            int result = Messages.showOkCancelDialog((Project)RemoteHostTask.this.myProject, (String)text, (String)title, (Icon)Messages.getQuestionIcon());
                            if (result != 0) {
                                return false;
                            }
                            RemoteHostTask.this.myProjectCloseRequested = true;
                            this.val$pi_.cancel();
                            return RemoteHostTask.this.myFinished;
                        }
                    };
                    ProjectManager.getInstance().addProjectManagerListener(this.myProject, (ProjectManagerListener)listener);
                }
                final ExecutionContextBase context = new ExecutionContextBase((ProgressIndicator)pi_, connection){
                    final /* synthetic */ ProgressIndicator val$pi_;
                    final /* synthetic */ RemoteConnection val$connection;
                    {
                        this.val$pi_ = progressIndicator;
                        this.val$connection = remoteConnection;
                    }

                    @Override
                    public void addAffectedRoot(FileName fileName, boolean remote) {
                        if (remote) {
                            RemoteHostTask.this.myAffectedRemoteRoots.add(RemoteHostTask.this.myServerConfig.getRemotePath(fileName));
                        } else {
                            RemoteHostTask.this.myAffectedLocalRoots.add(DeploymentPathUtils.getLocalPath(fileName));
                        }
                    }

                    @Override
                    public ProgressIndicator getProgressIndicator() {
                        return this.val$pi_;
                    }

                    @Override
                    public FileObject findRemoteFile(WebServerConfig.RemotePath path, boolean refreshUpRecursively) throws FileSystemException {
                        FileObject file = PublishUtils.findFile(this.val$connection.getFileSystem(), path, RemoteHostTask.this.myServerConfig);
                        if (refreshUpRecursively) {
                            DeploymentPathUtils.refreshRemoteFile(file, this);
                        } else {
                            file.refresh();
                        }
                        return file;
                    }

                    @Override
                    public Deployable getServer() {
                        return RemoteHostTask.this.myServerConfig;
                    }

                    @Override
                    public void scheduleForSelection(WebServerConfig.RemotePath remotePath, Object requestor) {
                        RemoteHostTask.this.myToSelect = Pair.create((Object)remotePath, (Object)requestor);
                    }

                    @Override
                    public DeploymentMode getDeploymentMode() {
                        return RemoteHostTask.this.myDeploymentMode;
                    }
                };
                bl = connection.executeServerOperation(new Computable<Boolean>(){

                    public Boolean compute() {
                        return RemoteHostTask.this.executeOperations(context, connection);
                    }
                }, (ProgressIndicator)pi_);
                this.myFinished = true;
                if (listener == null) break block40;
            }
            catch (ProcessCanceledException e) {
                boolean bl2;
                block41: {
                    try {
                        LOG.debug("cancelled");
                        this.print(operationCancelledMessage, ConsoleViewContentType.ERROR_OUTPUT);
                        bl2 = false;
                        this.myFinished = true;
                        if (listener == null) break block41;
                    }
                    catch (Throwable throwable) {
                        this.myFinished = true;
                        if (listener != null) {
                            ProjectManager.getInstance().removeProjectManagerListener(this.myProject, listener);
                        }
                        connection.release();
                        if (this.myProjectCloseRequested) {
                            ApplicationManager.getApplication().invokeLater(() -> ProjectUtil.closeAndDispose((Project)this.myProject));
                        } else {
                            if (!this.myAffectedLocalRoots.isEmpty()) {
                                pi.setText(WDBundle.message("refreshing.local.files", new Object[0]));
                                pi.setIndeterminate(true);
                                ArrayList files = new ArrayList(this.myAffectedLocalRoots.size());
                                try {
                                    GuiUtils.runOrInvokeAndWait(() -> DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, () -> AutoUploadComponent.executeWriteActionSilently(this.myProject, () -> {
                                        Iterator iterator = this.myAffectedLocalRoots.iterator();
                                        while (iterator.hasNext()) {
                                            String root = (String)iterator.next();
                                            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                                            if (file == null || !file.isValid()) continue;
                                            files.add(file);
                                        }
                                    })));
                                }
                                catch (InvocationTargetException e2) {
                                    LOG.warn((Throwable)e2);
                                }
                                catch (InterruptedException e3) {
                                    LOG.warn((Throwable)e3);
                                }
                                AutoUploadComponent uploader = this.myProject == null || this.myProject.isDefault() ? null : AutoUploadComponent.getInstance(this.myProject);
                                RefreshSession session = RefreshQueue.getInstance().createSession(false, true, () -> {
                                    if (this.myLocalHistoryAction != null) {
                                        this.myLocalHistoryAction.finish();
                                    }
                                    if (uploader != null) {
                                        uploader.setMuted(false);
                                    }
                                });
                                session.addAllFiles(files);
                                if (uploader != null) {
                                    uploader.setMuted(true);
                                }
                                session.launch();
                            }
                            if (!this.myAffectedRemoteRoots.isEmpty()) {
                                pi.setText(WDBundle.message("refreshing.remote.files", new Object[0]));
                                pi.setIndeterminate(true);
                                ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(this.myServerConfig, (Collection<WebServerConfig.RemotePath>)((Object)this.myAffectedRemoteRoots), false, true, this.myToSelect != null ? (WebServerConfig.RemotePath)this.myToSelect.first : null, this.myToSelect != null ? this.myToSelect.second : null);
                            }
                        }
                        throw throwable;
                    }
                    ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)listener);
                }
                connection.release();
                if (this.myProjectCloseRequested) {
                    ApplicationManager.getApplication().invokeLater(() -> ProjectUtil.closeAndDispose((Project)this.myProject));
                } else {
                    if (!this.myAffectedLocalRoots.isEmpty()) {
                        pi.setText(WDBundle.message("refreshing.local.files", new Object[0]));
                        pi.setIndeterminate(true);
                        ArrayList files = new ArrayList(this.myAffectedLocalRoots.size());
                        try {
                            GuiUtils.runOrInvokeAndWait(() -> DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, () -> AutoUploadComponent.executeWriteActionSilently(this.myProject, () -> {
                                Iterator iterator = this.myAffectedLocalRoots.iterator();
                                while (iterator.hasNext()) {
                                    String root = (String)iterator.next();
                                    VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                                    if (file == null || !file.isValid()) continue;
                                    files.add(file);
                                }
                            })));
                        }
                        catch (InvocationTargetException e4) {
                            LOG.warn((Throwable)e4);
                        }
                        catch (InterruptedException e5) {
                            LOG.warn((Throwable)e5);
                        }
                        AutoUploadComponent uploader = this.myProject == null || this.myProject.isDefault() ? null : AutoUploadComponent.getInstance(this.myProject);
                        RefreshSession session = RefreshQueue.getInstance().createSession(false, true, () -> {
                            if (this.myLocalHistoryAction != null) {
                                this.myLocalHistoryAction.finish();
                            }
                            if (uploader != null) {
                                uploader.setMuted(false);
                            }
                        });
                        session.addAllFiles(files);
                        if (uploader != null) {
                            uploader.setMuted(true);
                        }
                        session.launch();
                    }
                    if (!this.myAffectedRemoteRoots.isEmpty()) {
                        pi.setText(WDBundle.message("refreshing.remote.files", new Object[0]));
                        pi.setIndeterminate(true);
                        ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(this.myServerConfig, (Collection<WebServerConfig.RemotePath>)((Object)this.myAffectedRemoteRoots), false, true, this.myToSelect != null ? (WebServerConfig.RemotePath)this.myToSelect.first : null, this.myToSelect != null ? this.myToSelect.second : null);
                    }
                }
                return bl2;
            }
            ProjectManager.getInstance().removeProjectManagerListener(this.myProject, (ProjectManagerListener)listener);
        }
        connection.release();
        if (this.myProjectCloseRequested) {
            ApplicationManager.getApplication().invokeLater(() -> ProjectUtil.closeAndDispose((Project)this.myProject));
        } else {
            if (!this.myAffectedLocalRoots.isEmpty()) {
                pi.setText(WDBundle.message("refreshing.local.files", new Object[0]));
                pi.setIndeterminate(true);
                ArrayList files = new ArrayList(this.myAffectedLocalRoots.size());
                try {
                    GuiUtils.runOrInvokeAndWait(() -> DumbService.allowStartingDumbModeInside((DumbModePermission)DumbModePermission.MAY_START_BACKGROUND, () -> AutoUploadComponent.executeWriteActionSilently(this.myProject, () -> {
                        Iterator iterator = this.myAffectedLocalRoots.iterator();
                        while (iterator.hasNext()) {
                            String root = (String)iterator.next();
                            VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(root);
                            if (file == null || !file.isValid()) continue;
                            files.add(file);
                        }
                    })));
                }
                catch (InvocationTargetException e) {
                    LOG.warn((Throwable)e);
                }
                catch (InterruptedException e) {
                    LOG.warn((Throwable)e);
                }
                AutoUploadComponent uploader = this.myProject == null || this.myProject.isDefault() ? null : AutoUploadComponent.getInstance(this.myProject);
                RefreshSession session = RefreshQueue.getInstance().createSession(false, true, () -> {
                    if (this.myLocalHistoryAction != null) {
                        this.myLocalHistoryAction.finish();
                    }
                    if (uploader != null) {
                        uploader.setMuted(false);
                    }
                });
                session.addAllFiles(files);
                if (uploader != null) {
                    uploader.setMuted(true);
                }
                session.launch();
            }
            if (!this.myAffectedRemoteRoots.isEmpty()) {
                pi.setText(WDBundle.message("refreshing.remote.files", new Object[0]));
                pi.setIndeterminate(true);
                ((ServerTreeContentListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(WebDeploymentTopics.SERVER_TREE)).refreshSubtree(this.myServerConfig, (Collection<WebServerConfig.RemotePath>)((Object)this.myAffectedRemoteRoots), false, true, this.myToSelect != null ? (WebServerConfig.RemotePath)this.myToSelect.first : null, this.myToSelect != null ? this.myToSelect.second : null);
            }
        }
        return bl;
    }

    @Nullable
    protected RemoteConnection getExistingConnection() {
        return null;
    }

    protected boolean canChangeProgressText() {
        return true;
    }

    protected abstract boolean executeOperations(ExecutionContextBase var1, RemoteConnection var2);

    protected void print(String text, ConsoleViewContentType contentType) {
        FileTransferToolWindow.printWithTimestamp(this.myProject, this.myServerConfig, text, contentType, this.myPublishConfig.getTraceLevel());
    }

    protected DeploymentNotifier.ToolWindowIdProvider getBalloonAnchor() {
        return FileTransferToolWindow.ID_PROVIDER;
    }

    protected void showBalloon(MessageType type, String text, boolean isSummary) {
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.myProject == null || this.myProject.isDisposed()) {
                return;
            }
            DeploymentNotifier.notifyWithBalloon(null, text, type.toNotificationType(), null, this.myProject, this.getBalloonAnchor());
        });
    }

    public static String getItemsMessage(int number) {
        return WDBundle.message("items", number, number == 1 ? 1 : 2);
    }
}

