/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.config;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SystemProperties;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import com.jcraft.jsch.JSch;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.DeploymentPathUtils;
import com.jetbrains.plugins.webDeployment.PublishUtils;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.FileTransferConfig;
import com.jetbrains.plugins.webDeployment.config.LoggingSftpChannel;
import com.jetbrains.plugins.webDeployment.config.Mappable;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.SftpUserInfo;
import com.jetbrains.plugins.webDeployment.config.WebDeploymentCredentialHelper;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.connections.RemoteConnectionManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;
import javax.swing.Icon;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPFileEntryParser;
import org.apache.commons.net.ftp.parser.DefaultFTPFileEntryParserFactory;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.provider.ftp.FtpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;
import org.apache.commons.vfs2.provider.ftps.FtpsDataChannelProtectionLevel;
import org.apache.commons.vfs2.provider.ftps.FtpsFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.ftps.FtpsMode;
import org.apache.commons.vfs2.provider.ftps.ServerSocketFactoryWrapper;
import org.apache.commons.vfs2.provider.ftps.SocketFactoryWrapper;
import org.apache.commons.vfs2.provider.sftp.IdentityInfo;
import org.apache.commons.vfs2.provider.sftp.SftpFileSystemConfigBuilder;
import org.apache.commons.vfs2.provider.webdav.WebdavFileSystemConfigBuilder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="webServer")
public class WebServerConfig
implements Cloneable,
Mappable {
    private static final int FTP_TIMEOUT = Integer.getInteger("com.jetbrains.plugins.webDeployment.ftp.timeout", 30000);
    private static final int FTP_DATA_TIMEOUT = Integer.getInteger("com.jetbrains.plugins.webDeployment.ftp.data_timeout", FTP_TIMEOUT);
    private static final int SFTP_TIMEOUT = Integer.getInteger("com.jetbrains.plugins.webDeployment.sftp.timeout", 30000);
    private static final int FTPS_DATA_TIMEOUT = Integer.getInteger("com.jetbrains.plugins.webDeployment.ftps.data_timeout", 30000);
    private static final Logger LOG = Logger.getInstance((String)WebServerConfig.class.getName());
    private static final Logger FTP_LOG = Logger.getInstance((String)"com.jetbrains.plugins.webDeployment.ftp");
    private static final Logger FTPS_LOG = Logger.getInstance((String)"com.jetbrains.plugins.webDeployment.ftps");
    public static final String DEFAULT_URL = "http://";
    private String myId;
    private String myName;
    private String myUrl = "http://";
    private boolean isProjectLevel = false;
    @NotNull
    private FileTransferConfig myFileTransferConfig = new FileTransferConfig();

    public WebServerConfig() {
        this(null);
    }

    public WebServerConfig(String id) {
        this.setId(id);
    }

    public void initializeNewCreatedServer(boolean globalServersOnly) {
        this.myFileTransferConfig.getAdvancedOptions().setDataChannelProtectionLevel(AdvancedOptionsConfig.DataChannelProtectionLevel.Private);
        this.setIsProjectLevel(!globalServersOnly);
    }

    @Override
    @Attribute(value="id")
    public String getId() {
        return this.myId;
    }

    public void setId(String id) {
        this.myId = id;
    }

    @Override
    @Attribute(value="name")
    public String getName() {
        return this.myName;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        Icon icon = this.getAccessType().getIcon();
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getIcon"));
        }
        return icon;
    }

    public void setName(String name) {
        this.myName = name;
    }

    @Override
    @Attribute(value="url")
    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(String url) {
        this.myUrl = url;
    }

    @Transient
    public boolean isProjectLevel() {
        return this.isProjectLevel;
    }

    public void setIsProjectLevel(boolean isProjectLevel) {
        this.isProjectLevel = isProjectLevel;
    }

    @Property(surroundWithTag=false)
    @NotNull
    public FileTransferConfig getFileTransferConfig() {
        FileTransferConfig fileTransferConfig = this.myFileTransferConfig;
        if (fileTransferConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getFileTransferConfig"));
        }
        return fileTransferConfig;
    }

    public void setFileTransferConfig(@NotNull FileTransferConfig fileTransferConfig) {
        if (fileTransferConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileTransferConfig", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "setFileTransferConfig"));
        }
        this.myFileTransferConfig = fileTransferConfig;
    }

    @NotNull
    public WebServerConfig clone() {
        WebServerConfig webServerConfig;
        try {
            WebServerConfig clone = (WebServerConfig)super.clone();
            clone.setFileTransferConfig(this.myFileTransferConfig.clone());
            webServerConfig = clone;
        }
        catch (CloneNotSupportedException e) {
            if (null == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "clone"));
            }
            return null;
        }
        if (webServerConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "clone"));
        }
        return webServerConfig;
    }

    @NotNull
    public WebServerConfig cloneWithNewIdAndCredentials() {
        WebServerConfig clone = this.clone();
        clone.setId(WebServerConfig.getNextId());
        WebDeploymentCredentialHelper.copyServerCredentials(this, clone);
        WebServerConfig webServerConfig = clone;
        if (webServerConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "cloneWithNewIdAndCredentials"));
        }
        return webServerConfig;
    }

    public boolean isBasedOnServer(WebServerConfig server) {
        return this.getId() != null && this.getId().equals(server.getId());
    }

    public String validateInternalSlow(long timeout) throws TimeoutException {
        return this.myFileTransferConfig.validateSlow(timeout);
    }

    public int getMaxConnections() {
        return this.getFileTransferConfig().getAdvancedOptions().getMaxConnections();
    }

    public AdvancedOptionsConfig.AccurateTimestamps getAccurateTimestamps() {
        return this.getFileTransferConfig().getAdvancedOptions().getAccurateTimestamps();
    }

    @Nullable
    public String validateSlow(long timeout) throws TimeoutException {
        String error = this.myFileTransferConfig.validateSlow(timeout);
        if (error != null) {
            return error;
        }
        return this.validateUrl();
    }

    @Nullable
    public String validateFast() {
        String error = this.validateFastInternal();
        return error == null ? this.validateUrl() : error;
    }

    @Nullable
    public String validateFastInternal() {
        return this.myFileTransferConfig.validateFast();
    }

    public String validateFastInternal(boolean checkRootFolder) {
        return this.myFileTransferConfig.validateFast(checkRootFolder);
    }

    public String validateInternalSlow(long infinite, boolean checkRootFolder) throws TimeoutException {
        return this.myFileTransferConfig.validateSlow(infinite, checkRootFolder);
    }

    @NotNull
    public FileSystemOptions getConnectionOptions(@NotNull ConnectionOwner connectionOwner, @NotNull String title, FileTransferConfig.Origin originOption, @Nullable EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger, @Nullable ProgressIndicator pi) {
        FileSystemOptions options;
        block23: {
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getConnectionOptions"));
            }
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getConnectionOptions"));
            }
            FileTransferConfig ftc = this.getFileTransferConfig();
            options = new FileSystemOptions();
            if (!ftc.getAccessType().isProtocolBased()) {
                FileSystemOptions fileSystemOptions = options;
                if (fileSystemOptions == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getConnectionOptions"));
                }
                return fileSystemOptions;
            }
            ((WebdavFileSystemConfigBuilder)WebdavFileSystemConfigBuilder.getInstance()).setCreatorName(options, connectionOwner.getHash());
            try {
                String controlEncoding = StringUtil.nullize((String)ftc.getAdvancedOptions().getControlEncoding(), (boolean)true);
                if (ftc.getAccessType() == AccessType.FTP) {
                    FtpFileSystemConfigBuilder.getInstance().setSoTimeout(options, Integer.valueOf(FTP_TIMEOUT));
                    FtpFileSystemConfigBuilder.getInstance().setDataTimeout(options, Integer.valueOf(FTP_DATA_TIMEOUT));
                    FtpFileSystemConfigBuilder.getInstance().setShowHiddenFiles(options, ftc.getAdvancedOptions().isShowHiddenFiles());
                    FtpFileSystemConfigBuilder.getInstance().setPassiveMode(options, ftc.getAdvancedOptions().isPassiveMode());
                    FtpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, originOption == FileTransferConfig.Origin.Unchanged);
                    if (originOption == FileTransferConfig.Origin.Default) {
                        FtpFileSystemConfigBuilder.getInstance().setHomeFolderOverride(options, ftc.getRootFolder());
                    }
                    FtpFileSystemConfigBuilder.getInstance().setEntryParserFactory(options, (org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory)new FTPFileEntryParserFactory(FTP_LOG));
                    FtpFileSystemConfigBuilder.getInstance().setCompatibleMode(options, ftc.getAdvancedOptions().isCompatibilityMode());
                    FtpFileSystemConfigBuilder.getInstance().setControlEncoding(options, controlEncoding);
                    if (disconnectTrigger != null) {
                        FtpFileSystemConfigBuilder.getInstance().setSocketFactory(options, MyFtpSocketFactoryBase.createInstance((EventDispatcher<RemoteConnectionManager.ForceDisconnectListener>)disconnectTrigger));
                        FtpFileSystemConfigBuilder.getInstance().setServerSocketFactory(options, MyFtpServerSocketFactoryBase.createInstance((EventDispatcher<RemoteConnectionManager.ForceDisconnectListener>)disconnectTrigger));
                    }
                    FtpFileSystemConfigBuilder.getInstance().setForceListCommand(options, ftc.getAdvancedOptions().isForceListCommand());
                    int keepAliveTimeout = ftc.getAdvancedOptions().getKeepAliveTimeout();
                    if (keepAliveTimeout > 0) {
                        FtpFileSystemConfigBuilder.getInstance().setKeepAliveTimeout(options, Integer.valueOf(keepAliveTimeout));
                    }
                    FtpFileSystemConfigBuilder.getInstance().setKeepAliveCommand(options, ftc.getAdvancedOptions().getKeepAliveFtpCommand());
                    break block23;
                }
                if (ftc.getAccessType() == AccessType.SFTP) {
                    int keepAliveTimeout;
                    SftpFileSystemConfigBuilder.getInstance().setTimeout(options, Integer.valueOf(SFTP_TIMEOUT));
                    WebServersConfigManager.getInstance(null).getSftpAdvancedOptions().applyTo(options);
                    if (ftc.getKnownHostsFile() != null) {
                        SftpFileSystemConfigBuilder.getInstance().setKnownHosts(options, new File(ftc.getKnownHostsFile()));
                    } else {
                        WebServerConfig.ensureExists(new File(SystemProperties.getUserHome(), ".ssh/known_hosts"));
                    }
                    SftpFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, originOption == FileTransferConfig.Origin.Unchanged);
                    if (originOption == FileTransferConfig.Origin.Default) {
                        SftpFileSystemConfigBuilder.getInstance().setHomeFolderOverride(options, ftc.getRootFolder());
                    }
                    if (LoggingSftpChannel.isEnabled()) {
                        SftpFileSystemConfigBuilder.getInstance().setSftpChannelDecorator(options, LoggingSftpChannel.class);
                    }
                    SftpFileSystemConfigBuilder.getInstance().setControlEncoding(options, controlEncoding);
                    if (disconnectTrigger != null) {
                        SftpFileSystemConfigBuilder.getInstance().setSocketFactory(options, (com.jcraft.jsch.SocketFactory)new MySftpSocketFactory(disconnectTrigger));
                    }
                    if (SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                        SftpFileSystemConfigBuilder.getInstance().setPreferredAuthentications(options, "publickey,keyboard-interactive,password");
                    }
                    if ((keepAliveTimeout = ftc.getAdvancedOptions().getKeepAliveTimeout()) > 0) {
                        SftpFileSystemConfigBuilder.getInstance().setKeepAliveTimeout(options, Integer.valueOf(keepAliveTimeout));
                        SftpFileSystemConfigBuilder.getInstance().setKeepAliveMaxCount(options, Integer.valueOf(Integer.MAX_VALUE));
                    }
                    JSch.setConfig((String)"MaxAuthTries", (String)"1");
                    break block23;
                }
                if (ftc.getAccessType() == AccessType.FTPS) {
                    FtpsFileSystemConfigBuilder.getInstance().setDataTimeout(options, Integer.valueOf(FTPS_DATA_TIMEOUT));
                    FtpsFileSystemConfigBuilder.getInstance().setShowHiddenFiles(options, ftc.getAdvancedOptions().isShowHiddenFiles());
                    FtpsFileSystemConfigBuilder.getInstance().setPassiveMode(options, ftc.getAdvancedOptions().isPassiveMode());
                    FtpsFileSystemConfigBuilder.getInstance().setUserDirIsRoot(options, originOption == FileTransferConfig.Origin.Unchanged);
                    if (originOption == FileTransferConfig.Origin.Default) {
                        FtpsFileSystemConfigBuilder.getInstance().setHomeFolderOverride(options, ftc.getRootFolder());
                    }
                    FtpsFileSystemConfigBuilder.getInstance().setFtpsMode(options, ftc.isFtpsExplicit() ? FtpsMode.EXPLICIT : FtpsMode.IMPLICIT);
                    FtpsFileSystemConfigBuilder.getInstance().setEntryParserFactory(options, (org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory)new FTPFileEntryParserFactory(FTPS_LOG));
                    FtpsFileSystemConfigBuilder.getInstance().setControlEncoding(options, controlEncoding);
                    AdvancedOptionsConfig.DataChannelProtectionLevel level = ftc.getAdvancedOptions().getDataChannelProtectionLevel();
                    FtpsFileSystemConfigBuilder.getInstance().setDataChannelProtectionLevel(options, level.getValue());
                    if (disconnectTrigger != null) {
                        FtpsFileSystemConfigBuilder.getInstance().setSocketFactoryWrapper(options, (SocketFactoryWrapper)new MyFtpsSocketFactoryWrapper(disconnectTrigger));
                        FtpsFileSystemConfigBuilder.getInstance().setServerSocketFactoryWrapper(options, (ServerSocketFactoryWrapper)new MyFtpsServerSocketFactoryWrapper(disconnectTrigger));
                    }
                    FtpFileSystemConfigBuilder.getInstance().setForceListCommand(options, ftc.getAdvancedOptions().isForceListCommand());
                    int keepAliveTimeout = ftc.getAdvancedOptions().getKeepAliveTimeout();
                    if (keepAliveTimeout > 0) {
                        FtpFileSystemConfigBuilder.getInstance().setKeepAliveTimeout(options, Integer.valueOf(keepAliveTimeout));
                    }
                    FtpFileSystemConfigBuilder.getInstance().setKeepAliveCommand(options, ftc.getAdvancedOptions().getKeepAliveFtpCommand());
                    break block23;
                }
                throw new IllegalStateException("Unknown access type " + (Object)((Object)ftc.getAccessType()));
            }
            catch (FileSystemException e) {
                LOG.error((Throwable)e);
            }
        }
        WebServerConfig.checkProperEqualsAndHash(options);
        FileSystemOptions fileSystemOptions = options;
        if (fileSystemOptions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getConnectionOptions"));
        }
        return fileSystemOptions;
    }

    public String getRootUri() {
        return this.getFileTransferConfig().getRootUri();
    }

    static void checkProperEqualsAndHash(FileSystemOptions options) {
        try {
            Field optionsField = FileSystemOptions.class.getDeclaredField("options");
            optionsField.setAccessible(true);
            Object optionsFieldValue = optionsField.get(options);
            Map optionsMap = (Map)optionsFieldValue;
            for (Object value : optionsMap.values()) {
                WebServerConfig.checkProperEqualsAndHash(value);
            }
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void checkProperEqualsAndHash(Object value) {
        if (value == null) {
            return;
        }
        if (value instanceof Number || value instanceof String || value instanceof Boolean || value instanceof StaticUserAuthenticator || value instanceof SftpUserInfo || value instanceof FTPFileEntryParserFactory || value instanceof Class || value instanceof File || value instanceof MyFtpSocketFactoryBase || value instanceof MyFtpServerSocketFactoryBase || value instanceof MySftpSocketFactory || value instanceof IdentityInfo || value instanceof IdentityInfo[] || value instanceof FtpsMode || value instanceof FtpsDataChannelProtectionLevel || value instanceof MyFtpsSocketFactoryWrapper || value instanceof MyFtpsServerSocketFactoryWrapper || value instanceof JBFtpKeepAliveCommand) {
            return;
        }
        throw new IllegalStateException("Unexpected value " + value.getClass());
    }

    private static void ensureExists(File file) {
        try {
            if (!file.getParentFile().isDirectory() && !file.getParentFile().mkdirs()) {
                LOG.warn("failed to create folder " + file.getParent());
            }
            if (!file.isFile() && !file.createNewFile()) {
                LOG.warn("failed to create file " + file.getPath());
            }
        }
        catch (IOException e) {
            LOG.warn((Throwable)e);
        }
    }

    @Override
    @NotNull
    public AccessType getAccessType() {
        AccessType accessType = this.getFileTransferConfig().getAccessType();
        if (accessType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getAccessType"));
        }
        return accessType;
    }

    @Override
    @Nullable
    public String getMountedFolder() {
        return this.getFileTransferConfig().getMountedFolder();
    }

    @Override
    public String getFullPath(String deployPath) {
        if (this.getAccessType().isProtocolBased()) {
            return DeploymentPathMapping.ensureRelative(deployPath);
        }
        return DeploymentPathUtils.join(this.getFileTransferConfig().getMountedFolder(), deployPath);
    }

    @Override
    public boolean isCaseSensitive() {
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return true;
        }
        return SystemInfo.isFileSystemCaseSensitive;
    }

    public boolean needsTransfer() {
        return PublishUtils.needsTransfer(this.getFileTransferConfig().getAccessType());
    }

    @Override
    @Nullable
    public String validateUrl() {
        if (StringUtil.isEmptyOrSpaces((String)this.myUrl) || DEFAULT_URL.equalsIgnoreCase(this.myUrl)) {
            return WDBundle.message("url.is.empty", new Object[0]);
        }
        String url = this.myUrl.toLowerCase();
        if (!url.startsWith(DEFAULT_URL) && !url.startsWith("https://")) {
            return WDBundle.message("url.is.invalid", new Object[0]);
        }
        return null;
    }

    @Nullable
    public String getNonBlockingWarnings() {
        return this.getFileTransferConfig().getNonBlockingWarnings();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebServerConfig that = (WebServerConfig)o;
        if (this.myId != null ? !this.myId.equals(that.myId) : that.myId != null) {
            return false;
        }
        if (!this.myFileTransferConfig.equals(that.myFileTransferConfig)) {
            return false;
        }
        if (this.myName != null ? !this.myName.equals(that.myName) : that.myName != null) {
            return false;
        }
        if (this.myUrl != null ? !this.myUrl.equals(that.myUrl) : that.myUrl != null) {
            return false;
        }
        return this.isProjectLevel == that.isProjectLevel;
    }

    public int hashCode() {
        int result = this.myName != null ? this.myName.hashCode() : 0;
        result = 31 * result + (this.myUrl != null ? this.myUrl.hashCode() : 0);
        result = 31 * result + this.myFileTransferConfig.hashCode();
        result = 31 * result + (this.myId != null ? this.myId.hashCode() : 0);
        result = 31 * result + (this.isProjectLevel ? 1 : 0);
        return result;
    }

    @Override
    public String getPresentablePath(@NotNull RemotePath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/jetbrains/plugins/webDeployment/config/WebServerConfig", "getPresentablePath"));
        }
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return DeploymentPathUtils.join(this.getFileTransferConfig().getRootFolder(), path.path);
        }
        return path.path;
    }

    @Override
    public String getPresentablePath(FileName fileName) {
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return DeploymentPathUtils.join(this.getFileTransferConfig().getRootFolder(), fileName.getPath());
        }
        return DeploymentPathUtils.getLocalPath(fileName);
    }

    @Override
    public RemotePath getRootPath() {
        if (this.getFileTransferConfig().getAccessType().isProtocolBased()) {
            return new RemotePath("/");
        }
        return new RemotePath(FileUtil.toSystemDependentName((String)this.getFileTransferConfig().getMountedFolder()));
    }

    public boolean isUsedInProject(Project project, PublishConfig publishConfig, boolean deployPathOnly) {
        List<DeploymentPathMapping> mappings = publishConfig.getPathMappings(this.getId());
        AccessType accessType = this.getFileTransferConfig().getAccessType();
        for (DeploymentPathMapping mapping : mappings) {
            if (!mapping.isLocalPathValid() || !mapping.isDeployPathValid(accessType.isProtocolBased()) && (deployPathOnly || !mapping.isWebPathValid())) continue;
            return true;
        }
        return false;
    }

    public static String getNextId() {
        return UUID.randomUUID().toString();
    }

    private static String getNonDuplicatingName(String existingServerName, Collection<String> otherNames) {
        if (otherNames.contains(existingServerName)) {
            int i = 1;
            String newName = existingServerName + " (" + i + ")";
            while (otherNames.contains(newName)) {
                newName = existingServerName + " (" + ++i + ")";
            }
            return newName;
        }
        return existingServerName;
    }

    public static void fixDuplicatingNames(List<WebServerConfig> servers) {
        ArrayList<String> names = new ArrayList<String>(servers.size());
        for (WebServerConfig server : servers) {
            String name = server.getName();
            String newName = WebServerConfig.getNonDuplicatingName(name, names);
            server.setName(newName);
            names.add(newName);
        }
    }

    private static ItemHolder<Socket> createDefaultSocketHolder() {
        return new ItemHolder<Socket>(){

            @Override
            protected void close(Socket socket) {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    private static ItemHolder<ServerSocket> createDefaultServerSocketHolder() {
        return new ItemHolder<ServerSocket>(){

            @Override
            protected void close(ServerSocket socket) {
                if (!socket.isClosed()) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WebServerConfig{");
        sb.append("myName='").append(this.myName).append('\'');
        sb.append(", myId='").append(this.myId).append('\'');
        sb.append('}');
        return sb.toString();
    }

    private static class MySftpSocketFactory
    implements com.jcraft.jsch.SocketFactory {
        private final ItemHolder<Socket> mySockets = WebServerConfig.access$800();

        public MySftpSocketFactory(EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
            disconnectTrigger.addListener(this.mySockets);
        }

        public Socket createSocket(String host, int port) throws IOException {
            Socket socket = new Socket(host, port);
            this.mySockets.add(socket);
            return socket;
        }

        public InputStream getInputStream(Socket socket) throws IOException {
            return socket.getInputStream();
        }

        public OutputStream getOutputStream(Socket socket) throws IOException {
            return socket.getOutputStream();
        }

        public boolean equals(Object obj) {
            return obj instanceof MySftpSocketFactory;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class MyFtpsServerSocketFactoryWrapper
    implements ServerSocketFactoryWrapper {
        final ItemHolder<ServerSocket> mySockets = WebServerConfig.access$1000();
        final EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> myDisconnectTrigger;

        private MyFtpsServerSocketFactoryWrapper(EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> trigger) {
            this.myDisconnectTrigger = trigger;
            this.myDisconnectTrigger.addListener(this.mySockets);
        }

        public ServerSocketFactory wrap(ServerSocketFactory initialFactory) {
            return new MyFtpServerSocketFactoryBase(initialFactory, this.mySockets);
        }

        public boolean equals(Object o) {
            return o instanceof MyFtpsServerSocketFactoryWrapper;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class MyFtpServerSocketFactoryBase
    extends ServerSocketFactory {
        private final ServerSocketFactory myDelegate;
        private final ItemHolder<ServerSocket> mySockets;

        private static ServerSocketFactory createInstance(EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
            ServerSocketFactory delegate = MyFtpServerSocketFactoryBase.getDefault();
            ItemHolder sockets = WebServerConfig.createDefaultServerSocketHolder();
            disconnectTrigger.addListener((EventListener)sockets);
            return new MyFtpServerSocketFactoryBase(delegate, sockets);
        }

        private MyFtpServerSocketFactoryBase(ServerSocketFactory delegate, ItemHolder<ServerSocket> sockets) {
            this.myDelegate = delegate;
            this.mySockets = sockets;
        }

        @Override
        public ServerSocket createServerSocket() throws IOException {
            ServerSocket socket = this.myDelegate.createServerSocket();
            this.mySockets.add(socket);
            return socket;
        }

        @Override
        public ServerSocket createServerSocket(int i) throws IOException {
            ServerSocket socket = this.myDelegate.createServerSocket(i);
            this.mySockets.add(socket);
            return socket;
        }

        @Override
        public ServerSocket createServerSocket(int i, int i1) throws IOException {
            ServerSocket socket = this.myDelegate.createServerSocket(i, i1);
            this.mySockets.add(socket);
            return socket;
        }

        @Override
        public ServerSocket createServerSocket(int i, int i1, InetAddress inetAddress) throws IOException {
            ServerSocket socket = this.myDelegate.createServerSocket(i, i1, inetAddress);
            this.mySockets.add(socket);
            return socket;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyFtpServerSocketFactoryBase;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class MyFtpsSocketFactoryWrapper
    implements SocketFactoryWrapper {
        final ItemHolder<Socket> mySockets = WebServerConfig.access$800();
        final EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> myDisconnectTrigger;

        private MyFtpsSocketFactoryWrapper(EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> trigger) {
            this.myDisconnectTrigger = trigger;
            this.myDisconnectTrigger.addListener(this.mySockets);
        }

        public SocketFactory wrap(SocketFactory initialFactory) {
            return new MyFtpSocketFactoryBase(initialFactory, this.mySockets);
        }

        public boolean equals(Object o) {
            return o instanceof MyFtpsSocketFactoryWrapper;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static class MyFtpSocketFactoryBase
    extends SocketFactory {
        private final SocketFactory myDelegate;
        private final ItemHolder<Socket> mySockets;

        private static SocketFactory createInstance(EventDispatcher<RemoteConnectionManager.ForceDisconnectListener> disconnectTrigger) {
            SocketFactory delegate = SocketFactory.getDefault();
            ItemHolder sockets = WebServerConfig.createDefaultSocketHolder();
            MyFtpSocketFactoryBase factory = new MyFtpSocketFactoryBase(delegate, sockets);
            disconnectTrigger.addListener((EventListener)sockets);
            return factory;
        }

        private MyFtpSocketFactoryBase(SocketFactory delegate, ItemHolder<Socket> sockets) {
            this.myDelegate = delegate;
            this.mySockets = sockets;
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException {
            Socket socket = this.myDelegate.createSocket(s, i);
            this.mySockets.add(socket);
            return socket;
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
            Socket socket = this.myDelegate.createSocket(s, i, inetAddress, i1);
            this.mySockets.add(socket);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            Socket socket = this.myDelegate.createSocket(inetAddress, i);
            this.mySockets.add(socket);
            return socket;
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            Socket socket = this.myDelegate.createSocket(inetAddress, i, inetAddress1, i1);
            this.mySockets.add(socket);
            return socket;
        }

        @Override
        public Socket createSocket() throws IOException {
            Socket socket = this.myDelegate.createSocket();
            this.mySockets.add(socket);
            return socket;
        }

        public boolean equals(Object obj) {
            return obj instanceof MyFtpSocketFactoryBase;
        }

        public int hashCode() {
            return 0;
        }
    }

    private static abstract class ItemHolder<T>
    implements RemoteConnectionManager.ForceDisconnectListener {
        private Collection<T> myItems = new ArrayList<T>();
        private boolean myClosed;

        private ItemHolder() {
        }

        @Override
        public synchronized void forceDisconnect() {
            this.myClosed = true;
            for (T item : this.myItems) {
                this.close(item);
            }
        }

        protected abstract void close(T var1);

        public synchronized void add(T item) throws IOException {
            if (this.myClosed) {
                this.close(item);
                throw new IOException("Connection closed");
            }
            this.myItems.add(item);
        }
    }

    private static class FTPFileEntryParserFactory
    extends DefaultFTPFileEntryParserFactory {
        private final boolean myLoggingEnabled;
        private final Logger myLogger;

        private FTPFileEntryParserFactory(Logger logger) {
            this.myLogger = logger;
            this.myLoggingEnabled = logger.isDebugEnabled();
        }

        public FTPFileEntryParser createFileEntryParser(String key) {
            FTPFileEntryParser parser;
            try {
                parser = super.createFileEntryParser(key);
            }
            catch (RuntimeException ex) {
                if (key.startsWith("WIN32")) {
                    LOG.info("Failed to get parser for key " + key);
                    parser = super.createFileEntryParser("WINDOWS");
                }
                throw ex;
            }
            if (this.myLoggingEnabled) {
                final FTPFileEntryParser finalParser = parser;
                return new FTPFileEntryParser(){

                    public FTPFile parseFTPEntry(String listEntry) {
                        return finalParser.parseFTPEntry(listEntry);
                    }

                    public String readNextEntry(BufferedReader reader) throws IOException {
                        String line = finalParser.readNextEntry(reader);
                        myLogger.debug(line);
                        return line;
                    }

                    public List<String> preParse(List<String> original) {
                        return finalParser.preParse(original);
                    }
                };
            }
            return parser;
        }

        public boolean equals(Object obj) {
            return obj instanceof FTPFileEntryParserFactory;
        }

        public int hashCode() {
            return 0;
        }
    }

    public static class RemotePath {
        public final String path;

        public RemotePath(String path) {
            this.path = path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RemotePath that = (RemotePath)o;
            return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
        }

        public int hashCode() {
            return this.path != null ? this.path.hashCode() : 0;
        }

        public String toString() {
            return this.path;
        }
    }
}

