/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui.auth;

import com.intellij.credentialStore.Credentials;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.concurrency.Semaphore;
import com.jetbrains.plugins.webDeployment.ConnectionOwner;
import com.jetbrains.plugins.webDeployment.ConnectionOwnerFactory;
import com.jetbrains.plugins.webDeployment.config.Connectable;
import com.jetbrains.plugins.webDeployment.config.Deployable;
import com.jetbrains.plugins.webDeployment.ui.auth.LoginDialog;
import gnu.trove.THashMap;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AuthHelper {
    private static final Logger LOG = Logger.getInstance((String)AuthHelper.class.getName());
    private static final Map<AuthKey, Collection<AuthPair>> LOGIN_SERVERS = new THashMap();

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull Deployable deployable, @NotNull Component component) {
        if (deployable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        return AuthHelper.ensureAuthSpecified(project, deployable, true, ConnectionOwnerFactory.createConnectionOwner(component));
    }

    public static boolean ensureAuthSpecified(@NotNull Deployable deployable, @Nullable Project project) {
        if (deployable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, deployable, true, (Factory<LoginDialog>)((Factory)() -> {
            if (deployable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$0"));
            }
            return new LoginDialog((Connectable)deployable, project, modal);
        }), modal);
    }

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull Deployable deployable, @NotNull ConnectionOwner connectionOwner) {
        if (deployable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, deployable, true, (Factory<LoginDialog>)((Factory)() -> {
            if (deployable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$1"));
            }
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$1"));
            }
            return LoginDialog.createInstance(deployable, connectionOwner, modal);
        }), modal);
    }

    public static boolean ensureAuthSpecified(@Nullable Project project, @NotNull Deployable deployable, boolean applyCredentialsToPasswordSafe, @NotNull ConnectionOwner connectionOwner) {
        if (deployable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        if (connectionOwner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "ensureAuthSpecified"));
        }
        boolean modal = ApplicationManager.getApplication().isDispatchThread();
        return AuthHelper.ensureAuthSpecified(project, deployable, applyCredentialsToPasswordSafe, (Factory<LoginDialog>)((Factory)() -> {
            if (deployable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "deployable", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$2"));
            }
            if (connectionOwner == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connectionOwner", "com/jetbrains/plugins/webDeployment/ui/auth/AuthHelper", "lambda$ensureAuthSpecified$2"));
            }
            return LoginDialog.createInstance(deployable, connectionOwner, modal);
        }), modal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean ensureAuthSpecified(@Nullable Project project, Deployable deployable, boolean applyCredentialsToPasswordSafe, Factory<LoginDialog> dialog, boolean modal) {
        if (deployable.hasCredentials()) {
            return true;
        }
        boolean needToShow = true;
        AuthPair resultPair = new AuthPair();
        AuthKey targetKey = new AuthKey(deployable, modal);
        if (targetKey.isDescriptive()) {
            Map<AuthKey, Collection<AuthPair>> map = LOGIN_SERVERS;
            synchronized (map) {
                Collection<AuthPair> refs = LOGIN_SERVERS.get(targetKey);
                if (refs == null) {
                    needToShow = true;
                    LOGIN_SERVERS.put(targetKey, new ArrayList());
                } else {
                    LOG.assertTrue(!modal);
                    needToShow = false;
                    refs.add(resultPair);
                    try {
                        Collection<AuthPair> pairs;
                        while ((pairs = LOGIN_SERVERS.get(targetKey)) != null && pairs.contains(resultPair)) {
                            LOGIN_SERVERS.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        LOG.warn("Undescriptive auth key for " + deployable);
        if (needToShow) {
            LOG.assertTrue(project != null || !deployable.isProjectLevel(), (Object)("Project '" + deployable.getName() + "' is project-level one. Please provide project."));
            Semaphore done = new Semaphore();
            Runnable runnable = () -> {
                LoginDialog d = (LoginDialog)((Object)((Object)dialog.create()));
                d.showAndGetResult().done(ok -> {
                    if (ok.booleanValue()) {
                        resultPair.username = d.getUsername();
                        resultPair.password = d.getPassword();
                        resultPair.savePassword = d.isSavePassword();
                    }
                    if (targetKey.isDescriptive()) {
                        Map<AuthKey, Collection<AuthPair>> map = LOGIN_SERVERS;
                        synchronized (map) {
                            for (AuthPair pair : LOGIN_SERVERS.remove(targetKey)) {
                                pair.username = resultPair.username;
                                pair.password = resultPair.password;
                                pair.savePassword = resultPair.savePassword;
                            }
                            LOGIN_SERVERS.notifyAll();
                        }
                    }
                    if (!modal) {
                        done.up();
                    }
                });
            };
            if (!modal) {
                done.down();
                ApplicationManager.getApplication().invokeAndWait(runnable);
                done.waitFor();
            } else {
                runnable.run();
            }
        }
        if (StringUtil.isEmptyOrSpaces((String)resultPair.username) || StringUtil.isEmptyOrSpaces((String)resultPair.password)) {
            return false;
        }
        deployable.setCredentials(new Credentials(resultPair.username, resultPair.password), !resultPair.savePassword, applyCredentialsToPasswordSafe, false);
        return true;
    }

    private static final class AuthKey {
        private final String myDeployableId;
        private final boolean myModal;

        private AuthKey(Deployable deployable, Boolean modal) {
            this.myDeployableId = deployable.getId();
            this.myModal = modal;
        }

        public boolean isDescriptive() {
            return !StringUtil.isEmptyOrSpaces((String)this.myDeployableId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AuthKey key = (AuthKey)o;
            if (this.myModal != key.myModal) {
                return false;
            }
            return !(this.myDeployableId != null ? !this.myDeployableId.equals(key.myDeployableId) : key.myDeployableId != null);
        }

        public int hashCode() {
            int result = this.myDeployableId != null ? this.myDeployableId.hashCode() : 0;
            result = 31 * result + (this.myModal ? 1 : 0);
            return result;
        }
    }

    private static class AuthPair {
        public String username;
        public String password;
        public boolean savePassword;

        private AuthPair() {
        }
    }
}

