/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitFileStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.openapi.util.TextRange;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AbstractQUnitModuleStructure {
    private final QUnitFileStructure myFileStructure;
    private final String myName;
    private final List<QUnitTestMethodStructure> myTestMethodStructures;
    private final Map<String, QUnitTestMethodStructure> myTestMethodStructureByNameMap;

    public AbstractQUnitModuleStructure(@NotNull QUnitFileStructure fileStructure, @NotNull String name) {
        if (fileStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileStructure", "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure", "<init>"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure", "<init>"));
        }
        this.myTestMethodStructures = Lists.newArrayList();
        this.myTestMethodStructureByNameMap = Maps.newHashMap();
        this.myFileStructure = fileStructure;
        this.myName = name;
    }

    @NotNull
    public QUnitFileStructure getFileStructure() {
        QUnitFileStructure qUnitFileStructure = this.myFileStructure;
        if (qUnitFileStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure", "getFileStructure"));
        }
        return qUnitFileStructure;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure", "getName"));
        }
        return string;
    }

    public void addTestMethodStructure(QUnitTestMethodStructure qUnitTestMethodStructure) {
        this.myTestMethodStructures.add(qUnitTestMethodStructure);
        this.myTestMethodStructureByNameMap.put(qUnitTestMethodStructure.getName(), qUnitTestMethodStructure);
    }

    @Nullable
    public QUnitTestMethodStructure getTestMethodStructureByName(String testMethodName) {
        return this.myTestMethodStructureByNameMap.get(testMethodName);
    }

    @NotNull
    public List<QUnitTestMethodStructure> getTestMethodStructures() {
        List<QUnitTestMethodStructure> list = this.myTestMethodStructures;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure", "getTestMethodStructures"));
        }
        return list;
    }

    public boolean isDefault() {
        return this instanceof DefaultQUnitModuleStructure;
    }

    public int getTestCount() {
        return this.myTestMethodStructures.size();
    }

    @Nullable
    public QUnitTestMethodStructure findTestMethodStructureContainingOffset(int offset) {
        for (QUnitTestMethodStructure testMethodStructure : this.myTestMethodStructures) {
            TextRange testTextRange = testMethodStructure.getCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(testTextRange, offset)) continue;
            return testMethodStructure;
        }
        return null;
    }

    @Nullable
    JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/qunit/AbstractQUnitModuleStructure", "findJstdRunElement"));
        }
        for (QUnitTestMethodStructure testMethodStructure : this.myTestMethodStructures) {
            TextRange testTextRange = testMethodStructure.getCallExpression().getTextRange();
            if (!testTextRange.contains(textRange)) continue;
            return JstdRunElement.newTestMethodRunElement(this.myName, "test " + testMethodStructure.getName());
        }
        return null;
    }
}

