/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testFramework.qunit;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.javascript.testFramework.AbstractTestFileStructure;
import com.intellij.javascript.testFramework.JstdRunElement;
import com.intellij.javascript.testFramework.qunit.AbstractQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.DefaultQUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitModuleStructure;
import com.intellij.javascript.testFramework.qunit.QUnitTestMethodStructure;
import com.intellij.javascript.testFramework.util.JsPsiUtils;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QUnitFileStructure
extends AbstractTestFileStructure {
    private final List<QUnitModuleStructure> myNonDefaultModuleStructures;
    private final Map<String, QUnitModuleStructure> myNonDefaultModuleStructureByNameMap;
    private final DefaultQUnitModuleStructure myDefaultModuleStructure;
    private Map<JSCallExpression, String> myNameByPsiElementMap;

    public QUnitFileStructure(@NotNull JSFile jsFile) {
        if (jsFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jsFile", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "<init>"));
        }
        super(jsFile);
        this.myNonDefaultModuleStructures = Lists.newArrayList();
        this.myNonDefaultModuleStructureByNameMap = Maps.newHashMap();
        this.myDefaultModuleStructure = new DefaultQUnitModuleStructure(this);
    }

    @Override
    public boolean isEmpty() {
        return !this.hasQUnitSymbols();
    }

    @NotNull
    public List<QUnitModuleStructure> getNonDefaultModuleStructures() {
        List<QUnitModuleStructure> list = this.myNonDefaultModuleStructures;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "getNonDefaultModuleStructures"));
        }
        return list;
    }

    public int getAllModuleCount() {
        return this.myNonDefaultModuleStructures.size() + 1;
    }

    public int getNonDefaultModuleCount() {
        return this.myNonDefaultModuleStructures.size();
    }

    public void addModuleStructure(@NotNull QUnitModuleStructure moduleStructure) {
        if (moduleStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleStructure", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "addModuleStructure"));
        }
        this.myNonDefaultModuleStructureByNameMap.put(moduleStructure.getName(), moduleStructure);
        this.myNonDefaultModuleStructures.add(moduleStructure);
    }

    @Nullable
    public String getNameByPsiElement(@NotNull JSCallExpression psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "getNameByPsiElement"));
        }
        return this.myNameByPsiElementMap.get(psiElement);
    }

    @Nullable
    public AbstractQUnitModuleStructure findQUnitModuleByName(@NotNull String qunitModuleName) {
        if (qunitModuleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qunitModuleName", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "findQUnitModuleByName"));
        }
        AbstractQUnitModuleStructure moduleStructure = this.myNonDefaultModuleStructureByNameMap.get(qunitModuleName);
        if (moduleStructure == null && this.myDefaultModuleStructure.getName().equals(qunitModuleName)) {
            moduleStructure = this.myDefaultModuleStructure;
        }
        return moduleStructure;
    }

    @NotNull
    public DefaultQUnitModuleStructure getDefaultModuleStructure() {
        DefaultQUnitModuleStructure defaultQUnitModuleStructure = this.myDefaultModuleStructure;
        if (defaultQUnitModuleStructure == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "getDefaultModuleStructure"));
        }
        return defaultQUnitModuleStructure;
    }

    public boolean hasQUnitSymbols() {
        return this.myDefaultModuleStructure.getTestCount() > 0 || this.getNonDefaultModuleCount() > 0;
    }

    @Nullable
    public QUnitModuleStructure findModuleStructureContainingOffset(int offset) {
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            TextRange moduleTextRange = moduleStructure.getEnclosingCallExpression().getTextRange();
            if (!JsPsiUtils.containsOffsetStrictly(moduleTextRange, offset)) continue;
            return moduleStructure;
        }
        return null;
    }

    @Nullable
    public QUnitTestMethodStructure findTestMethodStructureContainingOffset(int offset) {
        QUnitTestMethodStructure testMethodStructure = this.myDefaultModuleStructure.findTestMethodStructureContainingOffset(offset);
        if (testMethodStructure != null) {
            return testMethodStructure;
        }
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            testMethodStructure = moduleStructure.findTestMethodStructureContainingOffset(offset);
            if (testMethodStructure == null) continue;
            return testMethodStructure;
        }
        return null;
    }

    @Override
    @Nullable
    public JstdRunElement findJstdRunElement(@NotNull TextRange textRange) {
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "findJstdRunElement"));
        }
        for (QUnitModuleStructure nonDefaultModuleStructure : this.myNonDefaultModuleStructures) {
            JstdRunElement jstdRunElement = nonDefaultModuleStructure.findJstdRunElement(textRange);
            if (jstdRunElement == null) continue;
            return jstdRunElement;
        }
        return this.myDefaultModuleStructure.findJstdRunElement(textRange);
    }

    @Override
    public PsiElement findPsiElement(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "findPsiElement"));
        }
        AbstractQUnitModuleStructure qunitModuleStructure = this.findQUnitModuleByName(testCaseName);
        if (qunitModuleStructure != null) {
            if (testMethodName != null) {
                QUnitTestMethodStructure test = qunitModuleStructure.getTestMethodStructureByName(testMethodName);
                if (test != null) {
                    return test.getCallExpression();
                }
            } else {
                QUnitModuleStructure nonDefault = (QUnitModuleStructure)ObjectUtils.tryCast((Object)qunitModuleStructure, QUnitModuleStructure.class);
                if (nonDefault != null) {
                    return nonDefault.getEnclosingCallExpression();
                }
            }
        }
        return null;
    }

    @Override
    @NotNull
    public List<String> getTopLevelElements() {
        ArrayList<String> out = new ArrayList<String>(this.myNonDefaultModuleStructures.size() + 1);
        if (this.myDefaultModuleStructure.getTestCount() > 0) {
            out.add(this.myDefaultModuleStructure.getName());
        }
        for (QUnitModuleStructure structure : this.myNonDefaultModuleStructures) {
            out.add(structure.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "getTopLevelElements"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    public List<String> getChildrenOf(@NotNull String topLevelElementName) {
        if (topLevelElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "topLevelElementName", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "getChildrenOf"));
        }
        AbstractQUnitModuleStructure moduleStructure = this.findQUnitModuleByName(topLevelElementName);
        if (moduleStructure == null) {
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "getChildrenOf"));
            }
            return list;
        }
        ArrayList<String> out = new ArrayList<String>(moduleStructure.getTestCount());
        for (QUnitTestMethodStructure methodStructure : moduleStructure.getTestMethodStructures()) {
            out.add("test " + methodStructure.getName());
        }
        ArrayList<String> arrayList = out;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "getChildrenOf"));
        }
        return arrayList;
    }

    @Override
    public boolean contains(@NotNull String testCaseName, @Nullable String testMethodName) {
        if (testCaseName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCaseName", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "contains"));
        }
        AbstractQUnitModuleStructure qunitModuleStructure = this.findQUnitModuleByName(testCaseName);
        if (qunitModuleStructure == null) {
            return false;
        }
        if (testMethodName != null) {
            QUnitTestMethodStructure test = qunitModuleStructure.getTestMethodStructureByName(testMethodName);
            return test != null;
        }
        return true;
    }

    void postProcess() {
        this.myNameByPsiElementMap = this.createNameByPsiElementMap();
    }

    @NotNull
    private Map<JSCallExpression, String> createNameByPsiElementMap() {
        int count = this.myDefaultModuleStructure.getTestCount();
        for (QUnitModuleStructure nonDefaultModuleStructure : this.myNonDefaultModuleStructures) {
            count += nonDefaultModuleStructure.getTestCount() + 1;
        }
        if (count == 0) {
            Map<JSCallExpression, String> map = Collections.emptyMap();
            if (map == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "createNameByPsiElementMap"));
            }
            return map;
        }
        IdentityHashMap<JSCallExpression, String> nameMap = new IdentityHashMap<JSCallExpression, String>(count);
        for (QUnitModuleStructure moduleStructure : this.myNonDefaultModuleStructures) {
            JSCallExpression moduleElement = moduleStructure.getEnclosingCallExpression();
            nameMap.put(moduleElement, moduleStructure.getName());
            QUnitFileStructure.handleModuleStructure(moduleStructure, nameMap);
        }
        QUnitFileStructure.handleModuleStructure(this.myDefaultModuleStructure, nameMap);
        IdentityHashMap<JSCallExpression, String> identityHashMap = nameMap;
        if (identityHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "createNameByPsiElementMap"));
        }
        return identityHashMap;
    }

    private static void handleModuleStructure(@NotNull AbstractQUnitModuleStructure moduleStructure, @NotNull Map<JSCallExpression, String> nameMap) {
        if (moduleStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleStructure", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "handleModuleStructure"));
        }
        if (nameMap == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameMap", "com/intellij/javascript/testFramework/qunit/QUnitFileStructure", "handleModuleStructure"));
        }
        for (QUnitTestMethodStructure testMethodStructure : moduleStructure.getTestMethodStructures()) {
            JSCallExpression methodElement = testMethodStructure.getCallExpression();
            nameMap.put(methodElement, testMethodStructure.getName());
        }
    }
}

