/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.gui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.PlainDocument;
import javax.swing.text.Position;

public class ConsoleModel
extends PlainDocument {
    private static final long serialVersionUID = 1L;
    private static final int MAX_LENGTH = 20000;
    private static final Logger logger = Logger.getLogger(ConsoleModel.class.getName());
    private final OutputStream outputStream = new LocalOutputStream();
    private static ConsoleModel standard = new ConsoleModel();

    public static ConsoleModel getStandard() {
        return standard;
    }

    private void append(byte[] bytes, int offset, int length) throws IOException {
        try {
            String text = new String(bytes, offset, length, "ISO-8859-1");
            Position endPosition = this.getEndPosition();
            this.insertString(endPosition.getOffset(), text, null);
            int overflow = this.getLength() - 20000;
            if (overflow > 0) {
                Position startPosition = this.getStartPosition();
                this.remove(startPosition.getOffset(), overflow);
            }
        }
        catch (Throwable err) {
            logger.log(Level.SEVERE, "append()", err);
        }
    }

    public PrintStream getPrintStream() {
        return new PrintStream(this.outputStream);
    }

    private class LocalOutputStream
    extends OutputStream
    implements Runnable {
        private final LinkedList dataQueue = new LinkedList();

        public LocalOutputStream() {
            Thread t = new Thread((Runnable)this, "ConsoleOutputStream");
            t.setDaemon(true);
            t.start();
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void write(byte[] b) throws IOException {
            this.write(b, 0, b.length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            LinkedList linkedList = this.dataQueue;
            synchronized (linkedList) {
                byte[] actualBytes;
                if (off == 0 && len == b.length) {
                    actualBytes = b;
                } else {
                    actualBytes = new byte[len];
                    System.arraycopy(b, off, actualBytes, 0, len);
                }
                this.dataQueue.add(actualBytes);
                this.dataQueue.notify();
            }
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            while (true) {
                try {
                    while (true) {
                        buffer.reset();
                        LinkedList linkedList = this.dataQueue;
                        synchronized (linkedList) {
                            while (this.dataQueue.size() == 0) {
                                this.dataQueue.wait();
                            }
                            for (byte[] data : this.dataQueue) {
                                buffer.write(data);
                            }
                            this.dataQueue.clear();
                        }
                        byte[] allNewBytes = buffer.toByteArray();
                        ConsoleModel.this.append(allNewBytes, 0, allNewBytes.length);
                        Thread.sleep(300L);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace(System.err);
                    continue;
                }
                break;
            }
        }
    }
}

