/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.actions;

import com.intellij.diagram.DiagramAction;
import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.Utils;
import com.intellij.openapi.actionSystem.AnActionEvent;

public class ExpandNodesAction
extends DiagramAction {
    @Override
    public void perform(AnActionEvent e) {
        ExpandNodesAction.expandSelected(ExpandNodesAction.getBuilder(e));
    }

    public static void expandSelected(DiagramBuilder builder) {
        DiagramDataModel model = builder.getDataModel();
        if (model == null) {
            return;
        }
        for (DiagramNode node : Utils.getSelectedNodesExceptNotes(builder)) {
            model.expandNode(node);
        }
        model.refreshDataModel();
        model.getBuilder().update(false, true);
    }

    @Override
    public String getActionName() {
        return "Expand nodes";
    }

    @Override
    public boolean isEnabled(AnActionEvent e, DiagramBuilder b) {
        return Utils.getSelectedNodesExceptNotes(b).size() > 0;
    }
}

