/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.threading;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;

public class GroovyThreadStopSuspendResumeInspection
extends BaseInspection {
    private static final Set<String> METHOD_NAMES = new HashSet<String>();

    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Threading issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyThreadStopSuspendResumeInspection", "getGroupDisplayName"));
        }
        return "Threading issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Call to Thread.stop(), Thread.suspend(), or Thread.resume()" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyThreadStopSuspendResumeInspection", "getDisplayName"));
        }
        return "Call to Thread.stop(), Thread.suspend(), or Thread.resume()";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Call to Thread.'#ref' #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyThreadStopSuspendResumeInspection", "buildVisitor"));
        }
        return visitor;
    }

    static {
        METHOD_NAMES.add("stop");
        METHOD_NAMES.add("suspend");
        METHOD_NAMES.add("resume");
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitMethodCallExpression(@NotNull GrMethodCallExpression grMethodCallExpression) {
            if (grMethodCallExpression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grMethodCallExpression", "org/jetbrains/plugins/groovy/codeInspection/threading/GroovyThreadStopSuspendResumeInspection$Visitor", "visitMethodCallExpression"));
            }
            super.visitMethodCallExpression(grMethodCallExpression);
            GrExpression methodExpression = grMethodCallExpression.getInvokedExpression();
            if (!(methodExpression instanceof GrReferenceExpression)) {
                return;
            }
            GrReferenceExpression reference = (GrReferenceExpression)methodExpression;
            String name = reference.getReferenceName();
            if (!METHOD_NAMES.contains(name)) {
                return;
            }
            PsiMethod method = grMethodCallExpression.resolveMethod();
            if (method == null) {
                return;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null || !"java.lang.Thread".equals(containingClass.getQualifiedName())) {
                return;
            }
            this.registerMethodCallError(grMethodCallExpression, new Object[0]);
        }
    }
}

