/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiConstantEvaluationHelper;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.GrCondition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrBlockStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrCatchClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrClassInitializer;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrConstructorInvocation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrFinallyClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrForStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLabeledStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrLoopStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrSwitchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrTryCatchStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrWhileStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.arguments.GrArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrAssertStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrReturnStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrThrowStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseLabel;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrCaseSection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrForInClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.clauses.GrTraditionalForClause;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrApplicationStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrConditionalExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrElvisExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrInstanceOfExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrParenthesizedExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrUnaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.literals.GrStringInjection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.path.GrMethodCallExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnonymousClassDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.AfterCallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.CallInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ControlFlowBuilderUtil;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.GotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.InstanceOfInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.MixinTypeInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.NegatingGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.PositiveGotoInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReadWriteVariableInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.ReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ArgumentInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ConditionInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrControlFlowPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.GrResolverPolicy;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.IfEndInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.InstructionImpl;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.MaybeReturnInstruction;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.impl.ThrowingInstruction;
import org.jetbrains.plugins.groovy.lang.psi.impl.statements.expressions.TypesUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class ControlFlowBuilder
extends GroovyRecursiveElementVisitor {
    private static final Logger LOG = Logger.getInstance(ControlFlowBuilder.class);
    private final List<InstructionImpl> myInstructions = new ArrayList<InstructionImpl>();
    private final Deque<InstructionImpl> myProcessingStack = new ArrayDeque<InstructionImpl>();
    private final PsiConstantEvaluationHelper myConstantEvaluator;
    private GroovyPsiElement myScope;
    private final Deque<ExceptionInfo> myCaughtExceptionInfos = new ArrayDeque<ExceptionInfo>();
    private final Deque<ConditionInstruction> myConditions = new ArrayDeque<ConditionInstruction>();
    private int myFinallyCount;
    private InstructionImpl myHead;
    private List<Pair<InstructionImpl, GroovyPsiElement>> myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
    private int myInstructionNumber;
    private final GrControlFlowPolicy myPolicy;

    public ControlFlowBuilder(Project project) {
        this(project, GrResolverPolicy.getInstance());
    }

    public ControlFlowBuilder(Project project, GrControlFlowPolicy policy) {
        this.myPolicy = policy;
        this.myConstantEvaluator = JavaPsiFacade.getInstance((Project)project).getConstantEvaluationHelper();
    }

    @Override
    public void visitOpenBlock(@NotNull GrOpenBlock block) {
        GrStatement[] statements;
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitOpenBlock"));
        }
        PsiElement parent = block.getParent();
        PsiElement lbrace = block.getLBrace();
        if (lbrace != null && parent instanceof GrMethod) {
            for (GrParameter parameter : ((GrMethod)parent).getParameters()) {
                if (!this.myPolicy.isVariableInitialized(parameter)) continue;
                this.addNode(new ReadWriteVariableInstruction(parameter.getName(), parameter, -1));
            }
        }
        super.visitOpenBlock(block);
        if (!(block.getParent() instanceof GrBlockStatement && block.getParent().getParent() instanceof GrLoopStatement || (statements = block.getStatements()).length <= 0)) {
            this.handlePossibleReturn(statements[statements.length - 1]);
        }
    }

    @Override
    public void visitFile(@NotNull GroovyFileBase file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitFile"));
        }
        super.visitFile(file);
        GrStatement[] statements = file.getStatements();
        if (statements.length > 0) {
            this.handlePossibleReturn(statements[statements.length - 1]);
        }
    }

    @Nullable
    private InstructionImpl handlePossibleReturn(@NotNull GrStatement possibleReturn) {
        if (possibleReturn == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "possibleReturn", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "handlePossibleReturn"));
        }
        if (possibleReturn instanceof GrExpression && ControlFlowBuilderUtil.isCertainlyReturnStatement(possibleReturn)) {
            return this.addNodeAndCheckPending(new MaybeReturnInstruction((GrExpression)possibleReturn));
        }
        return null;
    }

    public Instruction[] buildControlFlow(GroovyPsiElement scope) {
        this.myFinallyCount = 0;
        this.myInstructionNumber = 0;
        this.myScope = scope;
        this.startNode(null);
        if (scope instanceof GrClosableBlock) {
            this.buildFlowForClosure((GrClosableBlock)scope);
        } else {
            scope.accept(this);
        }
        InstructionImpl end = this.startNode(null);
        this.checkPending(end);
        return ControlFlowBuilder.assertValidPsi(this.myInstructions.toArray(new Instruction[this.myInstructions.size()]));
    }

    public static Instruction[] assertValidPsi(Instruction[] instructions) {
        return instructions;
    }

    private void buildFlowForClosure(GrClosableBlock closure) {
        for (GrParameter parameter : closure.getAllParameters()) {
            if (!this.myPolicy.isVariableInitialized(parameter)) continue;
            this.addNode(new ReadWriteVariableInstruction(parameter.getName(), parameter, -1));
        }
        this.addNode(new ReadWriteVariableInstruction("owner", closure.getLBrace(), -1));
        for (PsiElement child = closure.getFirstChild(); child != null; child = child.getNextSibling()) {
            if (!(child instanceof GroovyPsiElement)) continue;
            ((GroovyPsiElement)child).accept(this);
        }
        GrStatement[] statements = closure.getStatements();
        if (statements.length > 0) {
            this.handlePossibleReturn(statements[statements.length - 1]);
        }
    }

    private <T extends InstructionImpl> T addNode(T instruction) {
        instruction.setNumber(this.myInstructionNumber++);
        this.myInstructions.add(instruction);
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, instruction);
        }
        this.myHead = instruction;
        return instruction;
    }

    private <T extends InstructionImpl> T addNodeAndCheckPending(T i) {
        this.addNode(i);
        this.checkPending(i);
        return i;
    }

    private static void addEdge(InstructionImpl begin, InstructionImpl end) {
        begin.addSuccessor(end);
        end.addPredecessor(begin);
        if (!(begin instanceof MixinTypeInstruction)) {
            end.addNegationsFrom(begin);
        }
    }

    @Override
    public void visitClosure(@NotNull GrClosableBlock closure) {
        ReadWriteVariableInstruction[] reads;
        if (closure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitClosure"));
        }
        if (closure.getParent() instanceof GrStringInjection) {
            for (GrParameter parameter : closure.getAllParameters()) {
                if (!this.myPolicy.isVariableInitialized(parameter)) continue;
                this.addNode(new ReadWriteVariableInstruction(parameter.getName(), parameter, -1));
            }
            this.addNode(new ReadWriteVariableInstruction("owner", closure.getLBrace(), -1));
            super.visitClosure(closure);
            return;
        }
        for (ReadWriteVariableInstruction read : reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(closure.getControlFlow(), false)) {
            PsiElement element = read.getElement();
            if (element instanceof GrReferenceExpression && !this.myPolicy.isReferenceAccepted((GrReferenceExpression)element)) continue;
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(read.getVariableName(), closure, 1));
        }
        this.addNodeAndCheckPending(new InstructionImpl(closure));
    }

    @Override
    public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
        if (breakStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitBreakStatement"));
        }
        super.visitBreakStatement(breakStatement);
        GrStatement target = breakStatement.resolveLabel();
        if (target == null) {
            target = breakStatement.findTargetStatement();
        }
        if (target != null) {
            if (this.myHead != null) {
                this.addPendingEdge(target, this.myHead);
            }
            this.readdPendingEdge(target);
        }
        this.interruptFlow();
    }

    @Override
    public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
        InstructionImpl instruction;
        if (continueStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continueStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitContinueStatement"));
        }
        super.visitContinueStatement(continueStatement);
        GrStatement target = continueStatement.resolveLabel();
        if (target == null) {
            target = continueStatement.findTargetStatement();
        }
        if (target != null && (instruction = this.findInstruction(target)) != null) {
            if (this.myHead != null) {
                ControlFlowBuilder.addEdge(this.myHead, instruction);
            }
            this.checkPending(continueStatement, instruction);
        }
        this.interruptFlow();
    }

    @Override
    public void visitReturnStatement(@NotNull GrReturnStatement returnStatement) {
        if (returnStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "returnStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitReturnStatement"));
        }
        boolean isNodeNeeded = this.myHead == null || this.myHead.getElement() != returnStatement;
        GrExpression value = returnStatement.getReturnValue();
        if (value != null) {
            value.accept(this);
        }
        if (isNodeNeeded) {
            InstructionImpl returnInstruction = this.startNode(returnStatement);
            this.addPendingEdge(null, this.myHead);
            this.finishNode(returnInstruction);
        } else {
            this.addPendingEdge(null, this.myHead);
        }
        this.interruptFlow();
    }

    @Override
    public void visitAssertStatement(@NotNull GrAssertStatement assertStatement) {
        if (assertStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "assertStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitAssertStatement"));
        }
        InstructionImpl assertInstruction = this.startNode(assertStatement);
        GrExpression assertion = assertStatement.getAssertion();
        if (assertion != null) {
            GrExpression errorMessage;
            assertion.accept(this);
            InstructionImpl positiveHead = this.myHead;
            List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(assertStatement);
            if (!negations.isEmpty()) {
                this.interruptFlow();
                this.reduceAllNegationsIntoInstruction(assertStatement, negations);
            }
            if ((errorMessage = assertStatement.getErrorMessage()) != null) {
                errorMessage.accept(this);
            }
            this.addNode(new ThrowingInstruction(assertStatement));
            PsiClassType type = TypesUtil.createTypeByFQClassName("java.lang.AssertionError", assertStatement);
            ExceptionInfo info = this.findCatch((PsiType)type);
            if (info != null) {
                info.myThrowers.add(this.myHead);
            } else {
                this.addPendingEdge(null, this.myHead);
            }
            this.myHead = positiveHead;
        }
        this.finishNode(assertInstruction);
    }

    @Override
    public void visitThrowStatement(@NotNull GrThrowStatement throwStatement) {
        if (throwStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "throwStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitThrowStatement"));
        }
        GrExpression exception = throwStatement.getException();
        if (exception == null) {
            return;
        }
        exception.accept(this);
        ThrowingInstruction throwInstruction = new ThrowingInstruction(throwStatement);
        this.addNodeAndCheckPending(throwInstruction);
        this.interruptFlow();
        PsiType type = ControlFlowBuilder.getNominalTypeNoRecursion(exception);
        if (type != null) {
            ExceptionInfo info = this.findCatch(type);
            if (info != null) {
                info.myThrowers.add(throwInstruction);
            } else {
                this.addPendingEdge(null, throwInstruction);
            }
        } else {
            this.addPendingEdge(null, throwInstruction);
        }
    }

    @Nullable
    private static PsiType getNominalTypeNoRecursion(@NotNull GrExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "getNominalTypeNoRecursion"));
        }
        if (expression instanceof GrNewExpression) {
            return expression.getType();
        }
        if (expression instanceof GrReferenceExpression && ((GrReferenceExpression)expression).getQualifier() == null) {
            return ControlFlowBuilder.getTypeByRef((GrReferenceExpression)expression);
        }
        return null;
    }

    @Nullable
    private static PsiType getTypeByRef(@NotNull GrReferenceExpression invoked) {
        PsiElement element;
        if (invoked == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invoked", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "getTypeByRef"));
        }
        GroovyResolveResult[] results = ControlFlowBuilderUtil.resolveNonQualifiedRefWithoutFlow(invoked);
        if (results.length == 1 && (element = results[0].getElement()) instanceof PsiVariable) {
            return ((PsiVariable)element).getType();
        }
        return null;
    }

    private void interruptFlow() {
        this.myHead = null;
    }

    @Nullable
    private ExceptionInfo findCatch(PsiType thrownType) {
        Iterator<ExceptionInfo> iterator = this.myCaughtExceptionInfos.descendingIterator();
        while (iterator.hasNext()) {
            PsiType type;
            ExceptionInfo info = iterator.next();
            GrCatchClause clause = info.myClause;
            GrParameter parameter = clause.getParameter();
            if (parameter == null || !(type = parameter.getType()).isAssignableFrom(thrownType)) continue;
            return info;
        }
        return null;
    }

    @Override
    public void visitLabeledStatement(@NotNull GrLabeledStatement labeledStatement) {
        if (labeledStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "labeledStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitLabeledStatement"));
        }
        InstructionImpl instruction = this.startNode(labeledStatement);
        super.visitLabeledStatement(labeledStatement);
        this.finishNode(instruction);
    }

    @Override
    public void visitAssignmentExpression(@NotNull GrAssignmentExpression expression) {
        GrExpression rValue;
        String referenceName;
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitAssignmentExpression"));
        }
        GrExpression lValue = expression.getLValue();
        if (expression.getOperationTokenType() != GroovyTokenTypes.mASSIGN && lValue instanceof GrReferenceExpression && this.myPolicy.isReferenceAccepted((GrReferenceExpression)lValue) && (referenceName = ((GrReferenceExpression)lValue).getReferenceName()) != null) {
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(referenceName, lValue, 1));
        }
        if ((rValue = expression.getRValue()) != null) {
            rValue.accept(this);
        }
        lValue.accept(this);
    }

    @Override
    public void visitParenthesizedExpression(@NotNull GrParenthesizedExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitParenthesizedExpression"));
        }
        GrExpression operand = expression.getOperand();
        if (operand != null) {
            operand.accept(this);
        }
    }

    @Override
    public void visitUnaryExpression(@NotNull GrUnaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitUnaryExpression"));
        }
        GrExpression operand = expression.getOperand();
        if (operand == null) {
            return;
        }
        if (expression.getOperationTokenType() != GroovyTokenTypes.mLNOT) {
            operand.accept(this);
            this.visitCall(expression);
            return;
        }
        ConditionInstruction cond = new ConditionInstruction(expression);
        this.addNodeAndCheckPending(cond);
        this.registerCondition(cond);
        operand.accept(this);
        this.visitCall(expression);
        this.myConditions.removeFirstOccurrence(cond);
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        InstructionImpl head = this.myHead;
        this.addNodeAndCheckPending(new PositiveGotoInstruction(expression, cond));
        this.handlePossibleReturn(expression);
        this.addPendingEdge(expression, this.myHead);
        this.myHead = negations.isEmpty() ? head : this.reduceAllNegationsIntoInstruction(expression, negations);
    }

    @Nullable
    private InstructionImpl reduceAllNegationsIntoInstruction(GroovyPsiElement currentScope, List<? extends GotoInstruction> negations) {
        if (negations.size() > 1) {
            InstructionImpl instruction = this.addNode(new InstructionImpl(currentScope));
            for (GotoInstruction gotoInstruction : negations) {
                ControlFlowBuilder.addEdge(gotoInstruction, instruction);
            }
            return instruction;
        }
        if (negations.size() == 1) {
            GotoInstruction instruction = negations.get(0);
            this.myHead = instruction;
            return instruction;
        }
        return null;
    }

    private List<GotoInstruction> collectAndRemoveAllPendingNegations(GroovyPsiElement currentScope) {
        ArrayList<GotoInstruction> negations = new ArrayList<GotoInstruction>();
        Iterator<Pair<InstructionImpl, GroovyPsiElement>> iterator = this.myPending.iterator();
        while (iterator.hasNext()) {
            Pair<InstructionImpl, GroovyPsiElement> pair = iterator.next();
            InstructionImpl instruction = (InstructionImpl)pair.first;
            GroovyPsiElement scope = (GroovyPsiElement)pair.second;
            if (PsiTreeUtil.isAncestor((PsiElement)scope, (PsiElement)currentScope, (boolean)true) || !(instruction instanceof GotoInstruction)) continue;
            negations.add((GotoInstruction)instruction);
            iterator.remove();
        }
        return negations;
    }

    @Override
    public void visitInstanceofExpression(@NotNull GrInstanceOfExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitInstanceofExpression"));
        }
        expression.getOperand().accept(this);
        this.processInstanceOf(expression);
    }

    @Override
    public void visitReferenceExpression(@NotNull GrReferenceExpression refExpr) {
        if (refExpr == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refExpr", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitReferenceExpression"));
        }
        super.visitReferenceExpression(refExpr);
        if (this.myPolicy.isReferenceAccepted(refExpr)) {
            String name = refExpr.getReferenceName();
            if (name == null) {
                return;
            }
            if (ControlFlowUtils.isIncOrDecOperand(refExpr)) {
                ReadWriteVariableInstruction i = new ReadWriteVariableInstruction(name, refExpr, 1);
                this.addNodeAndCheckPending(i);
                this.addNode(new ReadWriteVariableInstruction(name, refExpr, -1));
            } else {
                int type = PsiUtil.isLValue(refExpr) ? -1 : 1;
                this.addNodeAndCheckPending(new ReadWriteVariableInstruction(name, refExpr, type));
                if (refExpr.getParent() instanceof GrArgumentList && refExpr.getParent().getParent() instanceof GrCall) {
                    this.addNodeAndCheckPending(new ArgumentInstruction(refExpr));
                }
            }
        }
        if (refExpr.isQualified() && !(refExpr.getParent() instanceof GrCall)) {
            this.visitCall(refExpr);
        }
    }

    @Override
    public void visitMethodCallExpression(@NotNull GrMethodCallExpression methodCallExpression) {
        if (methodCallExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "methodCallExpression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitMethodCallExpression"));
        }
        super.visitMethodCallExpression(methodCallExpression);
        this.visitCall(methodCallExpression);
    }

    @Override
    public void visitApplicationStatement(@NotNull GrApplicationStatement applicationStatement) {
        if (applicationStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "applicationStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitApplicationStatement"));
        }
        super.visitApplicationStatement(applicationStatement);
        this.visitCall(applicationStatement);
    }

    @Override
    public void visitConstructorInvocation(@NotNull GrConstructorInvocation invocation) {
        if (invocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "invocation", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitConstructorInvocation"));
        }
        super.visitConstructorInvocation(invocation);
        this.visitCall(invocation);
    }

    @Override
    public void visitNewExpression(@NotNull GrNewExpression newExpression) {
        if (newExpression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newExpression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitNewExpression"));
        }
        super.visitNewExpression(newExpression);
        this.visitCall(newExpression);
    }

    @Override
    public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitBinaryExpression"));
        }
        GrExpression left = expression.getLeftOperand();
        GrExpression right = expression.getRightOperand();
        IElementType opType = expression.getOperationTokenType();
        if (ControlFlowBuilderUtil.isInstanceOfBinary(expression)) {
            expression.getLeftOperand().accept(this);
            this.processInstanceOf(expression);
            return;
        }
        if (opType != GroovyTokenTypes.mLOR && opType != GroovyTokenTypes.mLAND && opType != GroovyTokenTypes.kIN) {
            left.accept(this);
            if (right != null) {
                right.accept(this);
            }
            this.visitCall(expression);
            return;
        }
        ConditionInstruction condition = new ConditionInstruction(expression);
        this.addNodeAndCheckPending(condition);
        this.registerCondition(condition);
        left.accept(this);
        if (right == null) {
            return;
        }
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        this.visitCall(expression);
        if (opType == GroovyTokenTypes.mLAND) {
            InstructionImpl head = this.myHead;
            if (negations.isEmpty()) {
                this.addNode(new NegatingGotoInstruction(expression, condition));
                this.handlePossibleReturn(expression);
                this.addPendingEdge(expression, this.myHead);
            } else {
                for (GotoInstruction negation : negations) {
                    this.myHead = negation;
                    this.handlePossibleReturn(expression);
                    this.addPendingEdge(expression, this.myHead);
                }
            }
            this.myHead = head;
        } else {
            InstructionImpl instruction = this.addNodeAndCheckPending(new InstructionImpl(expression));
            this.handlePossibleReturn(expression);
            this.addPendingEdge(expression, this.myHead);
            this.myHead = instruction;
            InstructionImpl head = this.reduceAllNegationsIntoInstruction(expression, negations);
            if (head != null) {
                this.myHead = head;
            }
        }
        this.myConditions.removeFirstOccurrence(condition);
        right.accept(this);
    }

    private void processInstanceOf(GrExpression expression) {
        ConditionInstruction cond = new ConditionInstruction(expression);
        this.addNodeAndCheckPending(cond);
        this.registerCondition(cond);
        this.addNode(new InstanceOfInstruction(expression, cond));
        NegatingGotoInstruction negation = new NegatingGotoInstruction(expression, cond);
        this.addNode(negation);
        InstructionImpl possibleReturn = this.handlePossibleReturn(expression);
        this.addPendingEdge(expression, possibleReturn != null ? possibleReturn : negation);
        this.myHead = cond;
        this.addNode(new InstanceOfInstruction(expression, cond));
        this.myConditions.removeFirstOccurrence(cond);
    }

    private void visitCall(GroovyPsiElement call) {
        if (this.myCaughtExceptionInfos.size() <= 0 && this.myFinallyCount <= 0) {
            return;
        }
        ThrowingInstruction instruction = new ThrowingInstruction(call);
        this.addNodeAndCheckPending(instruction);
        for (ExceptionInfo info : this.myCaughtExceptionInfos) {
            info.myThrowers.add(instruction);
        }
        if (this.myFinallyCount > 0) {
            this.addPendingEdge(null, instruction);
        }
    }

    @Override
    public void visitIfStatement(@NotNull GrIfStatement ifStatement) {
        if (ifStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ifStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitIfStatement"));
        }
        InstructionImpl ifInstruction = this.startNode(ifStatement);
        GrExpression condition = ifStatement.getCondition();
        GrStatement thenBranch = ifStatement.getThenBranch();
        GrStatement elseBranch = ifStatement.getElseBranch();
        InstructionImpl conditionEnd = null;
        InstructionImpl thenEnd = null;
        InstructionImpl elseEnd = null;
        if (condition != null) {
            condition.accept(this);
            conditionEnd = this.myHead;
        }
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(ifStatement);
        if (thenBranch != null) {
            thenBranch.accept(this);
            this.handlePossibleReturn(thenBranch);
            thenEnd = this.myHead;
            this.interruptFlow();
            this.readdPendingEdge(ifStatement);
        }
        this.myHead = this.reduceAllNegationsIntoInstruction(ifStatement, negations);
        if (this.myHead == null && conditionEnd != null) {
            this.myHead = conditionEnd;
        }
        if (elseBranch != null) {
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
            elseEnd = this.myHead;
            this.interruptFlow();
        }
        if (!(thenBranch == null && elseBranch == null || thenEnd == null && elseEnd == null && elseBranch != null)) {
            IfEndInstruction end = new IfEndInstruction(ifStatement);
            this.addNode(end);
            if (thenEnd != null) {
                ControlFlowBuilder.addEdge(thenEnd, end);
            }
            if (elseEnd != null) {
                ControlFlowBuilder.addEdge(elseEnd, end);
            } else if (elseBranch == null) {
                // empty if block
            }
        }
        this.finishNode(ifInstruction);
    }

    private void registerCondition(ConditionInstruction conditionStart) {
        for (ConditionInstruction condition : this.myConditions) {
            condition.addDependent(conditionStart);
        }
        this.myConditions.push(conditionStart);
    }

    private void acceptNullable(@Nullable GroovyPsiElement element) {
        if (element != null) {
            element.accept(this);
        }
    }

    @Override
    public void visitForStatement(@NotNull GrForStatement forStatement) {
        if (forStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "forStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitForStatement"));
        }
        GrForClause clause = forStatement.getClause();
        this.processForLoopInitializer(clause);
        InstructionImpl start = this.startNode(forStatement);
        this.addForLoopBreakingEdge(forStatement, clause);
        this.flushForeachLoopVariable(clause);
        GrStatement body = forStatement.getBody();
        if (body != null) {
            InstructionImpl bodyInstruction = this.startNode(body);
            body.accept(this);
            this.finishNode(bodyInstruction);
        }
        this.checkPending(start);
        if (clause instanceof GrTraditionalForClause) {
            this.acceptNullable(((GrTraditionalForClause)clause).getUpdate());
        }
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, start);
        }
        this.interruptFlow();
        this.finishNode(start);
    }

    private void processForLoopInitializer(@Nullable GrForClause clause) {
        GrCondition initializer = clause instanceof GrTraditionalForClause ? ((GrTraditionalForClause)clause).getInitialization() : (clause instanceof GrForInClause ? ((GrForInClause)clause).getIteratedExpression() : null);
        this.acceptNullable(initializer);
    }

    private void addForLoopBreakingEdge(GrForStatement forStatement, @Nullable GrForClause clause) {
        GrForStatement target;
        GroovyPsiElement groovyPsiElement = target = forStatement.getParent() instanceof GrLabeledStatement ? (GroovyPsiElement)forStatement.getParent() : forStatement;
        if (clause instanceof GrTraditionalForClause) {
            GrExpression condition = ((GrTraditionalForClause)clause).getCondition();
            if (condition != null) {
                condition.accept(this);
                if (!this.alwaysTrue(condition)) {
                    this.addPendingEdge(target, this.myHead);
                }
            }
        } else {
            this.addPendingEdge(target, this.myHead);
        }
    }

    private void flushForeachLoopVariable(@Nullable GrForClause clause) {
        GrVariable variable;
        if (clause instanceof GrForInClause && (variable = clause.getDeclaredVariable()) != null && this.myPolicy.isVariableInitialized(variable)) {
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(variable.getName(), variable, -1));
        }
    }

    @NotNull
    private List<Pair<InstructionImpl, GroovyPsiElement>> collectCorrespondingPendingEdges(@Nullable PsiElement currentScope) {
        if (currentScope == null) {
            List<Pair<InstructionImpl, GroovyPsiElement>> result = this.myPending;
            this.myPending = ContainerUtil.newArrayList();
            List<Pair<InstructionImpl, GroovyPsiElement>> list = result;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "collectCorrespondingPendingEdges"));
            }
            return list;
        }
        ArrayList targets = ContainerUtil.newArrayList();
        for (int i = this.myPending.size() - 1; i >= 0; --i) {
            Pair<InstructionImpl, GroovyPsiElement> pair = this.myPending.get(i);
            PsiElement scopeWhenToAdd = (PsiElement)pair.getSecond();
            if (scopeWhenToAdd == null) continue;
            if (PsiTreeUtil.isAncestor((PsiElement)scopeWhenToAdd, (PsiElement)currentScope, (boolean)false)) break;
            targets.add(pair);
            this.myPending.remove(i);
        }
        ArrayList arrayList = targets;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "collectCorrespondingPendingEdges"));
        }
        return arrayList;
    }

    private void checkPending(@NotNull InstructionImpl instruction) {
        if (instruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instruction", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "checkPending"));
        }
        PsiElement element = instruction.getElement();
        this.checkPending(element, instruction);
    }

    private void checkPending(@Nullable PsiElement currentScope, @NotNull InstructionImpl targetInstruction) {
        if (targetInstruction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetInstruction", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "checkPending"));
        }
        List<Pair<InstructionImpl, GroovyPsiElement>> pendingEdges = this.collectCorrespondingPendingEdges(currentScope);
        for (Pair<InstructionImpl, GroovyPsiElement> pair : pendingEdges) {
            ControlFlowBuilder.addEdge((InstructionImpl)pair.getFirst(), targetInstruction);
        }
    }

    private void readdPendingEdge(@Nullable GroovyPsiElement newScope) {
        List<Pair<InstructionImpl, GroovyPsiElement>> targets = this.collectCorrespondingPendingEdges(newScope);
        for (Pair<InstructionImpl, GroovyPsiElement> target : targets) {
            this.addPendingEdge(newScope, (InstructionImpl)target.getFirst());
        }
    }

    private void addPendingEdge(@Nullable GroovyPsiElement scopeWhenAdded, InstructionImpl instruction) {
        int i;
        if (instruction == null) {
            return;
        }
        if (scopeWhenAdded != null) {
            Pair<InstructionImpl, GroovyPsiElement> pair;
            GroovyPsiElement currScope;
            for (i = 0; i < this.myPending.size() && ((currScope = (GroovyPsiElement)(pair = this.myPending.get(i)).getSecond()) == null || PsiTreeUtil.isAncestor((PsiElement)currScope, (PsiElement)scopeWhenAdded, (boolean)true)); ++i) {
            }
        }
        this.myPending.add(i, (Pair<InstructionImpl, GroovyPsiElement>)Pair.create((Object)instruction, (Object)scopeWhenAdded));
    }

    @Override
    public void visitWhileStatement(@NotNull GrWhileStatement whileStatement) {
        GrStatement body;
        if (whileStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "whileStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitWhileStatement"));
        }
        InstructionImpl instruction = this.startNode(whileStatement);
        GrExpression condition = whileStatement.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        if (!this.alwaysTrue(condition)) {
            this.addPendingEdge(whileStatement, this.myHead);
        }
        if ((body = whileStatement.getBody()) != null) {
            body.accept(this);
        }
        this.checkPending(instruction);
        if (this.myHead != null) {
            ControlFlowBuilder.addEdge(this.myHead, instruction);
        }
        this.interruptFlow();
        this.finishNode(instruction);
    }

    private boolean alwaysTrue(GroovyPsiElement condition) {
        return Boolean.TRUE.equals(this.myConstantEvaluator.computeConstantExpression((PsiElement)condition));
    }

    @Override
    public void visitSwitchStatement(@NotNull GrSwitchStatement switchStatement) {
        if (switchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "switchStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitSwitchStatement"));
        }
        GrExpression condition = switchStatement.getCondition();
        if (condition != null) {
            condition.accept(this);
        }
        InstructionImpl instruction = this.startNode(switchStatement);
        GrCaseSection[] sections = switchStatement.getCaseSections();
        if (!ControlFlowBuilder.containsAllCases(switchStatement)) {
            this.addPendingEdge(switchStatement, instruction);
        }
        for (GrCaseSection section : sections) {
            this.myHead = instruction;
            section.accept(this);
        }
        this.finishNode(instruction);
    }

    @Override
    public void visitConditionalExpression(@NotNull GrConditionalExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitConditionalExpression"));
        }
        GrExpression condition = expression.getCondition();
        GrExpression thenBranch = expression.getThenBranch();
        GrExpression elseBranch = expression.getElseBranch();
        condition.accept(this);
        InstructionImpl conditionEnd = this.myHead;
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        if (thenBranch != null) {
            thenBranch.accept(this);
            this.handlePossibleReturn(thenBranch);
            this.addPendingEdge(expression, this.myHead);
        }
        if (elseBranch != null) {
            InstructionImpl head = this.reduceAllNegationsIntoInstruction(expression, negations);
            this.myHead = head != null ? head : conditionEnd;
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
        }
    }

    @Override
    public void visitElvisExpression(@NotNull GrElvisExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitElvisExpression"));
        }
        GrExpression condition = expression.getCondition();
        GrExpression elseBranch = expression.getElseBranch();
        condition.accept(this);
        List<GotoInstruction> negations = this.collectAndRemoveAllPendingNegations(expression);
        InstructionImpl head = this.myHead;
        this.handlePossibleReturn(condition);
        this.addPendingEdge(expression, this.myHead);
        this.myHead = head;
        if (elseBranch != null) {
            head = this.reduceAllNegationsIntoInstruction(expression, negations);
            if (head != null) {
                this.myHead = head;
            }
            elseBranch.accept(this);
            this.handlePossibleReturn(elseBranch);
        }
    }

    private static boolean containsAllCases(GrSwitchStatement statement) {
        PsiClass resolved;
        GrCaseSection[] sections;
        for (GrCaseSection section : sections = statement.getCaseSections()) {
            if (!section.isDefault()) continue;
            return true;
        }
        GrExpression condition = statement.getCondition();
        if (!(condition instanceof GrReferenceExpression)) {
            return false;
        }
        PsiType type = TypesUtil.unboxPrimitiveTypeWrapper(ControlFlowBuilder.getNominalTypeNoRecursion(condition));
        if (type == null) {
            return false;
        }
        if (type instanceof PsiPrimitiveType) {
            if (PsiType.BOOLEAN.equals((Object)type)) {
                return sections.length == 2;
            }
            if (PsiType.BYTE.equals((Object)type) || PsiType.CHAR.equals((Object)type)) {
                return sections.length == 128;
            }
            return false;
        }
        if (type instanceof PsiClassType && (resolved = ((PsiClassType)type).resolve()) != null && resolved.isEnum()) {
            PsiField[] fields;
            int enumConstantCount = 0;
            for (PsiField field : fields = resolved.getFields()) {
                if (!(field instanceof PsiEnumConstant)) continue;
                ++enumConstantCount;
            }
            if (sections.length == enumConstantCount) {
                return true;
            }
        }
        return false;
    }

    @Override
    public void visitCaseSection(@NotNull GrCaseSection caseSection) {
        int i;
        if (caseSection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caseSection", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitCaseSection"));
        }
        for (GrCaseLabel label : caseSection.getCaseLabels()) {
            GrExpression value = label.getValue();
            if (value == null) continue;
            value.accept(this);
        }
        GrStatement[] statements = caseSection.getStatements();
        for (i = statements.length - 1; i >= 0 && statements[i] instanceof GrBreakStatement; --i) {
        }
        for (int j = 0; j < statements.length; ++j) {
            GrStatement statement = statements[j];
            statement.accept(this);
            if (j != i) continue;
            this.handlePossibleReturn(statement);
        }
        if (this.myHead != null) {
            this.addPendingEdge(caseSection, this.myHead);
        }
    }

    @Override
    public void visitTryStatement(@NotNull GrTryCatchStatement tryCatchStatement) {
        if (tryCatchStatement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tryCatchStatement", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitTryStatement"));
        }
        GrOpenBlock tryBlock = tryCatchStatement.getTryBlock();
        GrCatchClause[] catchClauses = tryCatchStatement.getCatchClauses();
        GrFinallyClause finallyClause = tryCatchStatement.getFinallyClause();
        for (int i = catchClauses.length - 1; i >= 0; --i) {
            this.myCaughtExceptionInfos.push(new ExceptionInfo(catchClauses[i]));
        }
        if (finallyClause != null) {
            ++this.myFinallyCount;
        }
        List<Pair<InstructionImpl, GroovyPsiElement>> oldPending = null;
        if (finallyClause != null) {
            oldPending = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
        }
        InstructionImpl tryBegin = this.startNode(tryBlock);
        tryBlock.accept(this);
        InstructionImpl tryEnd = this.myHead;
        this.finishNode(tryBegin);
        LinkedHashSet<Pair<InstructionImpl, GroovyPsiElement>> pendingAfterTry = new LinkedHashSet<Pair<InstructionImpl, GroovyPsiElement>>(this.myPending);
        List[] throwers = new List[catchClauses.length];
        for (int i = 0; i < catchClauses.length; ++i) {
            throwers[i] = this.myCaughtExceptionInfos.pop().myThrowers;
        }
        InstructionImpl[] catches = new InstructionImpl[catchClauses.length];
        for (int i = 0; i < catchClauses.length; ++i) {
            this.interruptFlow();
            InstructionImpl catchBeg = this.startNode(catchClauses[i]);
            for (InstructionImpl[] thrower : throwers[i]) {
                ControlFlowBuilder.addEdge((InstructionImpl)thrower, catchBeg);
            }
            GrParameter parameter = catchClauses[i].getParameter();
            if (parameter != null && this.myPolicy.isVariableInitialized(parameter)) {
                this.addNode(new ReadWriteVariableInstruction(parameter.getName(), parameter, -1));
            }
            catchClauses[i].accept(this);
            catches[i] = this.myHead;
            this.finishNode(catchBeg);
        }
        pendingAfterTry.addAll(this.myPending);
        this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>(pendingAfterTry);
        if (finallyClause != null) {
            --this.myFinallyCount;
            this.interruptFlow();
            InstructionImpl finallyInstruction = this.startNode(finallyClause, false);
            LinkedHashSet<AfterCallInstruction> postCalls = new LinkedHashSet<AfterCallInstruction>();
            List<Pair<InstructionImpl, GroovyPsiElement>> copy = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
            for (Pair pair : copy) {
                postCalls.add(this.addCallNode(finallyInstruction, (GroovyPsiElement)pair.getSecond(), (InstructionImpl)pair.getFirst()));
            }
            if (tryEnd != null) {
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, tryEnd));
            }
            for (InstructionImpl catchEnd : catches) {
                if (catchEnd == null) continue;
                postCalls.add(this.addCallNode(finallyInstruction, tryCatchStatement, catchEnd));
            }
            List<Pair<InstructionImpl, GroovyPsiElement>> pendingPostCalls = this.myPending;
            this.myPending = new ArrayList<Pair<InstructionImpl, GroovyPsiElement>>();
            this.myHead = finallyInstruction;
            finallyClause.accept(this);
            ReturnInstruction returnInstruction = new ReturnInstruction(finallyClause);
            for (AfterCallInstruction postCall : postCalls) {
                postCall.setReturnInstruction(returnInstruction);
                ControlFlowBuilder.addEdge(returnInstruction, postCall);
            }
            this.addNodeAndCheckPending(returnInstruction);
            this.interruptFlow();
            this.finishNode(finallyInstruction);
            if (oldPending == null) {
                this.error();
            }
            oldPending.addAll(pendingPostCalls);
            this.myPending = oldPending;
        } else {
            if (tryEnd != null) {
                this.addPendingEdge(tryCatchStatement, tryEnd);
            }
            for (InstructionImpl catchEnd : catches) {
                this.addPendingEdge(tryBlock, catchEnd);
            }
        }
    }

    private void error() {
        this.error("broken control flow for a scope");
    }

    private void error(String descr) {
        PsiFile file = this.myScope.getContainingFile();
        String fileText = file != null ? file.getText() : null;
        VirtualFile virtualFile = PsiUtilCore.getVirtualFile((PsiElement)file);
        String path = virtualFile == null ? null : virtualFile.getPresentableUrl();
        LOG.error(descr + this.myScope.getText(), new Attachment[]{new Attachment(path + "", fileText + "")});
    }

    private AfterCallInstruction addCallNode(InstructionImpl finallyInstruction, GroovyPsiElement scopeWhenAdded, InstructionImpl src) {
        this.interruptFlow();
        CallInstruction call = new CallInstruction(finallyInstruction);
        this.addNode(call);
        ControlFlowBuilder.addEdge(src, call);
        ControlFlowBuilder.addEdge(call, finallyInstruction);
        AfterCallInstruction afterCall = new AfterCallInstruction(call);
        this.addNode(afterCall);
        this.addPendingEdge(scopeWhenAdded, afterCall);
        return afterCall;
    }

    private InstructionImpl startNode(@Nullable GroovyPsiElement element) {
        return this.startNode(element, true);
    }

    private InstructionImpl startNode(@Nullable GroovyPsiElement element, boolean checkPending) {
        InstructionImpl instruction = new InstructionImpl(element);
        this.addNode(instruction);
        if (checkPending) {
            this.checkPending(instruction);
        }
        this.myProcessingStack.push(instruction);
        return instruction;
    }

    private void finishNode(InstructionImpl instruction) {
        InstructionImpl popped = this.myProcessingStack.pop();
        if (!instruction.equals(popped)) {
            String description = "popped  : " + popped.toString() + " : " + popped.hashCode() + ", " + popped.getClass() + "\nexpected: " + instruction.toString() + " : " + instruction.hashCode() + ", " + instruction.getClass() + "\nsame objects: " + (popped == instruction) + "\n";
            this.error(description);
        }
    }

    @Override
    public void visitField(@NotNull GrField field) {
        if (field == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitField"));
        }
    }

    @Override
    public void visitParameter(@NotNull GrParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parameter", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitParameter"));
        }
        if (parameter.getParent() instanceof GrForClause) {
            this.visitVariable(parameter);
        }
    }

    @Override
    public void visitMethod(@NotNull GrMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitMethod"));
        }
    }

    @Override
    public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
        if (initializer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitClassInitializer"));
        }
    }

    @Override
    public void visitTypeDefinition(@NotNull GrTypeDefinition typeDefinition) {
        if (typeDefinition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeDefinition", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitTypeDefinition"));
        }
        if (!(typeDefinition instanceof GrAnonymousClassDefinition)) {
            return;
        }
        Set<ReadWriteVariableInstruction> vars = ControlFlowBuilder.collectUsedVariableWithoutInitialization(typeDefinition);
        for (ReadWriteVariableInstruction var : vars) {
            PsiElement element = var.getElement();
            if (element instanceof GrReferenceExpression && !this.myPolicy.isReferenceAccepted((GrReferenceExpression)element)) continue;
            this.addNodeAndCheckPending(new ReadWriteVariableInstruction(var.getVariableName(), typeDefinition, 1));
        }
        this.addNodeAndCheckPending(new InstructionImpl(typeDefinition));
    }

    private static Set<ReadWriteVariableInstruction> collectUsedVariableWithoutInitialization(GrTypeDefinition typeDefinition) {
        final LinkedHashSet vars = ContainerUtil.newLinkedHashSet();
        typeDefinition.acceptChildren(new GroovyRecursiveElementVisitor(){

            private void collectVars(Instruction[] flow) {
                ReadWriteVariableInstruction[] reads = ControlFlowBuilderUtil.getReadsWithoutPriorWrites(flow, false);
                Collections.addAll(vars, reads);
            }

            @Override
            public void visitField(@NotNull GrField field) {
                if (field == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder$1", "visitField"));
                }
                GrExpression initializer = field.getInitializerGroovy();
                if (initializer != null) {
                    Instruction[] flow = new ControlFlowBuilder(field.getProject()).buildControlFlow(initializer);
                    this.collectVars(flow);
                }
            }

            @Override
            public void visitMethod(@NotNull GrMethod method) {
                if (method == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder$1", "visitMethod"));
                }
                GrOpenBlock block = method.getBlock();
                if (block != null) {
                    this.collectVars(block.getControlFlow());
                }
            }

            @Override
            public void visitClassInitializer(@NotNull GrClassInitializer initializer) {
                if (initializer == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initializer", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder$1", "visitClassInitializer"));
                }
                GrOpenBlock block = initializer.getBlock();
                this.collectVars(block.getControlFlow());
            }
        });
        return vars;
    }

    @Override
    public void visitVariable(@NotNull GrVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitVariable"));
        }
        super.visitVariable(variable);
        if (this.myPolicy.isVariableInitialized(variable)) {
            ReadWriteVariableInstruction writeInst = new ReadWriteVariableInstruction(variable.getName(), variable, -1);
            this.addNodeAndCheckPending(writeInst);
        }
    }

    @Nullable
    private InstructionImpl findInstruction(PsiElement element) {
        for (InstructionImpl instruction : this.myInstructions) {
            if (!element.equals(instruction.getElement())) continue;
            return instruction;
        }
        return null;
    }

    @Override
    public void visitElement(@NotNull GroovyPsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/lang/psi/controlFlow/impl/ControlFlowBuilder", "visitElement"));
        }
        ProgressManager.checkCanceled();
        super.visitElement(element);
    }

    private static class ExceptionInfo {
        final GrCatchClause myClause;
        final List<InstructionImpl> myThrowers = new ArrayList<InstructionImpl>();

        private ExceptionInfo(GrCatchClause clause) {
            this.myClause = clause;
        }
    }
}

