/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.j2ee.webSphere.configuration;

import com.intellij.j2ee.webSphere.configuration.WebSphereCell;
import com.intellij.j2ee.webSphere.configuration.WebSphereProfileUtil;
import com.intellij.j2ee.webSphere.configuration.WebSphereVersion;
import java.io.File;
import java.util.Map;

public class WebSphereProfile {
    public static final WebSphereProfile[] EMPTY_ARRAY = new WebSphereProfile[0];
    private final WebSphereVersion myVersion;
    private final File myLocation;
    private final String myName;
    private final File myStartupScriptFile;
    private final File myShutdownScriptFile;
    private final File myClientTrustFile;
    private final File myClientKeyFile;
    private final Map<String, String> myProperties;

    public WebSphereProfile(WebSphereVersion version, File location, String name, File startupScriptFile, File shutdownScriptFile, Map<String, String> properties) {
        this.myVersion = version;
        this.myLocation = location;
        this.myName = name;
        this.myStartupScriptFile = startupScriptFile;
        this.myShutdownScriptFile = shutdownScriptFile;
        this.myClientTrustFile = new File(new File(location, "etc"), "DummyClientTrustFile.jks");
        this.myClientKeyFile = new File(new File(location, "etc"), "DummyClientKeyFile.jks");
        this.myProperties = properties;
    }

    public Map<String, String> getProperties() {
        return this.myProperties;
    }

    public File getLocation() {
        return this.myLocation;
    }

    public String getName() {
        return this.myName;
    }

    public File getStartupScriptFile() {
        return this.myStartupScriptFile;
    }

    public File getShutdownScriptFile() {
        return this.myShutdownScriptFile;
    }

    public WebSphereVersion getVersion() {
        return this.myVersion;
    }

    public String toString() {
        return this.getName();
    }

    public File getClientTrustFile() {
        return this.myClientTrustFile;
    }

    public File getClientKeyFile() {
        return this.myClientKeyFile;
    }

    public WebSphereCell[] getCells() {
        return WebSphereProfileUtil.getCells(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSphereProfile that = (WebSphereProfile)o;
        return this.myLocation.equals(that.myLocation) && this.myVersion.equals(that.myVersion);
    }

    public int hashCode() {
        int result = this.myVersion.hashCode();
        result = 29 * result + this.myLocation.hashCode();
        return result;
    }
}

