/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.inspections;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.analysis.annotator.EjbHighlightingMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.javaee.ejb.inspections.AbstractEjbInspection;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EjbThisExpressionInspection
extends AbstractEjbInspection {
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = EjbHighlightingMessages.message("inspection.name.this.reference", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbThisExpressionInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("EjbThisExpressionInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbThisExpressionInspection", "getShortName"));
        }
        return "EjbThisExpressionInspection";
    }

    @NotNull
    public HighlightDisplayLevel getDefaultLevel() {
        HighlightDisplayLevel highlightDisplayLevel = HighlightDisplayLevel.WARNING;
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/ejb/inspections/EjbThisExpressionInspection", "getDefaultLevel"));
        }
        return highlightDisplayLevel;
    }

    @Override
    protected JavaElementVisitor createJavaVisitor(final @NotNull ProblemsHolder holder, boolean onTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/javaee/ejb/inspections/EjbThisExpressionInspection", "createJavaVisitor"));
        }
        return new JavaElementVisitor(){

            public void visitThisExpression(PsiThisExpression expression) {
                PsiClass psiClass = PsiUtil.getTopLevelClass((PsiElement)expression);
                if (psiClass != null && EjbThisExpressionInspection.this.acceptClass(psiClass)) {
                    EjbThisExpressionInspection.checkThisExpression(holder, expression);
                }
            }
        };
    }

    private static void checkThisExpression(ProblemsHolder holder, PsiThisExpression expression) {
        PsiMethod method;
        PsiElement grandParent;
        PsiElement parent = expression.getParent();
        if (parent instanceof PsiReturnStatement) {
            PsiMethod method2 = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)expression, PsiMethod.class);
            if (method2 != null && method2.hasModifierProperty("public")) {
                holder.registerProblem((PsiElement)expression, EjbHighlightingMessages.message("this.escaped.returned", new Object[0]), new LocalQuickFix[0]);
            }
        } else if (parent instanceof PsiExpressionList && (grandParent = parent.getParent()) instanceof PsiMethodCallExpression && (method = ((PsiMethodCallExpression)grandParent).resolveMethod()) != null && method.hasModifierProperty("public")) {
            holder.registerProblem((PsiElement)expression, EjbHighlightingMessages.message("this.escaped.passed", new Object[0]), new LocalQuickFix[0]);
        }
    }
}

